#ifndef QRK_RUNNING_H
#define QRK_RUNNING_H

/*!
  \file
  \brief sW[̃C^[tF[X`

  \author Satofumi KAMIMURA

  $Id: Running.h 1219 2009-08-14 02:59:46Z satofumi $
*/

#include "Position.h"
#include "Point.h"


namespace qrk
{
  class Connection;
  class Coordinate;


  //! sW[̃C^[tF[X
  class Running
  {
  public:
    virtual ~Running(void)
    {
    }


    /*!
      \brief ԂԂ

      \return Ԃ

      <strong>Example</strong>
\code
DifferentialDrive run;
if (! run.connect(device, baudrate)) {
  // ڑɎsƂɁAG[bZ[W\
  printf("connect: %s\n", run.what());
  exit(1);
} \endcode
    */
    virtual const char* what(void) const = 0;


    /*!
      \brief ڑ

      \param[in] device ڑfoCX
      \param[in] baudrate ڑ{[[g

      \retval true 
      \retval false s

      <strong>Example</strong>
\code
const char device[] = "/dev/usb/ttyUSB0";
const long baudrate = 115200;
DifferentialDrive run;

// wfoCXɐڑ
if (! run.connect(device, baudrate)) {
  printf("connect: %s\n", run.what());
  exit(1);
} \endcode
    */
    virtual bool connect(const char* device, long baudrate) = 0;


    /*!
      \brief ؒf
    */
    virtual void disconnect(void) = 0;


    /*!
      \brief ڑԂԂ

      \retval true ڑ
      \retval false ؒf
    */
    virtual bool isConnected(void) const = 0;


    /*!
      \brief ڑIuWFNg̎w

      \param[in] connection ڑIuWFNg

      \attention ŕێĂڑIuWFNg̉̓[Uŕۏ؂邱
    */
    virtual void setConnection(Connection* connection) = 0;


    /*!
      \brief ڑIuWFNg̎擾

      \return ڑIuWFNg
    */
    virtual Connection* connection(void) = 0;


    /*!
      \brief Ǐ]

      !!! }

      \param[in] line Ǐ]钼
      \param[in] coordinate `Wn
    */
    virtual void followLine(const Position<long>& line,
                            const Coordinate* coordinate) = 0;

    /*!
      \brief Ǐ]Ē~

      Ǐ]sA̎w_ɐȐŒ~B

      !!! }

      \param[in] line Ǐ]钼
      \param[in] coordinate `Wn
    */
    virtual void stopLine(const Position<long>& line,
                          const Coordinate* coordinate) = 0;

    /*!
      \brief ~ʒǏ]

      radius ̒l̂ƂɁAvɑsB

      !!! }

      \param[in] center ~̒S
      \param[in] radius a
      \param[in] coordinate ~`Wn
    */
    virtual void followCircle(const Point<long>& center, long radius,
                      const Coordinate* coordinate) = 0;


    /*!
      \brief ~ʒǏ]

      ~ʒǏ]sAw肳ꂽpxɐȐŒ~B

      !!! }

      \param[in] center ~̒S
      \param[in] radius a
      \param[in] angle ~ʒu
      \param[in] coordinate ~`Wn
    */
    virtual void stopCircle(const Point<long>& center, long radius,
                            const Angle& angle,
                            const Coordinate* coordinate) = 0;


    /*!
      \brief ]

      angle_per_sec ̒l̂ƂɁAvɉ]B

      !!! }

      \param[in] angle_per_sec ]x [Angle / sec]
    */
    virtual void spin(const Angle& angle_per_sec) = 0;


    /*!
      \brief ̐

      𐧌䂷Bw肳ꂽ܂ł̉]͎ˑƂB

      !!! }

      angle  360 [deg] ȏオw肳ꂽꍇ coordinate {bgWn̏ꍇ́Åpx]Bcoordinate {bgWnłȂꍇ́A360 [deg] ̏]ƂȂʒu悤ɉ]B

      \param[in] angle ~
      \param[in] coordinate `Wn
    */
    virtual void rotate(const Angle& angle, const Coordinate* coordinate) = 0;


    /*!
      \brief ~

      xŒ~
    */
    virtual void stop(void) = 0;


    /*!
      \brief 莩Ȉʒu̎擾

      \return 莩Ȉʒu
    */
    virtual Position<long> position(Coordinate* coordinate) const = 0;


    /*!
      \brief ix̎擾

      \return ix [mm / sec]
    */
    virtual long straightVelocity(void) const = 0;


    /*!
      \brief ]x̎擾

      \return ]x [angle / sec]
    */
    virtual Angle rotateVelocity(void) const = 0;


    /*!
      \brief ʒu̐ݒ

      \param[in] coordinate ʒuw肷Wn
      \param[in] position ʒu
    */
    virtual void setRobotPosition(const Position<long>& position,
                                  const Coordinate* coordinate) = 0;


    /*!
      \brief ix̐ݒ

      \param[in] mm_per_sec ix [mm / sec]
    */
    virtual void setStraightVelocity(long mm_per_sec) = 0;


    /*!
      \brief ]x̐ݒ

      \param[in] angle_per_sec ]x [mm / sec]
    */
    virtual void setRotateVelocity(const Angle& angle_per_sec) = 0;


    /*!
      \brief ix̐ݒ

      \param[in] mm_per_sec2 ix [mm / sec^2]
    */
    virtual void setStraightAcceleration(long mm_per_sec2) = 0;


    /*!
      \brief ]x̐ݒ

      \param[in] angle_per_sec2 ]x [mm / sec^2]
    */
    virtual void setRotateAcceleration(const Angle& angle_per_sec2) = 0;


    /*!
      \brief ړR}h肵Ă邩̎擾

      ȉ̏ꍇ true ԂB
      - ɒǏ]ꍇɁAڕWɒǏ]
      - Œ~ꍇɁAŒ~Ă
      - ]ꍇɁAڕWxɒBĂ
      - ̐䒆ɁA̕Ē~Ă

      \retval true 䂪肵Ă
      \retval false ̓r
    */
    virtual bool isStable(void) const = 0;
  };
}

#endif /* !QRK_RUNNING_H */
