#ifndef QRK_POINT_3D_H
#define QRK_POINT_3D_H

/*!
  \file
  \brief ʒǔ^` (3D)

  \author Satofumi KAMIMURA

  $Id: Point3d.h 780 2009-05-05 08:16:41Z satofumi $
*/

namespace qrk
{
  /*!
    \brief ʒǔ^` (3D)
  */
  template<class T>
  class Point3d
  {
  public:
    T x;                        //!< X ʒu
    T y;                        //!< Y ʒu
    T z;                        //!< Z ʒu


    Point3d(void) : x(0), y(0), z(0)
    {
    }


    Point3d(const Point3d& rhs) : x(rhs.x), y(rhs.y), z(rhs.z)
    {
    }


    Point3d(T x_, T y_, T z_) : x(x_), y(y_), z(z_)
    {
    }


    Point3d& operator = (const Point3d& rhs)
    {
      this->x = rhs.x;
      this->y = rhs.y;
      this->z = rhs.z;

      return *this;
    }
  };
}

#endif /* !QRK_POINT_3D_H */
