/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.reader;

import java.util.Vector;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.data.QRCodeSymbol;
import jp.sourceforge.qrcode.exception.AlignmentPatternNotFoundException;
import jp.sourceforge.qrcode.exception.FinderPatternNotFoundException;
import jp.sourceforge.qrcode.exception.InvalidVersionException;
import jp.sourceforge.qrcode.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.exception.VersionInformationException;
import jp.sourceforge.qrcode.geom.Axis;
import jp.sourceforge.qrcode.geom.Line;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.geom.SamplingGrid;
import jp.sourceforge.qrcode.pattern.AlignmentPattern;
import jp.sourceforge.qrcode.pattern.FinderPattern;
import jp.sourceforge.qrcode.util.DebugCanvas;
import jp.sourceforge.qrcode.util.QRCodeUtility;

public class QRCodeImageReader {
    DebugCanvas canvas = QRCodeDecoder.getCanvas();
    public static int DECIMAL_POINT = 21;
    public static final boolean POINT_DARK = true;
    public static final boolean POINT_LIGHT = false;
    SamplingGrid samplingGrid;
    boolean[][] bitmap;

    boolean[][] applyMedianFilter(boolean[][] blArray, int n) {
        boolean[][] blArray2 = new boolean[blArray.length][blArray[0].length];
        for (int i = 1; i < blArray[0].length - 1; ++i) {
            for (int j = 1; j < blArray.length - 1; ++j) {
                int n2 = 0;
                for (int k = -1; k < 2; ++k) {
                    for (int i2 = -1; i2 < 2; ++i2) {
                        if (!blArray[j + i2][i + k]) continue;
                        ++n2;
                    }
                }
                if (n2 <= n) continue;
                blArray2[j][i] = true;
            }
        }
        return blArray2;
    }

    boolean[][] applyCrossMaskingMedianFilter(boolean[][] blArray, int n) {
        boolean[][] blArray2 = new boolean[blArray.length][blArray[0].length];
        for (int i = 2; i < blArray[0].length - 2; ++i) {
            for (int j = 2; j < blArray.length - 2; ++j) {
                int n2 = 0;
                for (int k = -2; k < 3; ++k) {
                    if (blArray[j + k][i]) {
                        ++n2;
                    }
                    if (!blArray[j][i + k]) continue;
                    ++n2;
                }
                if (n2 <= n) continue;
                blArray2[j][i] = true;
            }
        }
        return blArray2;
    }

    boolean[][] filterImage(int[][] nArray) {
        this.imageToGrayScale(nArray);
        boolean[][] blArray = this.grayScaleToBitmap(nArray);
        return blArray;
    }

    void imageToGrayScale(int[][] nArray) {
        for (int i = 0; i < nArray[0].length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                int n;
                int n2 = nArray[j][i] >> 16 & 0xFF;
                int n3 = nArray[j][i] >> 8 & 0xFF;
                int n4 = nArray[j][i] & 0xFF;
                nArray[j][i] = n = (n2 * 30 + n3 * 59 + n4 * 11) / 100;
            }
        }
    }

    boolean[][] grayScaleToBitmap(int[][] nArray) {
        int[][] nArray2 = this.getMiddleBrightnessPerArea(nArray);
        int n = nArray2.length;
        int n2 = nArray.length / n;
        int n3 = nArray[0].length / n;
        boolean[][] blArray = new boolean[nArray.length][nArray[0].length];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        blArray[n2 * j + i2][n3 * i + k] = nArray[n2 * j + i2][n3 * i + k] < nArray2[j][i];
                    }
                }
            }
        }
        return blArray;
    }

    int[][] getMiddleBrightnessPerArea(int[][] nArray) {
        int n;
        int n2;
        int n3 = nArray.length / 4;
        int n4 = nArray[0].length / 4;
        int[][][] nArray2 = new int[4][4][2];
        for (int i = 0; i < 4; ++i) {
            for (n2 = 0; n2 < 4; ++n2) {
                nArray2[n2][i][0] = 255;
                for (n = 0; n < n4; ++n) {
                    for (int j = 0; j < n3; ++j) {
                        int n5 = nArray[n3 * n2 + j][n4 * i + n];
                        if (n5 < nArray2[n2][i][0]) {
                            nArray2[n2][i][0] = n5;
                        }
                        if (n5 <= nArray2[n2][i][1]) continue;
                        nArray2[n2][i][1] = n5;
                    }
                }
            }
        }
        int[][] nArray3 = new int[4][4];
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                nArray3[n][n2] = (nArray2[n][n2][0] + nArray2[n][n2][1]) / 2;
            }
        }
        return nArray3;
    }

    public QRCodeSymbol getQRCodeSymbol(int[][] nArray) throws SymbolNotFoundException {
        int n = nArray.length < nArray[0].length ? nArray[0].length : nArray.length;
        DECIMAL_POINT = 23 - QRCodeUtility.sqrt(n / 256);
        this.bitmap = this.filterImage(nArray);
        this.canvas.println("Drawing matrix.");
        this.canvas.drawMatrix(this.bitmap);
        this.canvas.println("Scanning Finder Pattern.");
        FinderPattern finderPattern = null;
        try {
            finderPattern = FinderPattern.findFinderPattern(this.bitmap);
        }
        catch (FinderPatternNotFoundException finderPatternNotFoundException) {
            this.canvas.println("Not found, now retrying...");
            this.bitmap = this.applyCrossMaskingMedianFilter(this.bitmap, 5);
            this.canvas.drawMatrix(this.bitmap);
            try {
                finderPattern = FinderPattern.findFinderPattern(this.bitmap);
            }
            catch (FinderPatternNotFoundException finderPatternNotFoundException2) {
                throw new SymbolNotFoundException(finderPatternNotFoundException2.getMessage());
            }
            catch (VersionInformationException versionInformationException) {
                throw new SymbolNotFoundException(versionInformationException.getMessage());
            }
        }
        catch (VersionInformationException versionInformationException) {
            throw new SymbolNotFoundException(versionInformationException.getMessage());
        }
        this.canvas.println("FinderPattern at");
        String string = finderPattern.getCenter(0).toString() + finderPattern.getCenter(1).toString() + finderPattern.getCenter(2).toString();
        this.canvas.println(string);
        int[] nArray2 = finderPattern.getAngle();
        this.canvas.println("Angle*4098: Sin " + Integer.toString(nArray2[0]) + "  " + "Cos " + Integer.toString(nArray2[1]));
        int n2 = finderPattern.getVersion();
        this.canvas.println("Version: " + Integer.toString(n2));
        if (n2 < 1 || n2 > 40) {
            throw new InvalidVersionException("Invalid version: " + n2);
        }
        AlignmentPattern alignmentPattern = null;
        try {
            alignmentPattern = AlignmentPattern.findAlignmentPattern(this.bitmap, finderPattern);
        }
        catch (AlignmentPatternNotFoundException alignmentPatternNotFoundException) {
            throw new SymbolNotFoundException(alignmentPatternNotFoundException.getMessage());
        }
        int n3 = alignmentPattern.getCenter().length;
        this.canvas.println("AlignmentPatterns at");
        for (int i = 0; i < n3; ++i) {
            String string2 = "";
            for (int j = 0; j < n3; ++j) {
                string2 = string2 + alignmentPattern.getCenter()[j][i].toString();
            }
            this.canvas.println(string2);
        }
        this.canvas.println("Creating sampling grid.");
        this.samplingGrid = this.getSamplingGrid(finderPattern, alignmentPattern);
        this.canvas.println("Reading grid.");
        boolean[][] blArray = null;
        try {
            blArray = this.getQRCodeMatrix(this.bitmap, this.samplingGrid);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SymbolNotFoundException("Sampling grid exceeded image boundary");
        }
        return new QRCodeSymbol(blArray);
    }

    public QRCodeSymbol getQRCodeSymbolWithAdjustedGrid(Point point) throws IllegalStateException, SymbolNotFoundException {
        if (this.bitmap == null || this.samplingGrid == null) {
            throw new IllegalStateException("This method must be called after QRCodeImageReader.getQRCodeSymbol() called");
        }
        this.samplingGrid.adjust(point);
        this.canvas.println("Sampling grid adjusted d(" + point.getX() + "," + point.getY() + ")");
        boolean[][] blArray = null;
        try {
            blArray = this.getQRCodeMatrix(this.bitmap, this.samplingGrid);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SymbolNotFoundException("Sampling grid exceeded image boundary");
        }
        return new QRCodeSymbol(blArray);
    }

    SamplingGrid getSamplingGrid(FinderPattern finderPattern, AlignmentPattern alignmentPattern) {
        Point[][] pointArray = alignmentPattern.getCenter();
        int n = finderPattern.getVersion();
        int n2 = n / 7 + 2;
        pointArray[0][0] = finderPattern.getCenter(0);
        pointArray[n2 - 1][0] = finderPattern.getCenter(1);
        pointArray[0][n2 - 1] = finderPattern.getCenter(2);
        int n3 = n2 - 1;
        SamplingGrid samplingGrid = new SamplingGrid(n3);
        Axis axis = new Axis(finderPattern.getAngle(), finderPattern.getModuleSize());
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                ModulePitch modulePitch = new ModulePitch();
                Line line = new Line();
                Line line2 = new Line();
                axis.setModulePitch(finderPattern.getModuleSize());
                Point[][] pointArray2 = AlignmentPattern.getLogicalCenter(finderPattern);
                Point point = pointArray[j][i];
                Point point2 = pointArray[j + 1][i];
                Point point3 = pointArray[j][i + 1];
                Point point4 = pointArray[j + 1][i + 1];
                Point point5 = pointArray2[j][i];
                Point point6 = pointArray2[j + 1][i];
                Point point7 = pointArray2[j][i + 1];
                Point point8 = pointArray2[j + 1][i + 1];
                if (j == 0 && i == 0) {
                    if (n3 == 1) {
                        point = axis.translate(point, -3, -3);
                        point2 = axis.translate(point2, 3, -3);
                        point3 = axis.translate(point3, -3, 3);
                        point4 = axis.translate(point4, 6, 6);
                        point5.translate(-6, -6);
                        point6.translate(3, -3);
                        point7.translate(-3, 3);
                        point8.translate(6, 6);
                    } else {
                        point = axis.translate(point, -3, -3);
                        point2 = axis.translate(point2, 0, -6);
                        point3 = axis.translate(point3, -6, 0);
                        point5.translate(-6, -6);
                        point6.translate(0, -6);
                        point7.translate(-6, 0);
                    }
                } else if (j == 0 && i == n3 - 1) {
                    point = axis.translate(point, -6, 0);
                    point3 = axis.translate(point3, -3, 3);
                    point4 = axis.translate(point4, 0, 6);
                    point5.translate(-6, 0);
                    point7.translate(-6, 6);
                    point8.translate(0, 6);
                } else if (j == n3 - 1 && i == 0) {
                    point = axis.translate(point, 0, -6);
                    point2 = axis.translate(point2, 3, -3);
                    point4 = axis.translate(point4, 6, 0);
                    point5.translate(0, -6);
                    point6.translate(6, -6);
                    point8.translate(6, 0);
                } else if (j == n3 - 1 && i == n3 - 1) {
                    point3 = axis.translate(point3, 0, 6);
                    point2 = axis.translate(point2, 6, 0);
                    point4 = axis.translate(point4, 6, 6);
                    point7.translate(0, 6);
                    point6.translate(6, 0);
                    point8.translate(6, 6);
                } else if (j == 0) {
                    point = axis.translate(point, -6, 0);
                    point3 = axis.translate(point3, -6, 0);
                    point5.translate(-6, 0);
                    point7.translate(-6, 0);
                } else if (j == n3 - 1) {
                    point2 = axis.translate(point2, 6, 0);
                    point4 = axis.translate(point4, 6, 0);
                    point6.translate(6, 0);
                    point8.translate(6, 0);
                } else if (i == 0) {
                    point = axis.translate(point, 0, -6);
                    point2 = axis.translate(point2, 0, -6);
                    point5.translate(0, -6);
                    point6.translate(0, -6);
                } else if (i == n3 - 1) {
                    point3 = axis.translate(point3, 0, 6);
                    point4 = axis.translate(point4, 0, 6);
                    point7.translate(0, 6);
                    point8.translate(0, 6);
                }
                if (j == 0) {
                    point6.translate(1, 0);
                    point8.translate(1, 0);
                } else {
                    point5.translate(-1, 0);
                    point7.translate(-1, 0);
                }
                if (i == 0) {
                    point7.translate(0, 1);
                    point8.translate(0, 1);
                } else {
                    point5.translate(0, -1);
                    point6.translate(0, -1);
                }
                int n5 = point6.getX() - point5.getX();
                int n6 = point7.getY() - point5.getY();
                if (n < 7) {
                    n5 += 3;
                    n6 += 3;
                }
                modulePitch.top = this.getAreaModulePitch(point, point2, n5 - 1);
                modulePitch.left = this.getAreaModulePitch(point, point3, n6 - 1);
                modulePitch.bottom = this.getAreaModulePitch(point3, point4, n5 - 1);
                modulePitch.right = this.getAreaModulePitch(point2, point4, n6 - 1);
                line.setP1(point);
                line2.setP1(point);
                line.setP2(point3);
                line2.setP2(point2);
                samplingGrid.initGrid(j, i, n5, n6);
                for (n4 = 0; n4 < n5; ++n4) {
                    Line line3 = new Line(line.getP1(), line.getP2());
                    axis.setOrigin(line3.getP1());
                    axis.setModulePitch(modulePitch.top);
                    line3.setP1(axis.translate(n4, 0));
                    axis.setOrigin(line3.getP2());
                    axis.setModulePitch(modulePitch.bottom);
                    line3.setP2(axis.translate(n4, 0));
                    samplingGrid.setXLine(j, i, n4, line3);
                }
                for (n4 = 0; n4 < n6; ++n4) {
                    Line line4 = new Line(line2.getP1(), line2.getP2());
                    axis.setOrigin(line4.getP1());
                    axis.setModulePitch(modulePitch.left);
                    line4.setP1(axis.translate(0, n4));
                    axis.setOrigin(line4.getP2());
                    axis.setModulePitch(modulePitch.right);
                    line4.setP2(axis.translate(0, n4));
                    samplingGrid.setYLine(j, i, n4, line4);
                }
            }
        }
        return samplingGrid;
    }

    int getAreaModulePitch(Point point, Point point2, int n) {
        Line line = new Line(point, point2);
        int n2 = line.getLength();
        int n3 = (n2 << DECIMAL_POINT) / n;
        return n3;
    }

    boolean[][] getQRCodeMatrix(boolean[][] blArray, SamplingGrid samplingGrid) throws ArrayIndexOutOfBoundsException {
        int n = samplingGrid.getTotalWidth();
        this.canvas.println("gridSize=" + n);
        Point point = null;
        boolean[][] blArray2 = new boolean[n][n];
        for (int i = 0; i < samplingGrid.getHeight(); ++i) {
            for (int j = 0; j < samplingGrid.getWidth(); ++j) {
                Vector vector = new Vector();
                for (int k = 0; k < samplingGrid.getHeight(j, i); ++k) {
                    for (int i2 = 0; i2 < samplingGrid.getWidth(j, i); ++i2) {
                        int n2 = samplingGrid.getXLine(j, i, i2).getP1().getX();
                        int n3 = samplingGrid.getXLine(j, i, i2).getP1().getY();
                        int n4 = samplingGrid.getXLine(j, i, i2).getP2().getX();
                        int n5 = samplingGrid.getXLine(j, i, i2).getP2().getY();
                        int n6 = samplingGrid.getYLine(j, i, k).getP1().getX();
                        int n7 = samplingGrid.getYLine(j, i, k).getP1().getY();
                        int n8 = samplingGrid.getYLine(j, i, k).getP2().getX();
                        int n9 = samplingGrid.getYLine(j, i, k).getP2().getY();
                        int n10 = (n5 - n3) * (n6 - n8) - (n9 - n7) * (n2 - n4);
                        int n11 = (n2 * n5 - n4 * n3) * (n6 - n8) - (n6 * n9 - n8 * n7) * (n2 - n4);
                        int n12 = (n6 * n9 - n8 * n7) * (n5 - n3) - (n2 * n5 - n4 * n3) * (n9 - n7);
                        blArray2[samplingGrid.getX((int)j, (int)i2)][samplingGrid.getY((int)i, (int)k)] = blArray[n11 / n10][n12 / n10];
                        if (i != samplingGrid.getHeight() - 1 || j != samplingGrid.getWidth() - 1 || k != samplingGrid.getHeight(j, i) - 1 || i2 != samplingGrid.getWidth(j, i) - 1) continue;
                        point = new Point(n11 / n10, n12 / n10);
                    }
                }
            }
        }
        if (point != null && (point.getX() > blArray.length - 1 || point.getY() > blArray[0].length - 1)) {
            throw new ArrayIndexOutOfBoundsException("Sampling grid pointed out of image");
        }
        this.canvas.drawPoint(point, 0x8888FF);
        return blArray2;
    }

    protected class ModulePitch {
        public int top;
        public int left;
        public int bottom;
        public int right;

        protected ModulePitch() {
        }
    }
}

