/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode;

import java.util.Vector;
import jp.sourceforge.qrcode.data.QRCodeImage;
import jp.sourceforge.qrcode.data.QRCodeSymbol;
import jp.sourceforge.qrcode.exception.DecodingFailedException;
import jp.sourceforge.qrcode.exception.InvalidDataBlockException;
import jp.sourceforge.qrcode.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.reader.QRCodeDataBlockReader;
import jp.sourceforge.qrcode.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.util.DebugCanvas;
import jp.sourceforge.qrcode.util.DebugCanvasAdapter;
import jp.sourceforge.reedsolomon.RsDecode;

public class QRCodeDecoder {
    int numTryDecode = 0;
    QRCodeSymbol qrCodeSymbol;
    Vector results;
    Vector lastResults = new Vector();
    static DebugCanvas canvas;
    QRCodeImageReader imageReader;
    int numLastCorrectionFailures;

    public static void setCanvas(DebugCanvas debugCanvas) {
        canvas = debugCanvas;
    }

    public static DebugCanvas getCanvas() {
        return canvas;
    }

    public QRCodeDecoder() {
        this.results = new Vector();
        canvas = new DebugCanvasAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decode(QRCodeImage qRCodeImage) throws DecodingFailedException {
        Point[] pointArray = this.getAdjustPoints();
        Vector<DecodeResult> vector = new Vector<DecodeResult>();
        this.numTryDecode = 0;
        while (this.numTryDecode < pointArray.length) {
            try {
                DecodeResult decodeResult = this.decode(qRCodeImage, pointArray[this.numTryDecode]);
                if (decodeResult.isCorrectionSucceeded()) {
                    byte[] byArray = decodeResult.getDecodedBytes();
                    return byArray;
                }
                vector.addElement(decodeResult);
                canvas.println("Decoding succeeded but could not correct");
                canvas.println("all errors. Retrying..");
            }
            catch (DecodingFailedException decodingFailedException) {
                if (decodingFailedException.getMessage().indexOf("Finder Pattern") < 0) continue;
                throw decodingFailedException;
            }
            finally {
                ++this.numTryDecode;
            }
        }
        if (vector.size() == 0) {
            throw new DecodingFailedException("Give up decoding");
        }
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            DecodeResult decodeResult = (DecodeResult)vector.elementAt(i);
            if (decodeResult.getNumCorrectuionFailures() >= n2) continue;
            n2 = decodeResult.getNumCorrectuionFailures();
            n = i;
        }
        canvas.println("All trials need for correct error");
        canvas.println("Reporting #" + n + " that,");
        canvas.println("corrected minimum errors (" + n2 + ")");
        canvas.println("Decoding finished.");
        return ((DecodeResult)vector.elementAt(n)).getDecodedBytes();
    }

    Point[] getAdjustPoints() {
        int n;
        int n2;
        Vector<Point> vector = new Vector<Point>();
        for (n2 = 0; n2 < 4; ++n2) {
            vector.addElement(new Point(1, 1));
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i > -4; --i) {
            for (n = 0; n > -4; --n) {
                if (n == i || (n + i) % 2 != 0) continue;
                vector.addElement(new Point(n - n2, i - n3));
                n2 = n;
                n3 = i;
            }
        }
        Point[] pointArray = new Point[vector.size()];
        for (n = 0; n < pointArray.length; ++n) {
            pointArray[n] = (Point)vector.elementAt(n);
        }
        return pointArray;
    }

    DecodeResult decode(QRCodeImage qRCodeImage, Point point) throws DecodingFailedException {
        Object object;
        try {
            if (this.numTryDecode == 0) {
                canvas.println("Decoding started");
                object = this.imageToIntArray(qRCodeImage);
                this.imageReader = new QRCodeImageReader();
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbol((int[][])object);
            } else {
                canvas.println("--");
                canvas.println("Decoding restarted #" + this.numTryDecode);
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbolWithAdjustedGrid(point);
            }
        }
        catch (SymbolNotFoundException symbolNotFoundException) {
            throw new DecodingFailedException(symbolNotFoundException.getMessage());
        }
        canvas.println("Created QRCode symbol.");
        canvas.println("Reading symbol.");
        canvas.println("Version: " + this.qrCodeSymbol.getVersionReference());
        canvas.println("Mask pattern: " + this.qrCodeSymbol.getMaskPatternRefererAsString());
        object = this.qrCodeSymbol.getBlocks();
        canvas.println("Correcting data errors.");
        object = this.correctDataBlocks((int[])object);
        try {
            byte[] byArray = this.getDecodedByteArray((int[])object, this.qrCodeSymbol.getVersion(), this.qrCodeSymbol.getNumErrorCollectionCode());
            return new DecodeResult(byArray, this.numLastCorrectionFailures);
        }
        catch (InvalidDataBlockException invalidDataBlockException) {
            canvas.println(invalidDataBlockException.getMessage());
            throw new DecodingFailedException(invalidDataBlockException.getMessage());
        }
    }

    int[][] imageToIntArray(QRCodeImage qRCodeImage) {
        int n = qRCodeImage.getWidth();
        int n2 = qRCodeImage.getHeight();
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[j][i] = qRCodeImage.getPixel(j, i);
            }
        }
        return nArray;
    }

    int[] correctDataBlocks(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = this.qrCodeSymbol.getDataCapacity();
        int[] nArray2 = new int[n3];
        int n4 = this.qrCodeSymbol.getNumErrorCollectionCode();
        int n5 = this.qrCodeSymbol.getNumRSBlocks();
        int n6 = n4 / n5;
        if (n5 == 1) {
            RsDecode rsDecode = new RsDecode(n6 / 2);
            int n7 = rsDecode.decode(nArray);
            if (n7 > 0) {
                n += n7;
            } else if (n7 < 0) {
                ++n2;
            }
            return nArray;
        }
        int n8 = n3 % n5;
        if (n8 == 0) {
            int n9;
            int n10;
            int n11 = n3 / n5;
            int[][] nArray3 = new int[n5][n11];
            for (n10 = 0; n10 < n5; ++n10) {
                for (int i = 0; i < n11; ++i) {
                    nArray3[n10][i] = nArray[i * n5 + n10];
                }
                canvas.println("eccPerRSBlock=" + n6);
                RsDecode rsDecode = new RsDecode(n6 / 2);
                n9 = rsDecode.decode(nArray3[n10]);
                if (n9 > 0) {
                    n += n9;
                    continue;
                }
                if (n9 >= 0) continue;
                ++n2;
            }
            n10 = 0;
            for (int i = 0; i < n5; ++i) {
                for (n9 = 0; n9 < n11 - n6; ++n9) {
                    nArray2[n10++] = nArray3[i][n9];
                }
            }
        } else {
            int n12;
            int n13;
            int n14 = n3 / n5;
            int n15 = n3 / n5 + 1;
            int n16 = n5 - n8;
            int[][] nArray4 = new int[n16][n14];
            int[][] nArray5 = new int[n8][n15];
            for (n13 = 0; n13 < n5; ++n13) {
                int n17;
                RsDecode rsDecode;
                if (n13 < n16) {
                    n12 = 0;
                    for (int i = 0; i < n14; ++i) {
                        if (i == n14 - n6) {
                            n12 = n8;
                        }
                        nArray4[n13][i] = nArray[i * n5 + n13 + n12];
                    }
                    canvas.println("eccPerRSBlock(shorter)=" + n6);
                    rsDecode = new RsDecode(n6 / 2);
                    n17 = rsDecode.decode(nArray4[n13]);
                    if (n17 > 0) {
                        n += n17;
                        continue;
                    }
                    if (n17 >= 0) continue;
                    ++n2;
                    continue;
                }
                n12 = 0;
                for (int i = 0; i < n15; ++i) {
                    if (i == n14 - n6) {
                        n12 = n16;
                    }
                    nArray5[n13 - n16][i] = nArray[i * n5 + n13 - n12];
                }
                canvas.println("eccPerRSBlock(longer)=" + n6);
                rsDecode = new RsDecode(n6 / 2);
                n17 = rsDecode.decode(nArray5[n13 - n16]);
                if (n17 > 0) {
                    n += n17;
                    continue;
                }
                if (n17 >= 0) continue;
                ++n2;
            }
            n13 = 0;
            for (n12 = 0; n12 < n5; ++n12) {
                int n18;
                if (n12 < n16) {
                    for (n18 = 0; n18 < n14 - n6; ++n18) {
                        nArray2[n13++] = nArray4[n12][n18];
                    }
                    continue;
                }
                for (n18 = 0; n18 < n15 - n6; ++n18) {
                    nArray2[n13++] = nArray5[n12 - n16][n18];
                }
            }
        }
        if (n > 0) {
            canvas.println(String.valueOf(n) + " data errors corrected successfully.");
        } else {
            canvas.println("No errors found.");
        }
        this.numLastCorrectionFailures = n2;
        return nArray2;
    }

    byte[] getDecodedByteArray(int[] nArray, int n, int n2) throws InvalidDataBlockException {
        QRCodeDataBlockReader qRCodeDataBlockReader = new QRCodeDataBlockReader(nArray, n, n2);
        byte[] byArray = qRCodeDataBlockReader.getDataByte();
        return byArray;
    }

    class DecodeResult {
        int numCorrectionFailures;
        byte[] decodedBytes;

        public DecodeResult(byte[] byArray, int n) {
            this.decodedBytes = byArray;
            this.numCorrectionFailures = n;
        }

        public byte[] getDecodedBytes() {
            return this.decodedBytes;
        }

        public int getNumCorrectuionFailures() {
            return this.numCorrectionFailures;
        }

        public boolean isCorrectionSucceeded() {
            return QRCodeDecoder.this.numLastCorrectionFailures == 0;
        }
    }
}

