/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.J2SECanvas;
import example.J2SEImage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.exception.DecodingFailedException;
import jp.sourceforge.qrcode.util.ContentConverter;

public class QRCodeDecoderCUIExample {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: QRCodeDecoderCUIExample imageFilePath");
            System.exit(1);
        }
        int n = 0;
        int n2 = 0;
        QRCodeDecoder qRCodeDecoder = new QRCodeDecoder();
        long l = System.currentTimeMillis();
        for (String string : stringArray) {
            if (QRCodeDecoderCUIExample.processDecode(string, qRCodeDecoder)) {
                ++n;
                continue;
            }
            ++n2;
        }
        long l2 = System.currentTimeMillis() - l;
        System.err.println("Processed " + stringArray.length + " images in " + l2 + "ms (" + l2 / (long)stringArray.length + " images/sec)");
        System.err.println("OK: " + n + " NG: " + n2);
    }

    static boolean processDecode(String string, QRCodeDecoder qRCodeDecoder) {
        J2SECanvas j2SECanvas = new J2SECanvas();
        QRCodeDecoder.setCanvas(j2SECanvas);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = string.startsWith("http://") ? ImageIO.read(new URL(string)) : ImageIO.read(new File(string));
            String string2 = new String(qRCodeDecoder.decode(new J2SEImage(bufferedImage)));
            string2 = ContentConverter.convert(string2);
            System.out.println(string2);
        }
        catch (IOException iOException) {
            j2SECanvas.println("Error: " + iOException.getMessage() + " " + string);
            return false;
        }
        catch (DecodingFailedException decodingFailedException) {
            j2SECanvas.println("Error: " + decodingFailedException.getMessage());
            return false;
        }
        catch (Exception exception) {
            j2SECanvas.println("Error: " + exception.getMessage());
            return false;
        }
        return true;
    }
}

