/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.J2SECanvas;
import example.J2SEImage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import jp.sourceforge.qrcode.QRCodeDecoder;
import jp.sourceforge.qrcode.exception.DecodingFailedException;
import jp.sourceforge.qrcode.util.ContentConverter;

public class QRCodeDecoderCUIExample {
    public static void main(String[] stringArray) {
        J2SECanvas j2SECanvas = new J2SECanvas();
        if (stringArray.length < 1) {
            j2SECanvas.println("Usage: QRCodeDecoderCUIExample imageFilePath");
            System.exit(1);
        }
        QRCodeDecoder qRCodeDecoder = new QRCodeDecoder();
        QRCodeDecoder.setCanvas(j2SECanvas);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = stringArray[0].startsWith("http://") ? ImageIO.read(new URL(stringArray[0])) : ImageIO.read(new File(stringArray[0]));
            String string = new String(qRCodeDecoder.decode(new J2SEImage(bufferedImage)));
            string = ContentConverter.convert(string);
            System.out.println(string);
        }
        catch (IOException iOException) {
            j2SECanvas.println("Error: " + iOException.getMessage() + " " + stringArray[0]);
            System.exit(1);
        }
        catch (DecodingFailedException decodingFailedException) {
            j2SECanvas.println("Error: " + decodingFailedException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            j2SECanvas.println("Error: " + exception.getMessage());
            System.exit(1);
        }
    }
}

