/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec;

import java.util.Vector;
import jp.sourceforge.qrcode.codec.data.QRCodeImage;
import jp.sourceforge.qrcode.codec.data.QRCodeSymbol;
import jp.sourceforge.qrcode.codec.ecc.ReedSolomon;
import jp.sourceforge.qrcode.codec.exception.DecodingFailedException;
import jp.sourceforge.qrcode.codec.exception.InvalidDataBlockException;
import jp.sourceforge.qrcode.codec.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.codec.reader.QRCodeDataBlockReader;
import jp.sourceforge.qrcode.codec.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;
import jp.sourceforge.qrcode.codec.util.DebugCanvasAdapter;

public class QRCodeDecoder {
    QRCodeSymbol qrCodeSymbol;
    int numTryDecode = 0;
    int numErrors;
    Vector lastResults = new Vector();
    static DebugCanvas canvas;
    QRCodeImageReader imageReader;

    public static void setCanvas(DebugCanvas canvas) {
        QRCodeDecoder.canvas = canvas;
    }

    public static DebugCanvas getCanvas() {
        return canvas;
    }

    public QRCodeDecoder() {
        canvas = new DebugCanvasAdapter();
    }

    public byte[] decode(QRCodeImage qrCodeImage) throws DecodingFailedException {
        int[][] adjusts = new int[][]{new int[2], {2, 2}, {1, 1}, {-2, -2}, {-2, -2}};
        while (this.numTryDecode < adjusts.length) {
            try {
                return this.decode(qrCodeImage, adjusts[this.numTryDecode][0], adjusts[this.numTryDecode][1]);
            }
            catch (DecodingFailedException dfe) {
                if (dfe.getMessage().indexOf("Finder Pattern") >= 0) {
                    throw dfe;
                }
                ++this.numTryDecode;
            }
        }
        throw new DecodingFailedException("Give up decoding");
    }

    public byte[] decode(QRCodeImage qrCodeImage, int adjustX, int adjustY) throws DecodingFailedException {
        try {
            if (this.numTryDecode == 0) {
                canvas.println("Decoding started");
                int[][] intImage = this.imageToIntArray(qrCodeImage);
                this.imageReader = new QRCodeImageReader();
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbol(intImage);
            } else {
                canvas.println("--");
                canvas.println("Decoding restarted");
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbolWithAdjustedGrid(adjustX, adjustY);
            }
        }
        catch (SymbolNotFoundException e) {
            throw new DecodingFailedException(e.getMessage());
        }
        canvas.println("Created QRCode symbol.");
        canvas.println("Reading symbol.");
        canvas.println("Version: " + this.qrCodeSymbol.getVersionReference());
        canvas.println("Mask pattern: " + this.qrCodeSymbol.getMaskPatternRefererAsString());
        int[] blocks = this.qrCodeSymbol.getBlocks();
        canvas.println("Correcting data errors.");
        int[] dataBlocks = this.correctDataBlocks(blocks);
        if (this.numErrors > 3 && this.numTryDecode == 0) {
            canvas.println("Some errors (" + this.numErrors + ") detected");
            canvas.println("Now retry with other setting");
            throw new DecodingFailedException("Too many errors: " + String.valueOf(this.numErrors));
        }
        try {
            byte[] decodedByteArray = this.getDecodedByteArray(dataBlocks, this.qrCodeSymbol.getVersion());
            canvas.println("Decoding finished.");
            return decodedByteArray;
        }
        catch (InvalidDataBlockException e) {
            canvas.println(e.getMessage());
            throw new DecodingFailedException(e.getMessage());
        }
    }

    int[][] imageToIntArray(QRCodeImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] intImage = new int[width][height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                intImage[x][y] = image.getPixel(x, y);
                ++x;
            }
            ++y;
        }
        return intImage;
    }

    int[] correctDataBlocks(int[] blocks) {
        this.numErrors = 0;
        int dataCapacity = this.qrCodeSymbol.getDataCapacity();
        int[] dataBlocks = new int[dataCapacity];
        int numErrorCollectionCode = this.qrCodeSymbol.getNumErrorCollectionCode();
        int numRSBlocks = this.qrCodeSymbol.getNumRSBlocks();
        int eccPerRSBlock = numErrorCollectionCode / numRSBlocks;
        if (numRSBlocks == 1) {
            ReedSolomon corrector = new ReedSolomon(blocks);
            corrector.correct();
            this.numErrors += corrector.getNumCorrectedErrors();
            if (this.numErrors > 0) {
                canvas.println(String.valueOf(String.valueOf(this.numErrors)) + " data errors corrected.");
            } else {
                canvas.println("No errors found.");
            }
            return blocks;
        }
        int numLongerRSBlocks = dataCapacity % numRSBlocks;
        if (numLongerRSBlocks == 0) {
            int lengthRSBlock = dataCapacity / numRSBlocks;
            int[][] RSBlocks = new int[numRSBlocks][lengthRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock) {
                    RSBlocks[i][j] = blocks[j * numRSBlocks + i];
                    ++j;
                }
                ReedSolomon corrector = new ReedSolomon(RSBlocks[i]);
                corrector.correct();
                this.numErrors += corrector.getNumCorrectedErrors();
                ++i;
            }
            int p = 0;
            int i2 = 0;
            while (i2 < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock - eccPerRSBlock) {
                    dataBlocks[p++] = RSBlocks[i2][j];
                    ++j;
                }
                ++i2;
            }
        } else {
            int lengthShorterRSBlock = dataCapacity / numRSBlocks;
            int lengthLongerRSBlock = dataCapacity / numRSBlocks + 1;
            int numShorterRSBlocks = numRSBlocks - numLongerRSBlocks;
            int[][] shorterRSBlocks = new int[numShorterRSBlocks][lengthShorterRSBlock];
            int[][] longerRSBlocks = new int[numLongerRSBlocks][lengthLongerRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                ReedSolomon corrector;
                int mod;
                if (i < numShorterRSBlocks) {
                    mod = 0;
                    int j = 0;
                    while (j < lengthShorterRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numLongerRSBlocks;
                        }
                        shorterRSBlocks[i][j] = blocks[j * numRSBlocks + i + mod];
                        ++j;
                    }
                    corrector = new ReedSolomon(shorterRSBlocks[i]);
                    corrector.correct();
                    this.numErrors += corrector.getNumCorrectedErrors();
                } else {
                    mod = 0;
                    int j = 0;
                    while (j < lengthLongerRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numShorterRSBlocks;
                        }
                        longerRSBlocks[i - numShorterRSBlocks][j] = blocks[j * numRSBlocks + i - mod];
                        ++j;
                    }
                    corrector = new ReedSolomon(longerRSBlocks[i - numShorterRSBlocks]);
                    corrector.correct();
                    this.numErrors += corrector.getNumCorrectedErrors();
                }
                ++i;
            }
            int p = 0;
            int i3 = 0;
            while (i3 < numRSBlocks) {
                int j;
                if (i3 < numShorterRSBlocks) {
                    j = 0;
                    while (j < lengthShorterRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = shorterRSBlocks[i3][j];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < lengthLongerRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = longerRSBlocks[i3 - numShorterRSBlocks][j];
                        ++j;
                    }
                }
                ++i3;
            }
        }
        if (this.numErrors > 0) {
            canvas.println(String.valueOf(String.valueOf(this.numErrors)) + " data errors corrected.");
        }
        return dataBlocks;
    }

    byte[] getDecodedByteArray(int[] blocks, int version) throws InvalidDataBlockException {
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version);
        byte[] byteArray = reader.getDataByte();
        return byteArray;
    }

    String getDecodedString(int[] blocks, int version) throws InvalidDataBlockException {
        String dataString = null;
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version);
        try {
            dataString = reader.getDataString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidDataBlockException(e.getMessage());
        }
        return dataString;
    }
}

