package example;

import jp.sourceforge.qrcode.codec.QRCodeDecoder;
import jp.sourceforge.qrcode.codec.data.QRCodeImage;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;

// Smallest example of QRCode reader application

public class QRCodeDecoderCUIExample {
	public static void main(String[] args) {
		if (args.length < 1) {
			System.out.println("Usage: QRCodeDecoderCUIExample imageFilePath");
			System.exit(0);
		}
		QRCodeDecoder decoder = new QRCodeDecoder();
		File imageFile = new File(args[0]);
		BufferedImage image = null;
		try {
			image = ImageIO.read(imageFile);
		} catch (IOException e) {
			System.out.println("Could not read image file: " + args[0]);
		}
		String decodedData = new String(decoder.decode(new J2SEImage(image)));
		System.out.println(decodedData);
	}
}

class J2SEImage implements QRCodeImage {
	BufferedImage image;

	public J2SEImage(BufferedImage image) {
		this.image = image;
	}

	public int getWidth() {
		return image.getWidth();
	}
	
	public int getHeight() {
		return image.getHeight();
	}

	public int getPixel(int x, int y) {
		return image.getRGB(x, y);
	}
}
