/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader.pattern;

import jp.sourceforge.qrcode.codec.QRCodeDecoder;
import jp.sourceforge.qrcode.codec.exception.AlignmentPatternNotFoundException;
import jp.sourceforge.qrcode.codec.exception.UnsupportedVersionException;
import jp.sourceforge.qrcode.codec.geom.Axis;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.reader.pattern.FinderPattern;
import jp.sourceforge.qrcode.codec.reader.pattern.LogicalSeed;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;

public class AlignmentPattern {
    static final int RIGHT = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 3;
    static final int TOP = 4;
    static DebugCanvas canvas = QRCodeDecoder.getCanvas();
    Point[][] center;
    int patternDistance;

    AlignmentPattern(Point[][] center, int patternDistance) {
        this.center = center;
        this.patternDistance = patternDistance;
    }

    public static AlignmentPattern findAlignmentPattern(boolean[][] image, FinderPattern finderPattern) throws AlignmentPatternNotFoundException, UnsupportedVersionException {
        Point[][] logicalCenters = AlignmentPattern.getLogicalCenter(finderPattern);
        int logicalDistance = logicalCenters[1][0].getX() - logicalCenters[0][0].getX();
        Point[][] centers = null;
        centers = AlignmentPattern.getCenter(image, finderPattern, logicalCenters);
        return new AlignmentPattern(centers, logicalDistance);
    }

    public Point[][] getCenter() {
        return this.center;
    }

    public int getLogicalDistance() {
        return this.patternDistance;
    }

    static Point[][] getCenter(boolean[][] image, FinderPattern finderPattern, Point[][] logicalCenters) throws AlignmentPatternNotFoundException {
        int moduleSize = finderPattern.getModuleSize();
        Axis axis = new Axis(finderPattern.getAngle(), moduleSize);
        int sqrtCenters = logicalCenters.length;
        Point[][] centers = new Point[sqrtCenters][sqrtCenters];
        axis.setOrigin(finderPattern.getCenter(0));
        centers[0][0] = axis.translate(3, 3);
        canvas.drawCross(centers[0][0], 0xFFFF88);
        axis.setOrigin(finderPattern.getCenter(1));
        centers[sqrtCenters - 1][0] = axis.translate(-3, 3);
        canvas.drawCross(centers[sqrtCenters - 1][0], 0xFFFF88);
        axis.setOrigin(finderPattern.getCenter(2));
        centers[0][sqrtCenters - 1] = axis.translate(3, -3);
        canvas.drawCross(centers[0][sqrtCenters - 1], 0xFFFF88);
        Point tmpPoint = centers[0][0];
        int y = 0;
        while (y < sqrtCenters) {
            int x = 0;
            while (x < sqrtCenters) {
                if (!(x == 0 && y == 0 || x == 0 && y == sqrtCenters - 1 || x == sqrtCenters - 1 && y == 0)) {
                    int dx = 0;
                    int dy = 0;
                    Point target = null;
                    if (y == 0) {
                        if (x > 0 && x < sqrtCenters - 1) {
                            target = axis.translate(centers[x - 1][y], logicalCenters[x][y].getX() - logicalCenters[x - 1][y].getX(), 0);
                        }
                        centers[x][y] = new Point(target.getX(), target.getY());
                        canvas.drawCross(centers[x][y], 0xFF88888);
                    } else if (x == 0) {
                        if (y > 0 && y < sqrtCenters - 1) {
                            target = axis.translate(centers[x][y - 1], 0, logicalCenters[x][y].getY() - logicalCenters[x][y - 1].getY());
                        }
                        centers[x][y] = new Point(target.getX(), target.getY());
                        canvas.drawCross(centers[x][y], 0xFF88888);
                    } else {
                        dx = centers[x][y - 1].getX() - centers[x - 1][y - 1].getX();
                        dy = centers[x - 1][y].getY() - centers[x - 1][y - 1].getY();
                        target = axis.translate(centers[x - 1][y - 1], logicalCenters[x][y].getX() - logicalCenters[x - 1][y].getX(), logicalCenters[x][y].getY() - logicalCenters[x][y - 1].getY());
                        centers[x][y] = new Point(target.getX(), target.getY());
                    }
                    centers[x][y] = AlignmentPattern.getPrecisionCenter(image, centers[x][y]);
                    canvas.drawCross(centers[x][y], 0x88FF88);
                    canvas.drawLine(new Line(tmpPoint, centers[x][y]), 0xFFFF00);
                    tmpPoint = centers[x][y];
                }
                ++x;
            }
            ++y;
        }
        return centers;
    }

    static Point getPrecisionCenter(boolean[][] image, Point targetPoint) throws AlignmentPatternNotFoundException {
        int dy;
        int rx;
        if (!image[targetPoint.getX()][targetPoint.getY()]) {
            int scope = 0;
            boolean found = false;
            while (!found) {
                int dy2 = ++scope;
                while (dy2 > -scope) {
                    int dx = scope;
                    while (dx > -scope) {
                        if (image[targetPoint.getX() + dx][targetPoint.getY() + dy2]) {
                            targetPoint = new Point(targetPoint.getX() + dx, targetPoint.getY() + dy2);
                            found = true;
                        }
                        --dx;
                    }
                    --dy2;
                }
            }
        }
        int lx = rx = targetPoint.getX();
        int x = rx;
        int uy = dy = targetPoint.getY();
        int y = dy;
        while (lx >= 1 && !AlignmentPattern.targetPointOnTheCorner(image, lx, y, lx - 1, y)) {
            --lx;
        }
        while (rx < image.length - 1 && !AlignmentPattern.targetPointOnTheCorner(image, rx, y, rx + 1, y)) {
            ++rx;
        }
        while (uy >= 1 && !AlignmentPattern.targetPointOnTheCorner(image, x, uy, x, uy - 1)) {
            --uy;
        }
        while (dy < image[0].length - 1 && !AlignmentPattern.targetPointOnTheCorner(image, x, dy, x, dy + 1)) {
            ++dy;
        }
        return new Point((lx + rx + 1) / 2, (uy + dy + 1) / 2);
    }

    static boolean targetPointOnTheCorner(boolean[][] image, int x, int y, int nx, int ny) {
        if (x < 0 || y < 0 || nx < 0 || ny < 0 || x > image.length || y > image[0].length || nx > image.length || ny > image[0].length) {
            System.out.println("Overflow: x=" + x + ", y=" + y + " nx=" + nx + " ny=" + ny + " x.max=" + image.length + ", y.max=" + image[0].length);
            return true;
        }
        return !image[x][y] && image[nx][ny];
    }

    public static Point[][] getLogicalCenter(FinderPattern finderPattern) throws UnsupportedVersionException {
        int version = finderPattern.getVersion();
        Point[][] logicalCenters = new Point[1][1];
        int[] logicalSeeds = new int[1];
        if (version == 1) {
            return null;
        }
        if (version > 40) {
            throw new UnsupportedVersionException();
        }
        logicalSeeds = LogicalSeed.getSeed(version);
        logicalCenters = new Point[logicalSeeds.length][logicalSeeds.length];
        int col = 0;
        while (col < logicalCenters.length) {
            int row = 0;
            while (row < logicalCenters.length) {
                logicalCenters[row][col] = new Point(logicalSeeds[row], logicalSeeds[col]);
                ++row;
            }
            ++col;
        }
        return logicalCenters;
    }
}

