/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec;

import java.util.Vector;
import jp.sourceforge.qrcode.codec.data.QRCodeSymbol;
import jp.sourceforge.qrcode.codec.ecc.BCH15_5;
import jp.sourceforge.qrcode.codec.ecc.ReedSolomon;
import jp.sourceforge.qrcode.codec.exception.AlignmentPatternEdgeNotFoundException;
import jp.sourceforge.qrcode.codec.exception.DecodingFailedException;
import jp.sourceforge.qrcode.codec.exception.FinderPatternNotFoundException;
import jp.sourceforge.qrcode.codec.exception.IllegalDataBlockException;
import jp.sourceforge.qrcode.codec.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.codec.exception.VersionInformationException;
import jp.sourceforge.qrcode.codec.reader.QRCodeDataBlockReader;
import jp.sourceforge.qrcode.codec.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;

public class QRCodeDecoder {
    int internalScale = 2;
    QRCodeSymbol symbol;
    DebugCanvas canvas = DebugCanvas.getCanvas();

    public String decode(int[][] image) throws DecodingFailedException {
        this.canvas.println("Decoding started.");
        try {
            this.symbol = this.getQRCodeSymbol(image);
        }
        catch (SymbolNotFoundException e) {
            e.printStackTrace();
            throw new DecodingFailedException();
        }
        this.canvas.println("Created QRCode symbol.");
        this.canvas.println("Reading symbol.");
        boolean[] formatInformation = this.getFormatInformation(this.symbol);
        this.symbol.setFormatInformation(formatInformation);
        this.canvas.println("Version: " + this.symbol.getVersionReference());
        String maskPattern = Integer.toString(this.symbol.getMaskPatternReferer(), 2);
        int length = maskPattern.length();
        int i = 0;
        while (i < 3 - length) {
            maskPattern = "0" + maskPattern;
            ++i;
        }
        this.canvas.println("Mask pattern: " + maskPattern);
        this.canvas.println("Unmasking.");
        this.unmask(this.symbol);
        int[] blocks = this.getBlocks(this.symbol);
        this.canvas.println("Correcting data errors.");
        int[] dataBlocks = this.getCorrectedDataBlocks(blocks);
        String decodedString = "";
        try {
            decodedString = this.getDecodedString(dataBlocks, this.symbol.getVersion());
        }
        catch (IllegalDataBlockException e) {
            e.printStackTrace();
        }
        this.canvas.println("Decoding finished.");
        return decodedString;
    }

    boolean[][] processImage(int[][] image) {
        this.imageToGrayScale(image);
        boolean[][] bitmap = this.grayScaleToBitmap(image);
        boolean[][] bitmapEx = this.extendBitmap(bitmap, this.internalScale);
        return bitmapEx;
    }

    void imageToGrayScale(int[][] image) {
        int y = 0;
        while (y < image[0].length) {
            int x = 0;
            while (x < image.length) {
                int m;
                int r = image[x][y] >> 16 & 0xFF;
                int g = image[x][y] >> 8 & 0xFF;
                int b = image[x][y] & 0xFF;
                image[x][y] = m = (r * 30 + g * 59 + b * 11) / 100;
                ++x;
            }
            ++y;
        }
    }

    boolean[][] grayScaleToBitmap_(int[][] grayScale) {
        int[][] middle = this.findAreaMiddle(grayScale);
        int[] minmax = this.findMinMax(grayScale);
        boolean[][] bitmap = new boolean[grayScale.length][grayScale[0].length];
        int halftone = (minmax[0] + minmax[1]) / 2;
        int y = 0;
        while (y < grayScale[0].length) {
            int x = 0;
            while (x < grayScale.length) {
                bitmap[x][y] = grayScale[x][y] < halftone;
                ++x;
            }
            ++y;
        }
        return bitmap;
    }

    boolean[][] grayScaleToBitmap(int[][] grayScale) {
        int[][] middle = this.findAreaMiddle(grayScale);
        int sqrtNumArea = middle.length;
        int areaWidth = grayScale.length / sqrtNumArea;
        int areaHeight = grayScale[0].length / sqrtNumArea;
        boolean[][] bitmap = new boolean[grayScale.length][grayScale[0].length];
        int ay = 0;
        while (ay < sqrtNumArea) {
            int ax = 0;
            while (ax < sqrtNumArea) {
                int dy = 0;
                while (dy < areaHeight) {
                    int dx = 0;
                    while (dx < areaWidth) {
                        bitmap[areaWidth * ax + dx][areaHeight * ay + dy] = grayScale[areaWidth * ax + dx][areaHeight * ay + dy] < middle[ax][ay];
                        ++dx;
                    }
                    ++dy;
                }
                ++ax;
            }
            ++ay;
        }
        return bitmap;
    }

    int[] findMinMax(int[][] image) {
        int tempMin = Integer.MAX_VALUE;
        int tempMax = Integer.MIN_VALUE;
        int y = 0;
        while (y < image[0].length) {
            int x = 0;
            while (x < image.length) {
                if (image[x][y] < tempMin) {
                    tempMin = image[x][y];
                } else if (image[x][y] > tempMax) {
                    tempMax = image[x][y];
                }
                ++x;
            }
            ++y;
        }
        return new int[]{tempMin, tempMax};
    }

    int[][] findAreaMiddle(int[][] image) {
        int numSqrtArea = 4;
        int areaWidth = image.length / 4;
        int areaHeight = image[0].length / 4;
        int[][][] minmax = new int[4][4][2];
        int ay = 0;
        while (ay < 4) {
            int ax = 0;
            while (ax < 4) {
                minmax[ax][ay][0] = 255;
                int dy = 0;
                while (dy < areaHeight) {
                    int dx = 0;
                    while (dx < areaWidth) {
                        int target = image[areaWidth * ax + dx][areaHeight * ay + dy];
                        if (target < minmax[ax][ay][0]) {
                            minmax[ax][ay][0] = target;
                        }
                        if (target > minmax[ax][ay][1]) {
                            minmax[ax][ay][1] = target;
                        }
                        ++dx;
                    }
                    ++dy;
                }
                ++ax;
            }
            ++ay;
        }
        int[][] middle = new int[4][4];
        int ay2 = 0;
        while (ay2 < 4) {
            int ax = 0;
            while (ax < 4) {
                middle[ax][ay2] = (minmax[ax][ay2][0] + minmax[ax][ay2][1]) / 2;
                ++ax;
            }
            ++ay2;
        }
        return middle;
    }

    boolean[][] extendBitmap(boolean[][] bitmap, int scale) {
        boolean[][] bitmap2x = new boolean[bitmap.length * 2][bitmap[0].length * 2];
        int y = 0;
        while (y < bitmap[0].length) {
            int x = 0;
            while (x < bitmap.length) {
                if (bitmap[x][y]) {
                    int sx = 0;
                    while (sx < scale) {
                        int sy = 0;
                        while (sy < scale) {
                            bitmap2x[x * scale + sx][y * scale + sy] = true;
                            ++sy;
                        }
                        ++sx;
                    }
                }
                ++x;
            }
            ++y;
        }
        return bitmap2x;
    }

    QRCodeSymbol getQRCodeSymbol(int[][] image) throws SymbolNotFoundException {
        this.canvas.println("Creating bitmap.");
        boolean[][] bitmap = this.processImage(image);
        QRCodeImageReader reader = new QRCodeImageReader();
        QRCodeSymbol symbol = null;
        try {
            symbol = reader.getQRCodeSymbol(bitmap, this.internalScale);
        }
        catch (FinderPatternNotFoundException e) {
            throw new SymbolNotFoundException();
        }
        catch (VersionInformationException e2) {
            throw new SymbolNotFoundException();
        }
        catch (AlignmentPatternEdgeNotFoundException e3) {
            throw new SymbolNotFoundException();
        }
        return symbol;
    }

    boolean[] getFormatInformation(QRCodeSymbol qRCodeMatrix) {
        boolean[] modules = new boolean[15];
        int i = 0;
        while (i <= 5) {
            modules[i] = qRCodeMatrix.getElement(8, i);
            ++i;
        }
        modules[6] = qRCodeMatrix.getElement(8, 7);
        modules[7] = qRCodeMatrix.getElement(8, 8);
        modules[8] = qRCodeMatrix.getElement(7, 8);
        i = 9;
        while (i <= 14) {
            modules[i] = qRCodeMatrix.getElement(14 - i, 8);
            ++i;
        }
        int maskPattern = 21522;
        int i2 = 0;
        while (i2 <= 14) {
            boolean xorBit = false;
            xorBit = (maskPattern >>> i2 & 1) == 1;
            modules[i2] = modules[i2] != xorBit;
            ++i2;
        }
        BCH15_5 corrector = new BCH15_5(modules);
        boolean[] output = corrector.correct();
        int numError = corrector.getNumCorrectedError();
        if (numError > 0) {
            this.canvas.println(String.valueOf(String.valueOf(numError)) + " format errors corrected.");
        }
        boolean[] formatInformation = new boolean[5];
        int i3 = 0;
        while (i3 < 5) {
            formatInformation[i3] = output[10 + i3];
            ++i3;
        }
        return formatInformation;
    }

    void unmask(QRCodeSymbol symbol) {
        int maskPatternReferer = symbol.getMaskPatternReferer();
        boolean[][] maskPattern = this.generateMaskPattern(symbol);
        int size = symbol.getWidth();
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                if (maskPattern[x][y]) {
                    symbol.reverseElement(x, y);
                }
                ++x;
            }
            ++y;
        }
    }

    boolean[][] generateMaskPattern(QRCodeSymbol symbol) {
        int maskPatternReferer = symbol.getMaskPatternReferer();
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        boolean[][] maskPattern = new boolean[width][height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                if (!symbol.isInFunctionPattern(x, y)) {
                    switch (maskPatternReferer) {
                        case 0: {
                            if ((x + y) % 2 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 1: {
                            if (y % 2 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 2: {
                            if (x % 3 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 3: {
                            if ((x + y) % 3 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 4: {
                            if ((x / 3 + y / 2) % 2 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 5: {
                            if (x * y % 2 + x * y % 3 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 6: {
                            if ((x * y % 2 + x * y % 3) % 2 != 0) break;
                            maskPattern[x][y] = true;
                            break;
                        }
                        case 7: {
                            if ((x * y % 3 + (x + y) % 2) % 2 != 0) break;
                            maskPattern[x][y] = true;
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
        return maskPattern;
    }

    int[] getBlocks(QRCodeSymbol symbol) {
        int width = symbol.getWidth();
        int height = symbol.getHeight();
        int x = width - 1;
        int y = height - 1;
        Vector<Boolean> codeBits = new Vector<Boolean>();
        Vector<Integer> codeWords = new Vector<Integer>();
        int tempWord = 0;
        int figure = 7;
        int isNearFinish = 0;
        boolean READ_UP = true;
        boolean READ_DOWN = false;
        boolean direction = true;
        do {
            codeBits.addElement(new Boolean(symbol.getElement(x, y)));
            if (symbol.getElement(x, y)) {
                tempWord += 1 << figure;
            }
            if (--figure == -1) {
                codeWords.addElement(new Integer(tempWord));
                figure = 7;
                tempWord = 0;
            }
            do {
                if (direction) {
                    if ((x + isNearFinish) % 2 == 0) {
                        --x;
                        continue;
                    }
                    if (y > 0) {
                        ++x;
                        --y;
                        continue;
                    }
                    if (--x == 6) {
                        --x;
                        isNearFinish = 1;
                    }
                    direction = false;
                    continue;
                }
                if ((x + isNearFinish) % 2 == 0) {
                    --x;
                    continue;
                }
                if (y < height - 1) {
                    ++x;
                    ++y;
                    continue;
                }
                if (--x == 6) {
                    --x;
                    isNearFinish = 1;
                }
                direction = true;
            } while (symbol.isInFunctionPattern(x, y));
        } while (x != -1);
        int[] gotWords = new int[codeWords.size()];
        int i = 0;
        while (i < codeWords.size()) {
            Integer temp = (Integer)codeWords.elementAt(i);
            gotWords[i] = temp;
            ++i;
        }
        return gotWords;
    }

    int[] getCorrectedDataBlocks(int[] blocks) {
        int numErrors = 0;
        int version = this.symbol.getVersion();
        int errorCollectionLevel = this.symbol.getErrorCollectionLevel();
        int dataCapacity = this.symbol.getDataCapacity();
        int[] dataBlocks = new int[dataCapacity];
        int numErrorCollectionCode = this.symbol.getNumErrorCollectionCode();
        int numRSBlocks = this.symbol.getNumRSBlocks();
        int eccPerRSBlock = numErrorCollectionCode / numRSBlocks;
        if (numRSBlocks == 1) {
            ReedSolomon corrector = new ReedSolomon(blocks);
            corrector.correct();
            if ((numErrors += corrector.getNumCorrectedErrors()) > 0) {
                this.canvas.println(String.valueOf(String.valueOf(numErrors)) + " data errors corrected.");
            } else {
                this.canvas.println("No errors found.");
            }
            return blocks;
        }
        int numLongerRSBlocks = dataCapacity % numRSBlocks;
        if (numLongerRSBlocks == 0) {
            int lengthRSBlock = dataCapacity / numRSBlocks;
            int[][] RSBlocks = new int[numRSBlocks][lengthRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock) {
                    RSBlocks[i][j] = blocks[j * numRSBlocks + i];
                    ++j;
                }
                ReedSolomon corrector = new ReedSolomon(RSBlocks[i]);
                corrector.correct();
                numErrors += corrector.getNumCorrectedErrors();
                ++i;
            }
            int p = 0;
            int i2 = 0;
            while (i2 < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock - eccPerRSBlock) {
                    dataBlocks[p++] = RSBlocks[i2][j];
                    ++j;
                }
                ++i2;
            }
        } else {
            int lengthShorterRSBlock = dataCapacity / numRSBlocks;
            int lengthLongerRSBlock = dataCapacity / numRSBlocks + 1;
            int numShorterRSBlocks = numRSBlocks - numLongerRSBlocks;
            int[][] shorterRSBlocks = new int[numShorterRSBlocks][lengthShorterRSBlock];
            int[][] longerRSBlocks = new int[numLongerRSBlocks][lengthLongerRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                ReedSolomon corrector;
                int mod;
                if (i < numShorterRSBlocks) {
                    mod = 0;
                    int j = 0;
                    while (j < lengthShorterRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numLongerRSBlocks;
                        }
                        shorterRSBlocks[i][j] = blocks[j * numRSBlocks + i + mod];
                        ++j;
                    }
                    corrector = new ReedSolomon(shorterRSBlocks[i]);
                    corrector.correct();
                    numErrors += corrector.getNumCorrectedErrors();
                } else {
                    mod = 0;
                    int j = 0;
                    while (j < lengthLongerRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numShorterRSBlocks;
                        }
                        longerRSBlocks[i - numShorterRSBlocks][j] = blocks[j * numRSBlocks + i - mod];
                        ++j;
                    }
                    corrector = new ReedSolomon(longerRSBlocks[i - numShorterRSBlocks]);
                    corrector.correct();
                    numErrors += corrector.getNumCorrectedErrors();
                }
                ++i;
            }
            int p = 0;
            int i3 = 0;
            while (i3 < numRSBlocks) {
                int j;
                if (i3 < numShorterRSBlocks) {
                    j = 0;
                    while (j < lengthShorterRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = shorterRSBlocks[i3][j];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < lengthLongerRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = longerRSBlocks[i3 - numShorterRSBlocks][j];
                        ++j;
                    }
                }
                ++i3;
            }
        }
        if (numErrors > 0) {
            this.canvas.println(String.valueOf(String.valueOf(numErrors)) + " data errors corrected.");
        }
        return dataBlocks;
    }

    String getDecodedString(int[] blocks, int version) throws IllegalDataBlockException {
        String dataString = null;
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version);
        try {
            dataString = reader.getDataString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalDataBlockException();
        }
        return dataString;
    }

    public DebugCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(DebugCanvas canvas) {
        this.canvas = canvas;
    }
}

