/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.reader;

import jp.sourceforge.qrcode.codec.data.QRCodeSymbol;
import jp.sourceforge.qrcode.codec.geom.Axis;
import jp.sourceforge.qrcode.codec.geom.Line;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.reader.pattern.AlignmentPattern;
import jp.sourceforge.qrcode.codec.reader.pattern.FinderPattern;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;

public class QRCodeImageReader {
    DebugCanvas canvas = DebugCanvas.getCanvas();
    public static final int DECIMAL_POINT = 23;
    public static final boolean POINT_DARK = true;
    public static final boolean POINT_LIGHT = false;

    boolean[][] applyMedianFilter(boolean[][] image, int threshold) {
        boolean[][] filteredMatrix = new boolean[image.length][image[0].length];
        int y = 1;
        while (y < image[0].length - 1) {
            int x = 1;
            while (x < image.length - 1) {
                int numPointDark = 0;
                int fy = -1;
                while (fy < 2) {
                    int fx = -1;
                    while (fx < 2) {
                        if (image[x + fx][y + fy]) {
                            ++numPointDark;
                        }
                        ++fx;
                    }
                    ++fy;
                }
                if (numPointDark > threshold) {
                    filteredMatrix[x][y] = true;
                }
                ++x;
            }
            ++y;
        }
        return filteredMatrix;
    }

    public QRCodeSymbol getQRCodeSymbol(boolean[][] image) {
        this.canvas.println("Drawing matrix.");
        this.canvas.drawMatrix(image);
        this.canvas.println("Scanning Finder Pattern.");
        FinderPattern finderPattern = FinderPattern.findFinderPattern(image);
        if (finderPattern.getCenter() == null) {
            this.canvas.println("Not found, now retrying...");
            image = this.applyMedianFilter(image, 5);
            this.canvas.drawMatrix(image);
            finderPattern = FinderPattern.findFinderPattern(image);
            if (finderPattern.getCenter() == null) {
                this.canvas.println("ERROR: Finder pattern not found");
                return null;
            }
        }
        this.canvas.println("FinderPattern at");
        String finderPatternCoordinates = String.valueOf(finderPattern.getCenter(0).toString()) + finderPattern.getCenter(1).toString() + finderPattern.getCenter(2).toString();
        this.canvas.println(finderPatternCoordinates);
        int[] sincos = finderPattern.getAngle();
        this.canvas.println("Angle*4098: Sin " + Integer.toString(sincos[0]) + "  " + "Cos " + Integer.toString(sincos[1]));
        Line[][][][] samplingGrid = new Line[1][1][1][1];
        int version = finderPattern.getVersion();
        if (version < 1) {
            this.canvas.println("ERROR: Invalid version information," + version);
            return null;
        }
        if (version > 13) {
            this.canvas.println("ERROR: Unsupported version " + version);
            return null;
        }
        this.canvas.println("Version: " + Integer.toString(version));
        AlignmentPattern alignmentPattern = null;
        if (version > 1) {
            alignmentPattern = AlignmentPattern.findAlignmentPattern(image, finderPattern);
            int matrixLength = alignmentPattern.getCenter().length;
            this.canvas.println("AlignmentPatterns at");
            int y = 0;
            while (y < matrixLength) {
                String alignmentPatternCoordinates = "";
                int x = 0;
                while (x < matrixLength) {
                    alignmentPatternCoordinates = String.valueOf(alignmentPatternCoordinates) + alignmentPattern.getCenter()[x][y].toString();
                    ++x;
                }
                this.canvas.println(alignmentPatternCoordinates);
                ++y;
            }
        }
        this.canvas.println("Creating sampling grid.");
        if (version == 1) {
            samplingGrid = this.getSamplingGrid1(finderPattern);
        } else if (version >= 2 && version <= 6) {
            samplingGrid = this.getSamplingGrid2_6(finderPattern, alignmentPattern);
        } else if (version >= 7 && version <= 13) {
            samplingGrid = this.getSamplingGrid7_13(finderPattern, alignmentPattern);
        }
        this.canvas.println("Reading grid.");
        boolean[][] qRCodeMatrix = this.getQRCodeMatrix(image, samplingGrid);
        return new QRCodeSymbol(qRCodeMatrix);
    }

    Line[][][][] getSamplingGrid1(FinderPattern finderPattern) {
        int sqrtNumArea = 1;
        int sqrtNumModules = finderPattern.getSqrtNumModules();
        int sqrtNumAreaModules = sqrtNumModules / sqrtNumArea;
        Point[] centers = finderPattern.getCenter();
        int logicalDistance = 14;
        Line[][][][] samplingGrid = new Line[sqrtNumArea][sqrtNumArea][2][sqrtNumAreaModules];
        int[] modulePitch = new int[]{this.getAreaModulePitch(centers[0], centers[1], logicalDistance), this.getAreaModulePitch(centers[0], centers[2], logicalDistance)};
        Line baseLineX = new Line(finderPattern.getCenter(0), finderPattern.getCenter(2));
        int sin = finderPattern.getAngle()[0];
        int cos = finderPattern.getAngle()[1];
        Axis axis = new Axis(sin, cos, modulePitch[0]);
        axis.setOrigin(baseLineX.getP1());
        baseLineX.setP1(axis.translate(-3, -3));
        axis.setModulePitch(modulePitch[1]);
        axis.setOrigin(baseLineX.getP2());
        baseLineX.setP2(axis.translate(-3, 3));
        Line baseLineY = new Line(finderPattern.getCenter(0), finderPattern.getCenter(1));
        axis.setModulePitch(modulePitch[1]);
        axis.setOrigin(baseLineY.getP1());
        baseLineY.setP1(axis.translate(-3, -3));
        axis.setModulePitch(modulePitch[1]);
        axis.setOrigin(baseLineY.getP2());
        baseLineY.setP2(axis.translate(3, -3));
        baseLineX.translate(1, 1);
        baseLineY.translate(1, 1);
        int i = 0;
        while (i < sqrtNumAreaModules) {
            Line gridLineX = new Line(baseLineX.getP1(), baseLineX.getP2());
            axis.setOrigin(gridLineX.getP1());
            axis.setModulePitch(modulePitch[0]);
            gridLineX.setP1(axis.translate(i, 0));
            axis.setOrigin(gridLineX.getP2());
            axis.setModulePitch(modulePitch[0]);
            gridLineX.setP2(axis.translate(i, 0));
            Line gridLineY = new Line(baseLineY.getP1(), baseLineY.getP2());
            axis.setOrigin(gridLineY.getP1());
            axis.setModulePitch(modulePitch[1]);
            gridLineY.setP1(axis.translate(0, i));
            axis.setOrigin(gridLineY.getP2());
            axis.setModulePitch(modulePitch[1]);
            gridLineY.setP2(axis.translate(0, i));
            samplingGrid[0][0][0][i] = gridLineX;
            samplingGrid[0][0][1][i] = gridLineY;
            ++i;
        }
        int ay = 0;
        while (ay < samplingGrid[0].length) {
            int ax = 0;
            while (ax < samplingGrid.length) {
                this.canvas.drawLines(samplingGrid[ax][ay][0], 0xBBBBFF);
                this.canvas.drawLines(samplingGrid[ax][ay][1], 0xBBBBFF);
                ++ax;
            }
            ++ay;
        }
        return samplingGrid;
    }

    Line[][][][] getSamplingGrid2_6(FinderPattern finderPattern, AlignmentPattern alignmentPattern) {
        Point[][] centers = alignmentPattern.getCenter();
        centers[0][0] = finderPattern.getCenter(0);
        centers[1][0] = finderPattern.getCenter(1);
        centers[0][1] = finderPattern.getCenter(2);
        int sqrtNumModules = finderPattern.getSqrtNumModules();
        Line[][][][] samplingGrid = new Line[1][1][2][sqrtNumModules];
        int logicalDistance = alignmentPattern.getLogicalDistance();
        int sin = finderPattern.getAngle()[0];
        int cos = finderPattern.getAngle()[1];
        Axis axis = new Axis(sin, cos, finderPattern.getModuleSize());
        int[] modulePitch = new int[4];
        modulePitch[0] = this.getAreaModulePitch(centers[0][0], centers[1][0], logicalDistance + 6);
        modulePitch[1] = this.getAreaModulePitch(centers[0][0], centers[0][1], logicalDistance + 6);
        axis.setModulePitch(modulePitch[0]);
        axis.setOrigin(centers[0][1]);
        modulePitch[2] = this.getAreaModulePitch(axis.translate(0, -3), centers[1][1], logicalDistance + 3);
        axis.setModulePitch(modulePitch[1]);
        axis.setOrigin(centers[1][0]);
        modulePitch[3] = this.getAreaModulePitch(axis.translate(-3, 0), centers[1][1], logicalDistance + 3);
        Line baseLineX = new Line();
        Line baseLineY = new Line();
        axis.setOrigin(centers[0][0]);
        modulePitch[0] = this.getAreaModulePitch(centers[0][0], centers[1][0], logicalDistance + 6);
        modulePitch[1] = this.getAreaModulePitch(centers[0][0], centers[0][1], logicalDistance + 6);
        axis.setModulePitch(modulePitch[0]);
        axis.setOrigin(centers[0][1]);
        modulePitch[2] = this.getAreaModulePitch(axis.translate(0, -3), centers[1][1], logicalDistance + 3);
        axis.setModulePitch(modulePitch[1]);
        axis.setOrigin(centers[1][0]);
        modulePitch[3] = this.getAreaModulePitch(axis.translate(-3, 0), centers[1][1], logicalDistance + 3);
        axis.setOrigin(centers[0][0]);
        axis.setModulePitch(modulePitch[0]);
        baseLineX.setP1(axis.translate(-3, -3));
        axis.setModulePitch(modulePitch[1]);
        baseLineY.setP1(axis.translate(-3, -3));
        axis.setOrigin(centers[0][1]);
        axis.setModulePitch(modulePitch[2]);
        baseLineX.setP2(axis.translate(-3, 3));
        axis.setOrigin(centers[1][0]);
        axis.setModulePitch(modulePitch[3]);
        baseLineY.setP2(axis.translate(3, -3));
        baseLineX.translate(1, 1);
        baseLineY.translate(1, 1);
        int i = 0;
        while (i < sqrtNumModules) {
            Line gridLineX = new Line(baseLineX.getP1(), baseLineX.getP2());
            axis.setOrigin(gridLineX.getP1());
            axis.setModulePitch(modulePitch[0]);
            gridLineX.setP1(axis.translate(i, 0));
            axis.setOrigin(gridLineX.getP2());
            axis.setModulePitch(modulePitch[2]);
            gridLineX.setP2(axis.translate(i, 0));
            Line gridLineY = new Line(baseLineY.getP1(), baseLineY.getP2());
            axis.setOrigin(gridLineY.getP1());
            axis.setModulePitch(modulePitch[1]);
            gridLineY.setP1(axis.translate(0, i));
            axis.setOrigin(gridLineY.getP2());
            axis.setModulePitch(modulePitch[3]);
            gridLineY.setP2(axis.translate(0, i));
            samplingGrid[0][0][0][i] = gridLineX;
            samplingGrid[0][0][1][i] = gridLineY;
            ++i;
        }
        int ay = 0;
        while (ay < samplingGrid[0].length) {
            int ax = 0;
            while (ax < samplingGrid.length) {
                this.canvas.drawLines(samplingGrid[ax][ay][0], 0xBBBBFF);
                this.canvas.drawLines(samplingGrid[ax][ay][1], 0xBBBBFF);
                ++ax;
            }
            ++ay;
        }
        return samplingGrid;
    }

    Line[][][][] getSamplingGrid7_13(FinderPattern finderPattern, AlignmentPattern alignmentPattern) {
        int ax;
        Point[][] centers = alignmentPattern.getCenter();
        centers[0][0] = finderPattern.getCenter(0);
        centers[2][0] = finderPattern.getCenter(1);
        centers[0][2] = finderPattern.getCenter(2);
        int sqrtNumModules = finderPattern.getSqrtNumModules();
        int sqrtNumArea = 2;
        int sqrtNumAreaModules = sqrtNumModules / sqrtNumArea;
        Line[][][][] samplingGrid = new Line[sqrtNumArea][sqrtNumArea][2][++sqrtNumAreaModules];
        int logicalDistance = alignmentPattern.getLogicalDistance();
        int sin = finderPattern.getAngle()[0];
        int cos = finderPattern.getAngle()[1];
        Axis axis = new Axis(sin, cos, finderPattern.getModuleSize());
        int ay = 0;
        while (ay < sqrtNumArea) {
            ax = 0;
            while (ax < sqrtNumArea) {
                int[] modulePitch = new int[4];
                Line baseLineX = new Line();
                Line baseLineY = new Line();
                axis.setModulePitch(finderPattern.getModuleSize());
                if (ax == 0 && ay == 0) {
                    axis.setOrigin(centers[0][0]);
                    modulePitch[0] = this.getAreaModulePitch(axis.translate(0, 3), centers[1][0], logicalDistance + 3);
                    modulePitch[1] = this.getAreaModulePitch(axis.translate(3, 0), centers[0][1], logicalDistance + 3);
                    axis.setModulePitch(modulePitch[0]);
                    modulePitch[2] = this.getAreaModulePitch(centers[0][1], centers[1][1], logicalDistance);
                    axis.setModulePitch(modulePitch[1]);
                    modulePitch[3] = this.getAreaModulePitch(centers[1][0], centers[1][1], logicalDistance);
                    axis.setModulePitch(modulePitch[0]);
                    baseLineX.setP1(axis.translate(-3, -3));
                    axis.setModulePitch(modulePitch[1]);
                    baseLineY.setP1(axis.translate(-3, -3));
                    axis.setOrigin(centers[0][1]);
                    axis.setModulePitch(modulePitch[2]);
                    baseLineX.setP2(axis.translate(-6, 0));
                    axis.setOrigin(centers[1][0]);
                    axis.setModulePitch(modulePitch[3]);
                    baseLineY.setP2(axis.translate(0, -6));
                } else if (ax == 1 && ay == 0) {
                    axis.setOrigin(centers[1][0]);
                    modulePitch[0] = this.getAreaModulePitch(axis.translate(0, -3), centers[2][0], logicalDistance + 3);
                    modulePitch[1] = this.getAreaModulePitch(centers[1][0], centers[1][1], logicalDistance);
                    axis.setModulePitch(modulePitch[0]);
                    modulePitch[2] = this.getAreaModulePitch(centers[1][1], centers[2][1], logicalDistance);
                    axis.setModulePitch(modulePitch[1]);
                    axis.setOrigin(centers[2][0]);
                    modulePitch[3] = this.getAreaModulePitch(axis.translate(-3, 0), centers[2][1], logicalDistance + 3);
                    axis.setOrigin(centers[1][0]);
                    axis.setModulePitch(modulePitch[1]);
                    baseLineX.setP1(axis.translate(0, -6));
                    baseLineY.setP1(axis.translate(0, -6));
                    baseLineX.setP2(centers[1][1]);
                    axis.setOrigin(centers[2][0]);
                    axis.setModulePitch(modulePitch[3]);
                    baseLineY.setP2(axis.translate(3, -3));
                } else if (ax == 0 && ay == 1) {
                    modulePitch[0] = this.getAreaModulePitch(centers[0][1], centers[1][1], logicalDistance);
                    axis.setOrigin(centers[0][2]);
                    modulePitch[1] = this.getAreaModulePitch(centers[0][1], axis.translate(3, 0), logicalDistance + 3);
                    axis.setModulePitch(modulePitch[0]);
                    modulePitch[2] = this.getAreaModulePitch(axis.translate(0, -3), centers[1][2], logicalDistance + 3);
                    axis.setModulePitch(modulePitch[2]);
                    modulePitch[3] = this.getAreaModulePitch(centers[1][1], centers[1][2], logicalDistance);
                    axis.setOrigin(centers[0][1]);
                    axis.setModulePitch(modulePitch[0]);
                    baseLineX.setP1(axis.translate(-6, 0));
                    baseLineY.setP1(axis.translate(-6, 0));
                    axis.setOrigin(centers[0][2]);
                    axis.setModulePitch(modulePitch[2]);
                    baseLineX.setP2(axis.translate(-3, 3));
                    baseLineY.setP2(centers[1][1]);
                } else if (ax == 1 && ay == 1) {
                    modulePitch[0] = this.getAreaModulePitch(centers[1][1], centers[2][1], logicalDistance);
                    modulePitch[1] = this.getAreaModulePitch(centers[1][1], centers[1][2], logicalDistance);
                    modulePitch[2] = this.getAreaModulePitch(centers[1][2], centers[2][2], logicalDistance);
                    modulePitch[3] = this.getAreaModulePitch(centers[2][1], centers[2][2], logicalDistance);
                    baseLineX.setP1(centers[1][1]);
                    baseLineY.setP1(centers[1][1]);
                    axis.setOrigin(centers[1][2]);
                    axis.setModulePitch(modulePitch[1]);
                    baseLineX.setP2(axis.translate(0, 6));
                    axis.setOrigin(centers[2][1]);
                    axis.setModulePitch(modulePitch[0]);
                    baseLineY.setP2(axis.translate(6, 0));
                }
                baseLineX.translate(1, 1);
                baseLineY.translate(1, 1);
                int i = 0;
                while (i < sqrtNumAreaModules) {
                    Line gridLineX = new Line(baseLineX.getP1(), baseLineX.getP2());
                    axis.setOrigin(gridLineX.getP1());
                    axis.setModulePitch(modulePitch[0]);
                    gridLineX.setP1(axis.translate(i, 0));
                    axis.setOrigin(gridLineX.getP2());
                    axis.setModulePitch(modulePitch[2]);
                    gridLineX.setP2(axis.translate(i, 0));
                    Line gridLineY = new Line(baseLineY.getP1(), baseLineY.getP2());
                    axis.setOrigin(gridLineY.getP1());
                    axis.setModulePitch(modulePitch[1]);
                    gridLineY.setP1(axis.translate(0, i));
                    axis.setOrigin(gridLineY.getP2());
                    axis.setModulePitch(modulePitch[3]);
                    gridLineY.setP2(axis.translate(0, i));
                    samplingGrid[ax][ay][0][i] = gridLineX;
                    samplingGrid[ax][ay][1][i] = gridLineY;
                    ++i;
                }
                ++ax;
            }
            ++ay;
        }
        ay = 0;
        while (ay < samplingGrid[0].length) {
            ax = 0;
            while (ax < samplingGrid.length) {
                this.canvas.drawLines(samplingGrid[ax][ay][0], 0xBBBBFF);
                this.canvas.drawLines(samplingGrid[ax][ay][1], 0xBBBBFF);
                ++ax;
            }
            ++ay;
        }
        return samplingGrid;
    }

    int getAreaModulePitch(Point start, Point end, int logicalDistance) {
        Line tempLine = new Line(start, end);
        int realDistance = tempLine.getLength();
        int modulePitch = (realDistance << 23) / logicalDistance;
        return modulePitch;
    }

    boolean[][] getQRCodeMatrix(boolean[][] image, Line[][][][] gridLines) throws ArrayIndexOutOfBoundsException {
        int gridSize = gridLines.length * gridLines[0][0][0].length;
        if (gridLines.length >= 2) {
            --gridSize;
        }
        boolean[][] sampledMatrix = new boolean[gridSize][gridSize];
        int ay = 0;
        while (ay < gridLines[0].length) {
            int ax = 0;
            while (ax < gridLines.length) {
                int y = 0;
                while (y < gridLines[0][0][1].length) {
                    int x = 0;
                    while (x < gridLines[0][0][0].length) {
                        int x1 = gridLines[ax][ay][0][x].getP1().getX();
                        int y1 = gridLines[ax][ay][0][x].getP1().getY();
                        int x2 = gridLines[ax][ay][0][x].getP2().getX();
                        int y2 = gridLines[ax][ay][0][x].getP2().getY();
                        int x3 = gridLines[ax][ay][1][y].getP1().getX();
                        int y3 = gridLines[ax][ay][1][y].getP1().getY();
                        int x4 = gridLines[ax][ay][1][y].getP2().getX();
                        int y4 = gridLines[ax][ay][1][y].getP2().getY();
                        int e = (y2 - y1) * (x3 - x4) - (y4 - y3) * (x1 - x2);
                        int f = (x1 * y2 - x2 * y1) * (x3 - x4) - (x3 * y4 - x4 * y3) * (x1 - x2);
                        int g = (x3 * y4 - x4 * y3) * (y2 - y1) - (x1 * y2 - x2 * y1) * (y4 - y3);
                        try {
                            sampledMatrix[ax * gridLines[0][0][0].length + x - ax][ay * gridLines[0][0][1].length + y - ay] = image[f / e][g / e];
                        }
                        catch (ArrayIndexOutOfBoundsException exception) {
                            sampledMatrix[ax * gridLines[0][0][0].length + x - ax][ay * gridLines[0][0][1].length + y - ay] = false;
                        }
                        ++x;
                    }
                    ++y;
                }
                ++ax;
            }
            ++ay;
        }
        return sampledMatrix;
    }
}

