/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec.geom;

import jp.sourceforge.qrcode.codec.geom.Point;

public class Axis {
    int sin;
    int cos;
    int modulePitch;
    Point origin;

    public Axis(int sin, int cos, int modulePitch) {
        this.sin = sin;
        this.cos = cos;
        this.modulePitch = modulePitch;
        this.origin = new Point();
    }

    public void setOrigin(Point origin) {
        this.origin = origin;
    }

    public void setModulePitch(int modulePitch) {
        this.modulePitch = modulePitch;
    }

    public Point translate(Point offset) {
        int moveX = offset.getX();
        int moveY = offset.getY();
        return this.translate(moveX, moveY);
    }

    public Point translate(int moveX, int moveY) {
        int dp = 23;
        Point point = new Point(this.origin.getX(), this.origin.getY());
        boolean xf = false;
        int yf = 0;
        if (moveX >= 0 & moveY >= 0) {
            yf = 1;
        } else if (moveX < 0 & moveY >= 0) {
            yf = -1;
        } else if (moveX >= 0 & moveY < 0) {
            yf = -1;
        } else if (moveX < 0 & moveY < 0) {
            yf = 1;
        }
        if (moveX != 0 && moveY != 0) {
            point.translate((this.modulePitch * moveX >> dp) * this.cos - (this.modulePitch * moveY >> dp) * this.sin >> dp, yf * ((this.modulePitch * moveX >> dp) * this.cos + (this.modulePitch * moveY >> dp) * this.sin) >> dp);
        } else if (moveY == 0) {
            if (moveX < 0) {
                yf = -yf;
            }
            point.translate((this.modulePitch * moveX >> dp) * this.cos >> dp, yf * ((this.modulePitch * moveX >> dp) * this.sin) >> dp);
        } else if (moveX == 0) {
            if (moveY < 0) {
                yf = -yf;
            }
            point.translate(-yf * ((this.modulePitch * moveY >> dp) * this.sin) >> dp, (this.modulePitch * moveY >> dp) * this.cos >> dp);
        }
        return point;
    }
}

