package jp.sourceforge.qrcode.codec.reader.pattern;

import jp.sourceforge.qrcode.codec.reader.*;
import jp.sourceforge.qrcode.codec.geom.*;
import jp.sourceforge.qrcode.codec.util.*;

public class AlignmentPattern {
	static final int RIGHT = 1;
	static final int BOTTOM = 2;
	static final int LEFT = 3;
	static final int TOP = 4;

	static DebugCanvas canvas = DebugCanvas.getCanvas();
	Point[][] center;
	//int sqrtCenters; //ʒup^[1ӓ̐
	int patternDistance;
	
	AlignmentPattern(Point[][] center, int patternDistance) {
		this.center = center;
		this.patternDistance = patternDistance;
	}
	
	public static AlignmentPattern findAlignmentPattern(boolean[][] image, FinderPattern finderPattern) {

		Point[][] logicalCenters = getLogicalCenter(finderPattern);
		int logicalDistance = logicalCenters[1][0].getX() - logicalCenters[0][0].getX();

		//FinderPatternAlignmentPatternƓlɈ߂ɕϊ

		Point[][] centers = getCenter(image, finderPattern, logicalCenters);
		return new AlignmentPattern(centers, logicalDistance);

	}
	
	public Point[][] getCenter() {
		return center;
	}
	
	public int getLogicalDistance() {
		return patternDistance;
	}
	
	static Point[][] getCenter(boolean[][] image, FinderPattern finderPattern, Point[][] logicalCenters) {
		int moduleSize = finderPattern.getModuleSize();
		int sin = finderPattern.getAngle()[0];
		int cos = finderPattern.getAngle()[1];

		Axis axis = new Axis(sin, cos, moduleSize);

		axis.setOrigin(finderPattern.getCenter(FinderPattern.UL));

		int sqrtCenters = logicalCenters.length;

		Point[][] centers = new Point[sqrtCenters][sqrtCenters];
		
		centers[0][0] = axis.translate(3, 3);
		//centers[0][0] = finderPattern.getCenter(FinderPattern.UL);
		axis.setOrigin(finderPattern.getCenter(FinderPattern.UR));
		centers[sqrtCenters - 1][0] = axis.translate(-3, 3);
		//centers[sqrtCenters - 1][0] = finderPattern.getCenter(FinderPattern.UR);
		axis.setOrigin(finderPattern.getCenter(FinderPattern.DL));
		centers[0][sqrtCenters - 1] = axis.translate(3, -3);
		//centers[0][sqrtCenters - 1] = finderPattern.getCenter(FinderPattern.DL);

		for (int y = 0; y < sqrtCenters; y++) {
			for (int x = 0; x < sqrtCenters; x++) {
				if (x == 1 && y == 0 && sqrtCenters == 3) { //^7`13̒̈ʒup^[
					centers[x][y] = Point.getCenter(centers[0][0], centers[sqrtCenters - 1][0]);
					centers[x][y] = getPrecisionCenter(image, centers[x][y]);
				}
				else if (x == 0 && y == 1 && sqrtCenters == 3) {//^7`13̍̈ʒup^[
					centers[x][y] = Point.getCenter(centers[0][0], centers[0][sqrtCenters - 1]);					
					centers[x][y] = getPrecisionCenter(image, centers[x][y]);
				}
				else if (x >= 1 && y >= 1){

					Line[] additionalLines = { 
							new Line(centers[x - 1][y - 1], centers[x][y - 1]),
							new Line(centers[x - 1][y - 1], centers[x - 1][y])};
					int dx = centers[x - 1][y].getX() - centers[x - 1][y - 1].getX();
					int dy = centers[x - 1][y].getY() - centers[x - 1][y - 1].getY();
					additionalLines[0].translate(dx,dy);
					dx = centers[x][y - 1].getX() - centers[x - 1][y - 1].getX();
					dy = centers[x][y - 1].getY() - centers[x - 1][y - 1].getY();
					additionalLines[1].translate(dx,dy);
					centers[x][y] = Point.getCenter(additionalLines[0].getP2(), additionalLines[1].getP2());
					centers[x][y] = getPrecisionCenter(image, centers[x][y]);
				}
				canvas.drawCross(centers[x][y], Color.LIGHTRED);
			}
		}
		return centers;
	}

	
	
	static Point getPrecisionCenter(boolean[][] image, Point targetPoint) {
		//X^[gn__̏ꍇAԋ߂Ó_targetPointƂ
		if (image[targetPoint.getX()][targetPoint.getY()] == QRCodeImageReader.POINT_LIGHT) {
			int scope = 0;
			boolean notFound = true;
			while (notFound) {
				scope++;
				for (int dy = scope; dy > -scope; dy--) {
					for (int dx = scope; dx > -scope; dx--) {
						if (image[targetPoint.getX() + dx][targetPoint.getY() + dy] == QRCodeImageReader.POINT_DARK) {
							targetPoint = new Point(targetPoint.getX() + dx,targetPoint.getY() + dy);
							notFound = false;
						}
					}
				}
			}
		}
		Point pointEdgeRight = getEdge(image, targetPoint, RIGHT);
		Point pointEdgeBottom = getEdge(image, targetPoint, BOTTOM);
		Point pointEdgeLeft = getEdge(image, targetPoint, LEFT);
		Point pointEdgeTop = getEdge(image, targetPoint, TOP);
		int x = Point.getCenter(pointEdgeLeft, pointEdgeRight).getX();
		int y = Point.getCenter(pointEdgeTop, pointEdgeBottom).getY();
		return new Point(x, y);
	}

	
	//eʒup^[̘_W𓾂
	static Point[][] getLogicalCenter(FinderPattern finderPattern) {
		int version = finderPattern.getVersion();
		Point[][] logicalCenters = new Point[1][1];
		int[] logicalSeeds = new int[1];

		//΍W̌ɂȂW,sW̍쐬
		if (version == 1)
			return null;
		else if (version >= 2 && version <= 6) {
			logicalSeeds = new int[2];
			logicalSeeds[0] = 6;
			logicalSeeds[1] = 10 + 4 * version;
			logicalCenters = new Point[logicalSeeds.length][logicalSeeds.length];
		}
		else if (version >= 7 && version <= 13) {
			logicalSeeds = new int[3];
			logicalSeeds[0] = 6;
			logicalSeeds[1] = 8 + 2 * version;
			logicalSeeds[2] = 10 + 4 * version;
			logicalCenters = new Point[logicalSeeds.length][logicalSeeds.length];
		}
		
		//ۂ̑΍W̍쐬
		for (int col = 0; col < logicalCenters.length; col++) { //@
			for (int row = 0; row < logicalCenters.length; row++) { //s
				logicalCenters[row][col] = new Point(logicalSeeds[row], logicalSeeds[col]);
			}
		}
		return logicalCenters;
		
	}
	
	


	static Point getEdge(boolean[][] image, Point startPoint, int direction) {
		int imageWidth = image.length;
		int imageHeight = image[0].length;
		int targetX = startPoint.getX();
		int targetY = startPoint.getY();
		boolean currentElement = QRCodeImageReader.POINT_DARK;
		boolean lastElement = QRCodeImageReader.POINT_DARK;
		int dx = 0;
		int dy = 0;

		if (direction == RIGHT)
			dx = 1;
		else if (direction == BOTTOM)
			dy = 1;
		else if (direction == LEFT)
			dx = -1;
		else if (direction == TOP)
			dy = -1;

		do {
			currentElement = image[targetX][targetY];
			if (lastElement == QRCodeImageReader.POINT_LIGHT && currentElement == QRCodeImageReader.POINT_DARK) //_Ó_ֈڍs
				return new Point(targetX - dx, targetY - dy); //O̓_(lp`̕Ԃ)
			else {
				targetX += dx;
				targetY += dy;
			}
			lastElement = currentElement;
		} while ((targetX >= 0 && targetX < imageWidth) && (targetY >= 0 && targetY < imageHeight));

		return null;
	}
}
