-- 自機用の AI
-- Satofumi KAMIMURA
-- $Id: user_ship_ai.lua 324 2009-04-06 11:32:09Z satofumi $


-- state: 最初の状態
UserShip_startup = {}

UserShip_startup["Enter"] =
   function(unit)
   end

UserShip_startup["Execute"] =
   function(unit)
      unit:stateMachine():changeState(UserShip_none)
   end

UserShip_startup["Exit"] =
   function(unit)
   end


-- state: 何もしない
UserShip_none = {}

UserShip_none["Enter"] =
   function(unit)
   end

UserShip_none["Execute"] =
   function(unit)
      unit:setRotateMode(ShipControl.None)
      unit:setStraightMode(ShipControl.None)
   end

UserShip_none["Exit"] =
   function(unit)
   end


-- state: 速度をゼロにして停止する
UserShip_holdPosition = {}

UserShip_holdPosition["Enter"] =
   function(unit)
   end

UserShip_holdPosition["Execute"] =
   function(unit)
      -- 回転と噴射の操作があったら、モードを終了する
      if (unit:rotate() ~= 0) or (unit:isThrust()) then
         unit:stateMachine():changeState(UserShip_none)
      end

      local velocity = unit:velocity()
      -- !!! norm を lua に bind する
      local unit_v =
         math.sqrt((velocity.x * velocity.x) + (velocity.y * velocity.y))

      -- 位置制御と速度制御にヒステリシス領域を持たせる
      if unit:rotateMode() == ShipControl.HoldPosition then
         if unit_v < 0.5 then
            return
         end
      end

      -- 移動速度が大きければ、移動速度がゼロになるように制御する
      local direction_rad = math.atan2(velocity.y, velocity.x)
      if unit_v > 0.2 then
         -- 移動している方向に戻るような向きに制御する
         unit:stopToDirection(rad(direction_rad + math.pi))
         if unit:rotateStable() then
            -- 移動速度がゼロになるように制御する
            unit:thrust()
            return
         end

      else
         local gravity = unit:gravity()
         local gravity_rad = math.atan2(gravity.y, gravity.x)
         local cos_diff = math.cos(gravity_rad - direction_rad)
         local threshold = math.cos(1.0 * math.pi / 180.0)

         if cos_diff > threshold then
            -- 移動速度が地形による加速度と同じ方向になったら位置制御を行う
            if unit:rotateMode() ~= ShipControl.HoldPosition then

               local unit_position = unit:position()
               unit_position.angle = rad(gravity_rad)
               unit:stopToPosition(unit_position)
            end
         end
      end
   end

UserShip_holdPosition["Exit"] =
   function(unit)
   end
