local next_state = ""
local next_file = ""

while true do
   local state_changed = false

   if _G.state == "scout_quest" then
      next_state = "fortress_quest"
      next_file = "script/fortress_quest"
      state_changed = true

   elseif _G.state == "stage_replay" then

      if _G.flags.select == 4 then
         next_state = "scout_quest"
         next_file = "script/scout_quest"
         state_changed = true

      elseif _G.flags.select == 5 then
         next_state = "fortress_quest"
         next_file = "script/fortress_quest"
         state_changed = true

      elseif _G.flags.select == 6 then
         next_state = "cloak_quest"
         next_file = "script/cloak_quest"
         state_changed = true

      elseif _G.flags.select == 7 then
         next_state = "escape_quest"
         next_file = "script/escape_quest"
         state_changed = true

      elseif _G.flags.select == 0 then
         next_state = "first_menu"
         next_file = "script/first_menu"
         state_changed = true

      elseif _G.flags.select == 1 then
         next_state = "move_tutorial"
         next_file = "script/move_tutorial"
         state_changed = true

      elseif _G.flags.select == 2 then
         next_state = "attack_tutorial"
         next_file = "script/attack_tutorial"
         state_changed = true

      elseif _G.flags.select == 3 then
         next_state = "destroy_tutorial"
         next_file = "script/destroy_tutorial"
         state_changed = true
      end

   elseif _G.state == "new_game" then
      next_state = "move_tutorial"
      next_file = "script/move_tutorial"
      state_changed = true

   elseif _G.state == "startup" then
      next_state = "first_menu"
      next_file = "script/first_menu"
      state_changed = true

   elseif _G.state == "fortress_quest" then
      next_state = "cloak_quest"
      next_file = "script/cloak_quest"
      state_changed = true

   elseif _G.state == "hi_score" then
      next_state = "first_menu"
      next_file = "script/first_menu"
      state_changed = true

   elseif _G.state == "escape_quest" then
      next_state = "ending"
      next_file = "script/ending"
      state_changed = true

   elseif _G.state == "cloak_quest" then
      next_state = "escape_quest"
      next_file = "script/escape_quest"
      state_changed = true

   elseif _G.state == "move_tutorial" then
      next_state = "attack_tutorial"
      next_file = "script/attack_tutorial"
      state_changed = true

   elseif _G.state == "attack_tutorial" then
      next_state = "destroy_tutorial"
      next_file = "script/destroy_tutorial"
      state_changed = true

   elseif _G.state == "ending" then
      next_state = "hi_score"
      next_file = "script/hi_score"
      state_changed = true

   elseif _G.state == "destroy_tutorial" then
      next_state = "scout_quest"
      next_file = "script/scout_quest"
      state_changed = true

   elseif _G.state == "settings" then
      next_state = "first_menu"
      next_file = "script/first_menu"
      state_changed = true

   elseif _G.state == "first_menu" then

      if _G.flags.select == 4 then
         next_state = "settings"
         next_file = "script/settings"
         state_changed = true

      elseif _G.flags.select == 5 then
         next_state = "exit"
         next_file = "exit"
         state_changed = true

      elseif _G.flags.select == 1 then
         next_state = "new_game"
         next_file = "script/new_game"
         state_changed = true

      elseif _G.flags.select == 2 then
         next_state = "stage_replay"
         next_file = "script/stage_replay"
         state_changed = true

      elseif _G.flags.select == 3 then
         next_state = "hi_score"
         next_file = "script/hi_score"
         state_changed = true
      end
   end

   if state_changed == false then
      --print("state is not updated. current state is \"" .. _G.state .. "\"")
      break
   end
   if next_state == "exit" then
      os.exit()
   end

   if next_state:len() == 0 then
      print("next state is none.")
      break
   end

   --print(next_file)
   _G.state = next_state
   local no_file_error = true
   if next_file == 'exit' then
      no_file_error = false
   end
   loadLuaModule_once(next_file, no_file_error)
end
