--! \file
-- \brief 設定画面
--
-- \author Satofumi KAMIMURA
--
-- $Id: settings.lua 309 2009-03-17 22:21:11Z satofumi $

-- 「戻る」というボタンを表示するだけの仮実装

-- 画面サイズの受け取り
screen = Screen()
local scr_w = screen:width()
local scr_h = screen:height()

-- 描画まわりの初期化
LayerManager:clear()

-- レイヤーの作成
local layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(layer)
local back_layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(back_layer)

-- 終了イベントの登録
local quit_detector = EventDetector()
quit_detector:setEvent(Event_quit())


-- 画面の作成
local font = Font("resource/font.ttf", 30, true)

-- 戻るボタン
local back_surface = TextSurface(font, "Back to press ESCAPE")
local back_button = ButtonComponent(back_surface, back_surface, back_surface)
back_button:setPosition(Grid(center(back_button, scr_w/2), 200))
layer:push_back(back_button)


-- フェード処理
local decided = false
function fade()

   -- !!! fps で指定できるようにする
   local fade_count = 25

   -- フェードイン
   for i = 0, fade_count do
      local alpha = i / fade_count
      layer:setAlpha(alpha)
      back_layer:setAlpha(alpha)
      Scheduler:yield()
   end

   while not decided do
      -- メニューの決定待ち
      Scheduler:yield()
   end

   -- フェードアウト
   for i = 0, fade_count do
      local alpha = 1.0 - (i / fade_count)
      layer:setAlpha(alpha)
      back_layer:setAlpha(alpha)
      Scheduler:yield()
   end
end


-- 制御ループ
local scheduler = Scheduler:new()
local id = scheduler:registerFunction(fade)

local escape_detector = EventDetector()
escape_detector:setEvent(Event_escape())

local cycle_timer = CycleTimer()
while scheduler:isActive(id) do

   if escape_detector:isActive() then
      decided = true
   end

   -- 終了判定
   if quit_detector:isActive() then
      _G.state = 'exit'
      break
   end

   -- ボタン押下の検出
   if back_button:isClicked() then
      decided = true
   end

   scheduler:execute()
   LayerManager:redraw_pollEvent()
   screen:clear()
   LayerManager:redraw_draw()
   delay(cycle_timer:waitMsec())
   LayerManager:redraw_swap()
end
