-- 移動のチュートリアル
--
-- Satofumi KAMIMURA
--
-- $Id: move_tutorial.lua 324 2009-04-06 11:32:09Z satofumi $


-- システムの初期化
local screen = Screen()
local scr_w = screen:width()
local scr_h = screen:height()

LayerManager:clear()
local layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(layer)
local front_layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_front(front_layer)


-- マップ読み出し
local side_width = 100

local unit_manager = UnitManager()
local map_handler = MapHandler("data/default_tile.txt")
if not map_handler:load("data/move_tutorial_map.txt") then
   print("map load: " .. map_handler:what())
   os.exit(1)
end
unit_manager:initialize(scr_w - side_width, scr_h, map_handler)
unit_manager:setPosition(Grid(side_width, 0))
layer:push_back(unit_manager)

local bar_width = 2
local bar_surface = ColorSurface(bar_width, scr_h, Color(1.0, 1.0, 1.0, 1.0));
local bar_label = LabelComponent(bar_surface)
bar_label:setPosition(Grid(right(bar_label, side_width), 0))
layer:push_front(bar_label)


-- ユニットの登録
local user_ship = UserShip()
map_handler:insertUnit(user_ship, Team_01)
user_ship:setPosition(map_handler:unitBase(user_ship))

-- 描画対象を自機ユニットに設定
unit_manager:setViewUnit(user_ship)


-- クエスト用のフラグ
local is_playing = false
local terminated = false
local last_id = 9
local next_id = 0


-- メッセージウィンドウ
local font = Font("resource/font.ttf", 18, true)
local offset = 10
local icon_width = 20
local icon_height = 20
local message_y = 360
local message_actual_x = side_width + offset
local message_actual_y = message_y + offset
local message_actual_w = scr_w - side_width - (offset * 2) - icon_width
local message_actual_h = scr_h - message_y - (offset * 2)
local message = MessageAreaComponent(font, message_actual_w, message_actual_h)
message:setPosition(Grid(message_actual_x, message_actual_y))

-- 入力アイコンの登録
local return_surface = ImageSurface("resource/return.bmp", true)
message:setWaitIcon(return_surface, MessageAreaComponent.MessageSide)
layer:push_front(message)

-- !!! コメントアウトしている計算が動作するように調整する
local chat_message_w = message_actual_w --* 3 / 5
local chat_message_x = 0 -- (message_actual_w - chat_message_w) / 2
local chat_message_h = scr_h -- scr_h * 2 / 3
local chat_message =
   ChatMessageComponent(font, chat_message_w, chat_message_h)
chat_message:setPosition(Grid(message_actual_x + chat_message_x, 0))
chat_message:setOffset(Grid(offset, offset))
layer:push_front(chat_message)

-- 縮小マップ
local map_overview =
   MapOverview(map_handler, side_width - bar_width, side_width)
map_overview:setOwnerUnit(user_ship)
layer:push_back(map_overview)


-- !!! 別関数として定義する方法を調べて、調整する
function message:waitInput()
   while message:isNextPressed() == false do
      Scheduler:yield()
   end
end


-- チュートリアル中の動作スクリプト
function teaching()
   while not is_playing do
      Scheduler:yield()
   end

   chat_message:print("まず、噴射だ")
   chat_message:newline()
   chat_message:print("まっすぐ進んで点滅している移動目標まで移動しろ")
   chat_message:newline()

   -- !!! 回転、噴射のキー割り当ては、半透明なラベルで表示する
   while next_id <= 0 do
      Scheduler:yield()
   end
   chat_message:clear()
   chat_message:print("いいぞ、その調子だ")
   -- !!! 「次は、すぐ右にある目標に向かって移動だ」
   chat_message:newline()

   while next_id <= 1 do
      -- !!! 大きく通り過ぎた場合には、
      -- !!! 「噴射せずに、自然に落下するのを待つんだ」
      -- !!! などと表示する

      -- !!! 「次は、？の方向の目標に移動するんだ」
      -- !!! 「移動したい方向に機体を向けて、噴射だ」

      Scheduler:yield()
   end
   chat_message:print("よし、うまいじゃないか！")
   chat_message:newline()

   -- !!! ...

   -- !!! スタート地点付近では、噴射と旋回について説明する
   -- !!! 「？キーで噴射だ。向いている方向に進むぞ」
   -- !!! 「？と？キーで回転して。向きを変えるんだ」

   -- !!! 最初の目標までの移動時間が短ければ、以降のメッセージはつつしむ
   -- !!! 「うまいじゃないか、その調子だ！」
   -- !!! 「よし、自由にやってみろ！」

   -- !!! ランダムなタイミングで、次の目標位置を指示するようにする
   -- !!! 目標への距離が減少傾向にないときに、メッセージを出力してもよい

   -- !!! 次の移動位置が、ミニマップ上にあることを通知するメッセージを出力する
   -- !!! ４つ目の移動目標のときくらいに表示する
   -- !!! 次はあっちだ！ の表示は、最初だけでよさそう

   -- !!! ランダムメッセージとしては、
   -- !!! 「離れていっているぞ」とか「そっちじゃないぞ」とかか？

   while next_id <= (last_id - 1) do
      Scheduler:yield()
   end

   chat_message:print("いいぞ。次で最後だ！")
   chat_message:newline()

   while next_id <= last_id do
      Scheduler:yield()
   end
   chat_message:clear()

   -- "Hold Position" を呼び出す
   unit_manager:setEventAcceptable(false)
   user_ship:setAutoPilot(true)
   user_ship:setAiState("UserShip_holdPosition")

   terminated = true
end


-- シナリオ管理
function scenario()

   -- 機体の操作を無効化し、"Hold Position" にしておく
   user_ship:setAutoPilot(true)
   user_ship:setAiState("UserShip_holdPosition")
   unit_manager:setEventAcceptable(false)

   -- !!! fps で指定できるようにする
   local fade_count = 25

   -- フェードイン
   for i = 0, fade_count do
      local alpha = i / fade_count
      layer:setAlpha(alpha)
      Scheduler:yield()
   end

   -- !!! このフェードが終わるまで、メッセージへのキー入力は無効にする

   -- !!! 手本として AI による移動デモを表示する

   -- !!! "START" までは、ESC でスキップ可能にする

   -- 説明メッセージの表示
   -- !!! シナリオ部分は、ファイル指定で処理できるようにする
   message:print("まずは、機体の操作になれてもらう。")
   message:waitInput()
   message:newline()
   message:print("配置してあるマーカーを順に移動するんだ。")

   --   message:print("...")
   --   message:waitInput()

   -- !!! 視界をマーカーに沿って１周してもよい

   message:setWaitIcon(return_surface, MessageAreaComponent.None)

   message:clear()

if false then
   -- "START" の表示
   local title_font = font:duplicate()
   title_font:setFontSize(60)
   local start_surface = TextSurface(title_font, "START")
   local start_label = LabelComponent(start_surface)
   local center_x = side_width + (scr_w - side_width) / 2
   layer:push_front(start_label)

   -- !!! ESC によるスキップはここまでとする

   -- !!! 拡大しながら表示するように変更する
   start_label:setPosition(Grid(center(start_label, center_x),
                                middle(start_label, scr_h / 2)))
   Scheduler:wait(1300)
   -- !!! ここまでをループ
   layer:erase(start_label)
end

   -- 機体の操作を有効化し、メッセージ欄への入力を無効化
   unit_manager:setEventAcceptable(true)
   message:setEventAcceptable(false)

   -- レーダーのターゲットを移動目標にする
   -- !!!

   is_playing = true
   while not terminated do
      -- チュートリアルの終了待ち
      Scheduler:yield()
   end

   -- 結果メッセージの表示
   -- !!! スコア、実績によってメッセージを変える
   message:clear()
   message:print("いいぞ！")

if false then
   -- "GOAL" の表示
   local goal_surface = TextSurface(title_font, "GOAL")
   local goal_label = LabelComponent(goal_surface)
   layer:push_front(goal_label)

   -- !!! 拡大しながら表示するように変更する
   goal_label:setPosition(Grid(center(goal_label, center_x),
                               middle(goal_label, scr_h / 2)))
   Scheduler:wait(1300)
   -- !!! ここまでをループ
   layer:erase(goal_label)
end

   -- !!! フェードアウトまでを、ESC でスキップ可能にする

   -- メッセージ欄への入力を有効化
   message:setEventAcceptable(true)
   message:setWaitIcon(return_surface, MessageAreaComponent.MessageSide)
   message:waitInput()

   -- !!! 中央付近に大きめのラベルで描画する
   -- 壁にぶつかった回数を表示
   -- !!! times = unit_manager:boudTimes()

   -- ゴールまでの秒数を表示
   -- !!! 小数点２桁まで表示する
   -- !!!

   -- !!! 入力待ち

   -- !!! ESC によるスキップはここまでとする

   -- フェードアウト
   for i = 0, fade_count do
      local alpha = 1.0 - (i / fade_count)
      layer:setAlpha(alpha)
      Scheduler:yield()
   end
end


-- イベント条件の監視
function condition_check()

   -- 移動点の描画
   for i = 0, last_id do
      local alias = string.format("Goal_%02d", i)
      local goal = map_handler:goal(alias)
      map_overview:setPoint(goal:position(), Color(1.0, 1.0, 1.0, 1.0))
   end

   -- クエストの開始待ち
   while not is_playing do
      Scheduler:yield()
   end

   while next_id <= last_id do

      local alias = string.format("Goal_%02d", next_id)
      local goal = map_handler:goal(alias)

      goal:activate(true)
      map_overview:setBlinkPoint(goal:position(), Color(0.0, 1.0, 0.0, 1.0))
      while goal:gridLength(user_ship) > 4 do
         Scheduler:yield()
      end
      map_overview:removePoint(goal:position())
      goal:activate(false)
      next_id = next_id + 1
   end

   is_playing = false
end


-- 制御ループ
local scheduler = Scheduler:new()
local id = scheduler:registerFunction(scenario)
scheduler:registerFunction(teaching)
scheduler:registerFunction(condition_check)

local cycle_timer = CycleTimer()
while scheduler:isActive(id) do

   scheduler:execute()
   LayerManager:redraw_pollEvent()

   screen:clear()
   LayerManager:redraw_draw()
   delay(cycle_timer:waitMsec())
   LayerManager:redraw_swap()
end

-- クリアフラグの更新
if _G.g_last_stage <= 0 then
   _G.g_last_stage = 1
   saveGlobalFlags(GlobalFlagFile)
end
