-- 起動直後のメニュー
--
-- Satofumi KAMIMURA
--
-- $Id: first_menu.lua 308 2009-03-17 14:04:07Z satofumi $


-- 画面サイズの受け取り
screen = Screen()
local scr_w = screen:width()
local scr_h = screen:height()

-- 描画まわりの初期化
LayerManager:clear()

-- レイヤーの作成
local layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(layer)
local back_layer = Layer(0, 0, scr_w, scr_h)
LayerManager:push_back(back_layer)


-- 画面の作成
local font = Font("resource/font.ttf", 16, true)

-- バージョン情報
local version_surface = TextSurface(font, version())
local version_label = LabelComponent(version_surface)
version_label:setPosition(Grid(8, 1))
layer:push_back(version_label)

-- タイトル
font:setFontSize(90)
title_surface = TextSurface(font, "qpilot")
local title_label = LabelComponent(title_surface)
title_label:setPosition(Grid(center(title_label, scr_w/2), 40))
layer:push_back(title_label)

-- メニュー
local button_group = ButtonGroupComponent(scr_w, scr_h)
button_group:enableNoSelect(false)

font:setFontSize(30)
local focused_font = font:duplicate()
focused_font:setBackgroundColor(Color(0.0, 0.0, 1.0, 1.0))
focused_font:setTransparent(false)

local titles = { "New game", "Stage replay", "Ranking", "Config", "Exit" }
for index, title in ipairs(titles) do

   local surface = TextSurface(font, title)
   local focused_surface = TextSurface(focused_font, title)
   local button = ButtonComponent(surface, surface, focused_surface)

   button_group:addButton(button, index)
end
-- クリアしたステージがないときには、"State replay" を disable にする
if _G.g_last_stage == 0 then
   button_group:enabledButton(2, false)
end

-- !!! メニューの配置と幅について、仕様を書き出して実装を調整する
button_group:setOffset(Grid(0, 5))
button_group:setPosition(Grid(240, 180))
layer:push_back(button_group)


-- 背景用のマップ読み出し
local unit_manager = UnitManager()
local map_handler = MapHandler("data/default_tile.txt")
-- !!! デフォルトで、AI ボットが配置される設定にする
if not map_handler:load("data/menu_back_map.txt") then
   print("map load: " .. map_handler:what())
   map_handler:setEmptyMap(scr_w, scr_h)
end
unit_manager:initialize(scr_w, scr_h, map_handler)
unit_manager:setViewArea(Grid(0, 0))
back_layer:push_back(unit_manager)


-- フェード処理
local decided = false
function fade()

   -- !!! fps で指定できるようにする
   local fade_count = 25

   -- フェードイン
   for i = 0, fade_count do
      local alpha = i / fade_count
      layer:setAlpha(alpha)
      back_layer:setAlpha(alpha)
      Scheduler:yield()
   end

   while not decided do
      -- メニューの決定待ち
      Scheduler:yield()
   end

   -- フェードアウト
   for i = 0, fade_count do
      local alpha = 1.0 - (i / fade_count)
      layer:setAlpha(alpha)
      back_layer:setAlpha(alpha)
      Scheduler:yield()
   end
end


-- 制御ループ
local scheduler = Scheduler:new()
local id = scheduler:registerFunction(fade)

_G.flags.select = -1
local cycle_timer = CycleTimer()
while scheduler:isActive(id) do

   -- カーソルの右と左で、メニューの一番下、一番上、にメニュー選択を移動させる
   -- !!!

   -- メニュー決定の検出
   if not button_group:noClicked() then
      decided = true

      if button_group:isClicked(1) then
         -- chart: next new_game [!!! below]
         _G.flags.select = 1

      elseif button_group:isClicked(2) then
         -- chart: next stage_replay [!!! below]
         _G.flags.select = 2

      elseif button_group:isClicked(3) then
         -- chart: next hi_score [!!! below]
         _G.flags.select = 3

      elseif button_group:isClicked(4) then
         -- chart: next settings [!!! below]
         _G.flags.select = 4

      elseif button_group:isClicked(5) then
         -- chart: next exit [!!! below]
         _G.flags.select = 5
      end
   end

   scheduler:execute()
   LayerManager:redraw_pollEvent()
   screen:clear()
   LayerManager:redraw_draw()
   delay(cycle_timer:waitMsec())
   LayerManager:redraw_swap()
end
