/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.localstore;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.util.QBrowserUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class LocalMsgTable
extends AbstractTableModel {
    static ResourceBundle resources = QBrowserV2.resources;
    final String[] columnNames = new String[]{"#", resources.getString("qkey.table.header.msgid"), resources.getString("qkey.table.header.timestamp"), resources.getString("qkey.table.header.type"), resources.getString("qkey.table.header.size"), resources.getString("qkey.table.header.mode"), resources.getString("qkey.table.header.priority")};
    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd kk:mm:ss z");
    LinkedList list = null;
    public HashMap msgids = new HashMap();

    public int getRealRowNoFromMsgId(String msgid) {
        Integer iiv = (Integer)this.msgids.get(msgid);
        int retval = -1;
        if (iiv != null) {
            retval = iiv;
        }
        return retval;
    }

    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public void setDisplayNumberAt(int number, int row) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() <= row) {
            return;
        }
        LocalMessageContainer mc = (LocalMessageContainer)this.list.get(row);
        mc.setDisplaynumber(number);
    }

    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        if (this.list.size() <= row) {
            return null;
        }
        LocalMessageContainer mc = (LocalMessageContainer)this.list.get(row);
        if (mc == null) {
            return "null";
        }
        switch (column) {
            case 0: {
                return mc.getDisplaynumber();
            }
            case 1: {
                return mc.getVmsgid();
            }
            case 2: {
                return this.df.format(new Date(mc.getVtimestamp()));
            }
            case 3: {
                return mc.getMessage_type();
            }
            case 4: {
                return QBrowserUtil.messageBodyLengthAsString(mc.getBody_size());
            }
            case 5: {
                int mode = mc.getVdeliverymode();
                if (mode == 2) {
                    return QBrowserV2.PERSISTENT;
                }
                if (mode == 1) {
                    return QBrowserV2.NONPERSISTENT;
                }
                return String.valueOf(mode) + "?";
            }
            case 6: {
                return new Integer(mc.getVpriority());
            }
        }
        return "Bad column value: " + column;
    }

    public int load(Enumeration e) {
        if (e == null) {
            return 0;
        }
        this.list = new LinkedList();
        while (e.hasMoreElements()) {
            LocalMessageContainer mc = (LocalMessageContainer)e.nextElement();
            mc.setDisplaynumber(this.list.size());
            this.list.add(mc);
            this.msgids.put(mc.getVmsgid(), this.list.size() - 1);
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    public void init() {
        this.list = new LinkedList();
    }

    public void add_one_row_ifexists_update(LocalMessageContainer imsg) {
        String smsgid = imsg.getVmsgid();
        if (this.msgids.containsKey(smsgid)) {
            for (int i = 0; i < this.list.size(); ++i) {
                LocalMessageContainer mc = (LocalMessageContainer)this.list.get(i);
                if (!mc.getVmsgid().equals(smsgid)) continue;
                this.list.remove(i);
                break;
            }
        }
        imsg.setDisplaynumber(this.list.size());
        this.list.add(imsg);
        this.msgids.put(imsg.getVmsgid(), this.list.size() - 1);
        this.fireTableDataChanged();
    }

    public void add_one_row(LocalMessageContainer imsg) {
        imsg.setDisplaynumber(this.list.size());
        this.list.add(imsg);
        this.msgids.put(imsg.getVmsgid(), this.list.size() - 1);
        this.fireTableDataChanged();
    }

    public void deleteMessageAtRow(int row) {
        if (this.list == null) {
            return;
        }
        LocalMessageContainer mc = (LocalMessageContainer)this.list.get(row);
        this.msgids.remove(mc.getVmsgid());
        this.list.remove(row);
        mc = null;
        this.fireTableDataChanged();
    }

    public LocalMessageContainer getMessageAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (LocalMessageContainer)this.list.get(row);
    }
}

