/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SecurityUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SystemInfo {
    private static boolean _isWindows = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsVista = false;
    private static JavaVersion _currentVersion;

    private SystemInfo() {
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    private static void checkJdkVersion() {
        if (_currentVersion == null) {
            _currentVersion = new JavaVersion(SecurityUtils.getProperty("java.version", "1.4.2"));
        }
    }

    public static boolean isJdk142Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 2, 0) >= 0;
    }

    public static boolean isJdk15Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.5, 0, 0) >= 0;
    }

    public static boolean isJdk6Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 0) >= 0;
    }

    public static boolean isJdk6u10Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 10) >= 0;
    }

    public static boolean isCJKLocale() {
        Locale locale = Locale.getDefault();
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    static {
        String string = SecurityUtils.getProperty("os.name", "Windows XP");
        boolean bl = _isWindows = string.indexOf("Windows") != -1;
        if (string.indexOf("Windows XP") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows Vista") != -1) {
            _isWindowsVista = true;
        }
        if (string.indexOf("Windows 2003") != -1) {
            _isWindowsXP = true;
        }
    }

    static final class JavaVersion {
        private static Pattern SUN_JAVA_VERSION = Pattern.compile("(\\d+\\.\\d+)(\\.(\\d+))?(_(\\d+))?(\\D*+)");
        private double _majorVersion = 1.4;
        private int _minorVersion = 0;
        private int _buildNumber = 0;

        public JavaVersion(String string) {
            try {
                Matcher matcher = SUN_JAVA_VERSION.matcher(string);
                if (matcher.matches()) {
                    int n = matcher.groupCount();
                    this._majorVersion = Double.parseDouble(matcher.group(1));
                    if (n >= 3 && matcher.group(3) != null) {
                        this._minorVersion = Integer.parseInt(matcher.group(3));
                    }
                    if (n >= 5 && matcher.group(5) != null) {
                        this._buildNumber = Integer.parseInt(matcher.group(5));
                    }
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Please check the installation of your JDK. The version number " + string + " is not right.");
                return;
            }
        }

        public final int compareVersion(double d, int n, int n2) {
            double d2 = this._majorVersion - d;
            if (d2 != 0.0) {
                if (d2 < 0.0) {
                    return -1;
                }
                return 1;
            }
            int n3 = this._minorVersion - n;
            if (n3 != 0) {
                return n3;
            }
            return this._buildNumber - n2;
        }
    }
}

