/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class PortingUtils {
    private static Rectangle SCREEN_BOUNDS = null;
    private static Thread _initializationThread = null;
    private static boolean INITIALIZE_SCREEN_AREA_USING_THREAD = true;

    public static Dimension getScreenSize(Component serializable) {
        PortingUtils.ensureScreenBounds();
        Dimension dimension = SCREEN_BOUNDS.getSize();
        if (serializable != null && !(serializable instanceof JApplet) && serializable.getGraphicsConfiguration() != null) {
            serializable = Toolkit.getDefaultToolkit().getScreenInsets(serializable.getGraphicsConfiguration());
            dimension.width -= ((Insets)serializable).left + ((Insets)serializable).right;
            dimension.height -= ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        return dimension;
    }

    public static Dimension getLocalScreenSize(Component object) {
        PortingUtils.ensureScreenBounds();
        if (object != null && !(object instanceof JApplet) && ((Component)object).getGraphicsConfiguration() != null) {
            object = ((Component)object).getGraphicsConfiguration();
            Rectangle rectangle = ((GraphicsConfiguration)object).getBounds();
            object = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)object);
            rectangle.width -= ((Insets)object).left + ((Insets)object).right;
            rectangle.height -= ((Insets)object).top + ((Insets)object).bottom;
            return rectangle.getSize();
        }
        return PortingUtils.getScreenSize((Component)object);
    }

    public static Rectangle getScreenBounds(Component serializable) {
        PortingUtils.ensureScreenBounds();
        Rectangle rectangle = (Rectangle)SCREEN_BOUNDS.clone();
        if (serializable != null && !(serializable instanceof JApplet) && serializable.getGraphicsConfiguration() != null) {
            serializable = Toolkit.getDefaultToolkit().getScreenInsets(serializable.getGraphicsConfiguration());
            rectangle.x += ((Insets)serializable).left;
            rectangle.y += ((Insets)serializable).top;
            rectangle.width -= ((Insets)serializable).left + ((Insets)serializable).right;
            rectangle.height -= ((Insets)serializable).top + ((Insets)serializable).bottom;
        }
        return rectangle;
    }

    public static Rectangle getLocalScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    private static void ensureScreenBounds() {
        if (SCREEN_BOUNDS == null) {
            SCREEN_BOUNDS = new Rectangle();
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray.getScreenDevices();
            graphicsDeviceArray = graphicsDeviceArray2;
            graphicsDeviceArray = graphicsDeviceArray2;
            int n = graphicsDeviceArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = graphicsDeviceArray[i];
                object = ((GraphicsDevice)object).getDefaultConfiguration();
                SCREEN_BOUNDS = SCREEN_BOUNDS.union(((GraphicsConfiguration)object).getBounds());
            }
        }
    }

    public static void notifyUser() {
        Object var0 = null;
        UIManager.getLookAndFeel().provideErrorFeedback(null);
    }

    public static void setMinimumSize(Component component, Dimension dimension) {
        if (SystemInfo.isJdk15Above()) {
            component.setMinimumSize(dimension);
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setMinimumSize(dimension);
        }
    }
}

