/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.SimpleScrollPaneLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class SimpleScrollPane
extends JScrollPane
implements MouseWheelListener,
ChangeListener {
    private AbstractButton _scrollUpButton;
    private AbstractButton _scrollDownButton;
    private AbstractButton _scrollLeftButton;
    private AbstractButton _scrollRightButton;
    private int _horizontalUnitIncrement = 10;
    private boolean _horizontalUnitIncrementSet = false;
    private int _verticalUnitIncrement = 10;
    private boolean _verticalUnitIncrementSet = false;
    private int _repeatDelay = 50;
    private boolean _scrollOnRollover = true;

    public SimpleScrollPane(Component component, int n, int n2) {
        SimpleScrollPane simpleScrollPane;
        this.setLayout(new SimpleScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewport(this.createViewport());
        AbstractButton abstractButton = this.createScrollButton(1);
        JComponent jComponent = simpleScrollPane = this;
        jComponent = simpleScrollPane._scrollUpButton;
        simpleScrollPane._scrollUpButton = abstractButton;
        simpleScrollPane.add((Component)simpleScrollPane._scrollUpButton, "SCROLL_UP_BUTTON");
        simpleScrollPane.firePropertyChange("scrollUpButton", jComponent, simpleScrollPane._scrollUpButton);
        simpleScrollPane.revalidate();
        simpleScrollPane.repaint();
        abstractButton = this.createScrollButton(5);
        jComponent = simpleScrollPane = this;
        jComponent = simpleScrollPane._scrollDownButton;
        simpleScrollPane._scrollDownButton = abstractButton;
        simpleScrollPane.add((Component)simpleScrollPane._scrollDownButton, "SCROLL_DOWN_BUTTON");
        simpleScrollPane.firePropertyChange("scrollDownButton", jComponent, simpleScrollPane._scrollDownButton);
        simpleScrollPane.revalidate();
        simpleScrollPane.repaint();
        abstractButton = this.createScrollButton(7);
        jComponent = simpleScrollPane = this;
        jComponent = simpleScrollPane._scrollLeftButton;
        simpleScrollPane._scrollLeftButton = abstractButton;
        simpleScrollPane.add((Component)simpleScrollPane._scrollLeftButton, "SCROLL_LEFT_BUTTON");
        simpleScrollPane.firePropertyChange("scrollLeftButton", jComponent, simpleScrollPane._scrollLeftButton);
        simpleScrollPane.revalidate();
        simpleScrollPane.repaint();
        abstractButton = this.createScrollButton(3);
        jComponent = simpleScrollPane = this;
        jComponent = simpleScrollPane._scrollRightButton;
        simpleScrollPane._scrollRightButton = abstractButton;
        simpleScrollPane.add((Component)simpleScrollPane._scrollRightButton, "SCROLL_RIGHT_BUTTON");
        simpleScrollPane.firePropertyChange("scrollRightButton", jComponent, simpleScrollPane._scrollRightButton);
        simpleScrollPane.revalidate();
        simpleScrollPane.repaint();
        if (component != null) {
            this.setViewportView(component);
        }
        this.updateButtonState();
        this.setOpaque(true);
        this.setFocusable(false);
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setVisible(false);
            this.getHorizontalScrollBar().setFocusable(false);
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setVisible(false);
            this.getVerticalScrollBar().setFocusable(false);
        }
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
        if (this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
    }

    public SimpleScrollPane() {
        this(null, 20, 30);
    }

    public void updateUI() {
        super.updateUI();
        this.setLayout(new SimpleScrollPaneLayout.UIResource());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
        this.getViewport().addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getViewport()) {
            this.updateButtonState();
        }
    }

    public final AbstractButton getScrollUpButton() {
        return this._scrollUpButton;
    }

    public final AbstractButton getScrollDownButton() {
        return this._scrollDownButton;
    }

    public final AbstractButton getScrollLeftButton() {
        return this._scrollLeftButton;
    }

    public final AbstractButton getScrollRightButton() {
        return this._scrollRightButton;
    }

    private AbstractButton createScrollButton(int n) {
        return new ScrollButton(this, n);
    }

    protected final void updateButtonState() {
        Point point = this.viewport.getViewPosition();
        this._scrollUpButton.setEnabled(point.y != 0);
        this._scrollDownButton.setEnabled(point.y != this.viewport.getViewSize().height - this.viewport.getViewRect().height);
        this._scrollLeftButton.setEnabled(point.x != 0);
        this._scrollRightButton.setEnabled(point.x != this.viewport.getViewSize().width - this.viewport.getViewRect().width);
        this.revalidate();
        this.repaint();
    }

    public final void scroll(JViewport jViewport, int n) {
        Point point = jViewport.getViewPosition();
        Serializable serializable = this.getViewport();
        switch (n) {
            case 1: {
                if (serializable != null && serializable.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)serializable.getView());
                    serializable = serializable.getViewRect();
                    point.y -= scrollable.getScrollableUnitIncrement((Rectangle)serializable, 1, -1);
                } else {
                    SimpleScrollPane simpleScrollPane = this;
                    point.y -= simpleScrollPane._verticalUnitIncrement;
                }
                if (point.y >= 0) break;
                point.y = 0;
                break;
            }
            case 5: {
                if (serializable != null && serializable.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)serializable.getView());
                    serializable = serializable.getViewRect();
                    point.y += scrollable.getScrollableUnitIncrement((Rectangle)serializable, 1, 1);
                } else {
                    SimpleScrollPane simpleScrollPane = this;
                    point.y += simpleScrollPane._verticalUnitIncrement;
                }
                if (point.y + jViewport.getViewRect().height <= jViewport.getViewSize().height) break;
                point.y = jViewport.getViewSize().height - jViewport.getViewRect().height;
                break;
            }
            case 7: {
                if (serializable != null && serializable.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)serializable.getView());
                    serializable = serializable.getViewRect();
                    point.x -= scrollable.getScrollableUnitIncrement((Rectangle)serializable, 0, -1);
                } else {
                    SimpleScrollPane simpleScrollPane = this;
                    point.x -= simpleScrollPane._horizontalUnitIncrement;
                }
                if (point.x >= 0) break;
                point.x = 0;
                break;
            }
            case 3: {
                if (serializable != null && serializable.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)serializable.getView());
                    serializable = serializable.getViewRect();
                    point.x += scrollable.getScrollableUnitIncrement((Rectangle)serializable, 0, 1);
                } else {
                    SimpleScrollPane simpleScrollPane = this;
                    point.x += simpleScrollPane._horizontalUnitIncrement;
                }
                if (point.x + jViewport.getViewRect().width <= jViewport.getViewSize().width) break;
                point.x = jViewport.getViewSize().width - jViewport.getViewRect().width;
            }
        }
        jViewport.setViewPosition(point);
    }

    public Rectangle getViewportBorderBounds() {
        Rectangle rectangle = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
            rectangle.y += this._scrollUpButton.getHeight();
            rectangle.height -= this._scrollUpButton.getHeight();
        }
        if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
            rectangle.x += this._scrollLeftButton.getWidth();
            rectangle.width -= this._scrollLeftButton.getWidth();
        }
        if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
            rectangle.height -= this._scrollDownButton.getHeight();
        }
        if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
            rectangle.width -= this._scrollRightButton.getWidth();
        }
        return rectangle;
    }

    public final boolean isScrollOnRollover() {
        return this._scrollOnRollover;
    }

    public final int getRepeatDelay() {
        return this._repeatDelay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        boolean bl;
        int n2;
        if (!this.isWheelScrollingEnabled()) return;
        if (mouseWheelEvent.getScrollAmount() == 0) return;
        int n3 = n2 = mouseWheelEvent.getWheelRotation() >= 0 ? 1 : 0;
        SimpleScrollPane simpleScrollPane = this;
        if (n3 != 0) {
            if (simpleScrollPane._scrollUpButton == null || !simpleScrollPane._scrollUpButton.isVisible()) {
                if (simpleScrollPane._scrollLeftButton == null) return;
                if (!simpleScrollPane._scrollLeftButton.isVisible()) return;
            }
            bl = true;
        } else {
            if (simpleScrollPane._scrollDownButton == null || !simpleScrollPane._scrollDownButton.isVisible()) {
                if (simpleScrollPane._scrollRightButton == null) return;
                if (!simpleScrollPane._scrollRightButton.isVisible()) return;
            }
            bl = true;
        }
        if (!bl) {
            return;
        }
        n3 = n2;
        simpleScrollPane = this;
        if (n3 != 0) {
            if (simpleScrollPane._scrollUpButton != null && simpleScrollPane._scrollUpButton.isVisible()) {
                n = 5;
            } else {
                if (simpleScrollPane._scrollLeftButton == null) return;
                if (!simpleScrollPane._scrollLeftButton.isVisible()) return;
                n = 3;
            }
        } else if (simpleScrollPane._scrollDownButton != null && simpleScrollPane._scrollDownButton.isVisible()) {
            n = 1;
        } else {
            if (simpleScrollPane._scrollRightButton == null) return;
            if (!simpleScrollPane._scrollRightButton.isVisible()) return;
            n = 7;
        }
        n2 = n;
        if (n == 0) return;
        this.scroll(this.getViewport(), n2);
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl && !this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
        if (!bl && this.isWheelScrollingEnabled()) {
            this.removeMouseWheelListener(this);
        }
        super.setWheelScrollingEnabled(bl);
    }

    public final class ScrollButton
    extends JideButton
    implements ActionListener,
    MouseListener,
    UIResource {
        private int _type;
        private Timer _timer;
        private /* synthetic */ SimpleScrollPane this$0;

        public ScrollButton(SimpleScrollPane simpleScrollPane, int n) {
            this.this$0 = simpleScrollPane;
            this._type = n;
            switch (n) {
                case 1: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_up.gif"));
                    break;
                }
                case 5: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
                    break;
                }
                case 7: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
                    break;
                }
                case 3: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
                }
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            this.this$0.scroll(this.this$0.getViewport(), this._type);
            this.this$0.updateButtonState();
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            if (!this.this$0.isScrollOnRollover()) {
                this.startTimer(mouseEvent, 500);
                return;
            }
            this.updateTimer(mouseEvent);
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            if (!this.this$0.isScrollOnRollover()) {
                this.stopTimer();
                return;
            }
            this.updateTimer(mouseEvent);
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            if (this.this$0.isScrollOnRollover()) {
                this.startTimer(mouseEvent, 500);
            }
        }

        private void updateTimer(MouseEvent mouseEvent) {
            if (this._timer != null) {
                this._timer.setDelay(this.getDelay(mouseEvent));
            }
        }

        private void startTimer(MouseEvent mouseEvent, int n) {
            this.stopTimer();
            this._timer = new Timer(this.getDelay(mouseEvent), this);
            this._timer.setInitialDelay(500);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
        }

        private int getDelay(MouseEvent mouseEvent) {
            if (this.this$0.isScrollOnRollover()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return this.this$0.getRepeatDelay();
                }
                return this.this$0.getRepeatDelay() << 1;
            }
            return this.this$0.getRepeatDelay();
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            if (this.this$0.isScrollOnRollover()) {
                this.stopTimer();
            }
        }
    }
}

