/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ArrowKeyNavigationSupport {
    private int[] _keyCode = new int[]{37, 39, 38, 40};
    private Class[] _componentTypes;

    public ArrowKeyNavigationSupport() {
    }

    public ArrowKeyNavigationSupport(Class[] classArray) {
        this._componentTypes = classArray;
    }

    public final void install(JComponent jComponent) {
        int[] nArray = this._keyCode;
        int n = this._keyCode.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            Object object = jComponent.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(n2, 0);
            if ((object = ((InputMap)object).get(keyStroke)) != null) {
                jComponent.putClientProperty("ArrowKeyNavigationSupport.previousAction", object);
            }
            jComponent.registerKeyboardAction(new NavigationAction(jComponent, n2), "ArrowKeyNavigation " + n2, keyStroke, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class NavigationAction
    implements ActionListener {
        private JComponent _parent;
        private int _keyCode;

        public NavigationAction(JComponent jComponent, int n) {
            this._parent = jComponent;
            this._keyCode = n;
        }

        @Override
        public final void actionPerformed(ActionEvent serializable) {
            serializable = new ArrayList();
            ArrayList<Component> arrayList = new ArrayList<Component>();
            JideSwingUtilities.setRecursively(this._parent, new JideSwingUtilities.Handler(this, (List)((Object)serializable), arrayList){
                private /* synthetic */ List val$rects;
                private /* synthetic */ List val$components;
                private /* synthetic */ NavigationAction this$1;
                {
                    this.this$1 = navigationAction;
                    this.val$rects = list;
                    this.val$components = list2;
                }

                public final void action(Component component) {
                    if (this.this$1.ArrowKeyNavigationSupport.this._componentTypes != null) {
                        boolean bl = false;
                        for (Class clazz : this.this$1.ArrowKeyNavigationSupport.this._componentTypes) {
                            if (!clazz.isAssignableFrom(component.getClass())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            return;
                        }
                    }
                    Rectangle rectangle = component.getBounds();
                    this.val$rects.add(SwingUtilities.convertRectangle(component, rectangle, this.this$1._parent));
                    this.val$components.add(component);
                }

                public final boolean condition(Component component) {
                    return component.isVisible() && component.isDisplayable() && component.isFocusable() && component.isEnabled();
                }

                public Color getBackgroundAt(int n) {
                    return JideTabbedPane.access$300()[n % JideTabbedPane.access$300().length];
                }

                public Color getForegroudAt$361b9f0e() {
                    return Color.BLACK;
                }
                {
                    this(0);
                }
            });
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component component2 = null;
            switch (this._keyCode) {
                case 39: {
                    component2 = this.findComponentToRight(component, (List<Rectangle>)((Object)serializable), arrayList);
                    break;
                }
                case 37: {
                    component2 = this.findComponentToLeft(component, (List<Rectangle>)((Object)serializable), arrayList);
                    break;
                }
                case 38: {
                    component2 = this.findComponentToAbove(component, (List<Rectangle>)((Object)serializable), arrayList);
                    break;
                }
                case 40: {
                    component2 = this.findComponentToBelow(component, (List<Rectangle>)((Object)serializable), arrayList);
                }
            }
            if (component2 != null) {
                component2.requestFocusInWindow();
            }
        }

        private Component findComponentToRight(Component serializable, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component = null;
            serializable = SwingUtilities.convertRectangle(serializable, serializable.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle = list.get(i);
                if (rectangle.x <= ((Rectangle)serializable).x + ((Rectangle)serializable).width || rectangle.y + rectangle.height < ((Rectangle)serializable).y || rectangle.y > ((Rectangle)serializable).y + ((Rectangle)serializable).height || (n2 = rectangle.x - ((Rectangle)serializable).x - ((Rectangle)serializable).width) >= n) continue;
                n = n2;
                component = list2.get(i);
            }
            return component;
        }

        private Component findComponentToBelow(Component serializable, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component = null;
            serializable = SwingUtilities.convertRectangle(serializable, serializable.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle = list.get(i);
                if (rectangle.y <= ((Rectangle)serializable).y + ((Rectangle)serializable).height || rectangle.x + rectangle.width < ((Rectangle)serializable).x || rectangle.x > ((Rectangle)serializable).x + ((Rectangle)serializable).width || (n2 = rectangle.y - ((Rectangle)serializable).y - ((Rectangle)serializable).height) >= n) continue;
                n = n2;
                component = list2.get(i);
            }
            return component;
        }

        private Component findComponentToLeft(Component serializable, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component = null;
            serializable = SwingUtilities.convertRectangle(serializable, serializable.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle = list.get(i);
                if (rectangle.x + rectangle.width >= ((Rectangle)serializable).x || rectangle.y + rectangle.height < ((Rectangle)serializable).y || rectangle.y > ((Rectangle)serializable).y + ((Rectangle)serializable).height || (n2 = ((Rectangle)serializable).x - rectangle.x - rectangle.width) >= n) continue;
                n = n2;
                component = list2.get(i);
            }
            return component;
        }

        private Component findComponentToAbove(Component serializable, List<Rectangle> list, List<Component> list2) {
            int n = Integer.MAX_VALUE;
            Component component = null;
            serializable = SwingUtilities.convertRectangle(serializable, serializable.getBounds(), this._parent);
            for (int i = 0; i < list.size(); ++i) {
                int n2;
                Rectangle rectangle = list.get(i);
                if (rectangle.y + rectangle.height >= ((Rectangle)serializable).y || rectangle.x + rectangle.width < ((Rectangle)serializable).x || rectangle.x > ((Rectangle)serializable).x + ((Rectangle)serializable).width || (n2 = ((Rectangle)serializable).y - rectangle.y - rectangle.height) >= n) continue;
                n = n2;
                component = list2.get(i);
            }
            return component;
        }
    }
}

