/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.RangeSlider;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicRangeSliderUI
extends BasicSliderUI {
    protected Icon _lowerIcon;
    protected Icon _upperIcon;
    protected Icon _middleIcon;
    protected Icon _lowerIconV;
    protected Icon _upperIconV;
    protected Icon _middleIconV;

    public BasicRangeSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRangeSliderUI((JSlider)jComponent);
    }

    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.resetAllIcons();
    }

    protected final void resetAllIcons() {
        this._lowerIcon = UIDefaultsLookup.getIcon("RangeSlider.lowerIcon");
        this._upperIcon = UIDefaultsLookup.getIcon("RangeSlider.upperIcon");
        this._middleIcon = UIDefaultsLookup.getIcon("RangeSlider.middleIcon");
        this._lowerIconV = UIDefaultsLookup.getIcon("RangeSlider.lowerVIcon");
        this._upperIconV = UIDefaultsLookup.getIcon("RangeSlider.upperVIcon");
        this._middleIconV = UIDefaultsLookup.getIcon("RangeSlider.middleVIcon");
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this._lowerIcon = null;
        this._upperIcon = null;
        this._middleIcon = null;
        this._lowerIconV = null;
        this._upperIconV = null;
        this._middleIconV = null;
    }

    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 1) {
            this.trackRect.x += 4;
            return;
        }
        this.trackRect.y += 4;
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener(this);
    }

    protected final int getMouseHandle(int n, int n2) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 1) {
            int n3 = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            int n4 = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width / 2, n3 - this._lowerIconV.getIconHeight() / 2, this._lowerIcon.getIconWidth(), this._lowerIconV.getIconHeight());
            if (rectangle2.contains(n, n2)) {
                return 1;
            }
            rectangle2 = new Rectangle(rectangle.x, n4 - this._upperIconV.getIconHeight() / 2, this._upperIconV.getIconWidth(), this._upperIconV.getIconHeight());
            if (rectangle2.contains(n, n2)) {
                return 2;
            }
            rectangle = new Rectangle(rectangle.x - this._middleIcon.getIconWidth(), n4 - this._middleIconV.getIconHeight() / 2, this._middleIconV.getIconWidth(), this._middleIconV.getIconHeight());
            if (rectangle.contains(n, n2)) {
                return 4;
            }
            return 0;
        }
        int n5 = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        int n6 = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
        Rectangle rectangle3 = new Rectangle(n5 - this._lowerIcon.getIconWidth() / 2, rectangle.y + rectangle.height / 2, this._lowerIcon.getIconWidth(), this._lowerIcon.getIconHeight());
        if (rectangle3.contains(n, n2)) {
            return 1;
        }
        rectangle3 = new Rectangle(n6 - this._upperIcon.getIconWidth() / 2, rectangle.y, this._upperIcon.getIconWidth(), this._upperIcon.getIconHeight());
        if (rectangle3.contains(n, n2)) {
            return 2;
        }
        rectangle = new Rectangle(n6 - this._middleIcon.getIconWidth() / 2, rectangle.y - this._middleIcon.getIconHeight(), this._middleIcon.getIconWidth(), this._middleIcon.getIconHeight());
        if (rectangle.contains(n, n2)) {
            return 4;
        }
        return 0;
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        RangeSlider rangeSlider = (RangeSlider)this.slider;
        if (this.slider.getOrientation() == 1) {
            int n = this.yPositionForValue(rangeSlider.getLowValue());
            int n2 = this.yPositionForValue(rangeSlider.getHighValue());
            this._lowerIconV.paintIcon(this.slider, graphics, rectangle.x + rectangle.width / 2, n - this._lowerIconV.getIconHeight() / 2);
            this._upperIconV.paintIcon(this.slider, graphics, rectangle.x, n2 - this._upperIconV.getIconHeight() / 2);
            this._middleIconV.paintIcon(this.slider, graphics, rectangle.x - this._middleIconV.getIconWidth(), n2 - this._middleIconV.getIconHeight() / 2);
            return;
        }
        int n = this.xPositionForValue(rangeSlider.getLowValue());
        int n3 = this.xPositionForValue(rangeSlider.getHighValue());
        this._lowerIcon.paintIcon(this.slider, graphics, n - this._lowerIcon.getIconWidth() / 2, rectangle.y + rectangle.height / 2);
        this._upperIcon.paintIcon(this.slider, graphics, n3 - this._upperIcon.getIconWidth() / 2, rectangle.y);
        this._middleIcon.paintIcon(this.slider, graphics, n3 - this._middleIcon.getIconWidth() / 2, rectangle.y - this._middleIcon.getIconHeight());
    }

    protected void setMouseRollover(int n) {
    }

    static /* synthetic */ void access$1700(BasicRangeSliderUI basicRangeSliderUI, int n) {
        basicRangeSliderUI.slider.getModel().setValue(((RangeSlider)basicRangeSliderUI.slider).getLowValue() + n);
    }

    public final class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        private int handle;
        private int handleOffset;
        private int mouseStartLocation;
        private /* synthetic */ BasicRangeSliderUI this$0;

        public RangeTrackListener(BasicRangeSliderUI basicRangeSliderUI) {
            this.this$0 = basicRangeSliderUI;
            super(basicRangeSliderUI);
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.handle = this.this$0.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            this.handleOffset = this.this$0.slider.getOrientation() == 1 ? mouseEvent.getY() - this.this$0.yPositionForValue(((RangeSlider)this.this$0.slider).getLowValue()) : mouseEvent.getX() - this.this$0.xPositionForValue(((RangeSlider)this.this$0.slider).getLowValue());
            this.mouseStartLocation = this.this$0.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            this.this$0.slider.getModel().setValueIsAdjusting(true);
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            int n = this.this$0.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            int n2 = this.this$0.slider.getOrientation() == 1 ? this.this$0.valueForYPosition(n) : this.this$0.valueForXPosition(n);
            if (n2 < this.this$0.slider.getModel().getMinimum()) {
                n2 = this.this$0.slider.getModel().getMinimum();
            }
            if (n2 > this.this$0.slider.getModel().getMaximum()) {
                n2 = this.this$0.slider.getModel().getMaximum();
            }
            if (this.handle == 3) {
                if (n - this.mouseStartLocation > 2) {
                    this.handle = 2;
                } else if (n - this.mouseStartLocation < -2) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)this.this$0.slider;
            switch (this.handle) {
                case 1: {
                    n2 = Math.min(n2, rangeSlider.getHighValue());
                    RangeSlider rangeSlider2 = rangeSlider;
                    int n3 = n2 + rangeSlider2.getModel().getExtent() > rangeSlider2.getMaximum() ? rangeSlider2.getMaximum() : rangeSlider2.getHighValue();
                    rangeSlider2.getModel().setRangeProperties(n2, n3 -= n2, rangeSlider2.getMinimum(), rangeSlider2.getMaximum(), true);
                    return;
                }
                case 2: {
                    n2 = Math.max(rangeSlider.getLowValue(), n2);
                    RangeSlider rangeSlider3 = rangeSlider;
                    rangeSlider3.getModel().setExtent(n2 - rangeSlider3.getLowValue());
                    return;
                }
                case 4: {
                    n = this.this$0.slider.getOrientation() == 1 ? this.this$0.valueForYPosition(n - this.handleOffset) - rangeSlider.getLowValue() : this.this$0.valueForXPosition(n - this.handleOffset) - rangeSlider.getLowValue();
                    if (n < 0 && rangeSlider.getLowValue() + n < rangeSlider.getMinimum()) {
                        n = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (n > 0 && rangeSlider.getHighValue() + n > rangeSlider.getMaximum()) {
                        n = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (n == 0) break;
                    BasicRangeSliderUI.access$1700(this.this$0, n);
                }
            }
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.this$0.slider.getModel().setValueIsAdjusting(false);
        }

        private void setCursor(int n) {
            Cursor cursor = Cursor.getPredefinedCursor(n);
            if (this.this$0.slider.getCursor() != cursor) {
                this.this$0.slider.setCursor(cursor);
            }
        }

        public final void mouseMoved(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            switch (this.this$0.getMouseHandle(mouseEvent.getX(), mouseEvent.getY())) {
                case 1: {
                    this.this$0.setMouseRollover(1);
                    this.setCursor(this.this$0.slider.getOrientation() == 1 ? 8 : 10);
                    return;
                }
                case 2: {
                    this.this$0.setMouseRollover(2);
                    this.setCursor(this.this$0.slider.getOrientation() == 1 ? 9 : 11);
                    return;
                }
                case 4: {
                    this.this$0.setMouseRollover(4);
                    this.setCursor(13);
                    return;
                }
                case 0: {
                    this.this$0.setMouseRollover(0);
                    this.setCursor(0);
                }
            }
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                this.this$0.slider.getModel().setValue(this.this$0.slider.getModel().getMinimum());
                this.this$0.slider.getModel().setExtent(this.this$0.slider.getModel().getMaximum() - this.this$0.slider.getModel().getMinimum());
                this.this$0.slider.repaint();
            }
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            this.setCursor(0);
        }
    }
}

