/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.broker;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.apps.broker.CommonCmdException;
import com.sun.messaging.jmq.admin.apps.broker.CommonHelpPrinter;
import com.sun.messaging.jmq.admin.apps.console.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.CommonGlobals;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.options.BadNameValueArgException;
import com.sun.messaging.jmq.util.options.InvalidBasePropNameException;
import com.sun.messaging.jmq.util.options.InvalidHardCodedValueException;
import com.sun.messaging.jmq.util.options.MissingArgException;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class CommonCmdRunnerUtil {
    private static AdminResources ar = Globals.getAdminResources();

    public static void printBrokerBusyEvent(CommonCmdStatusEvent commonCmdStatusEvent) {
        int n = commonCmdStatusEvent.getNumRetriesAttempted();
        int n2 = commonCmdStatusEvent.getMaxNumRetries();
        long l = commonCmdStatusEvent.getRetryTimeount();
        Object[] objectArray = new Object[]{Integer.toString(n), Integer.toString(n2), Long.toString(l)};
        String string = ar.getString("A1350", objectArray);
        CommonGlobals.stdOutPrintln(string);
    }

    public static String getTimeString(long l) {
        String string = null;
        if (l < 1000L) {
            string = l + " milliseconds";
        } else if (l < 60000L) {
            long l2 = l / 1000L;
            string = l2 + " seconds";
        } else if (l < 3600000L) {
            long l3 = l / 60000L;
            string = l3 + " minutes";
        } else {
            string = "> 1 hour";
        }
        return string;
    }

    public static String getRateString(long l, long l2, float f) {
        String string = "";
        long l3 = l - l2;
        long l4 = (long)((float)l3 / f);
        string = l4 == 0L ? (l3 != 0L ? "< 1" : "0") : Long.toString(l4);
        return string;
    }

    public static String displayInKBytes(long l) {
        if (l == 0L) {
            return "0";
        }
        if (l < 1024L) {
            return "< 1";
        }
        return Long.toString(l / 1024L);
    }

    public static void printDebugHash(Hashtable hashtable) {
        DebugPrinter debugPrinter = new DebugPrinter(hashtable, 4);
        debugPrinter.println();
        debugPrinter.close();
    }

    public static String getBrokerHost(String string) {
        String string2 = string;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public static int getBrokerPort(String string) throws BrokerAdminException {
        int n = -1;
        if (string == null) {
            return n;
        }
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (Exception exception) {
                throw new BrokerAdminException(8);
            }
        }
        return n;
    }

    public static void printBrokerAdminException(BrokerAdminException brokerAdminException, String string, boolean bl) {
        Exception exception = brokerAdminException.getLinkedException();
        int n = brokerAdminException.getType();
        switch (n) {
            case 0: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                CommonGlobals.stdErrPrintln(ar.getString("A3139", string));
                break;
            }
            case 1: {
                CommonGlobals.stdErrPrintln(ar.getString("A3121"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 2: {
                CommonGlobals.stdErrPrintln(ar.getString("A3122"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 3: {
                CommonGlobals.stdErrPrintln(ar.getString("A3123"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 4: {
                CommonGlobals.stdErrPrintln(ar.getString("A3124"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 5: {
                CommonGlobals.stdErrPrintln(ar.getString("A3125"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 6: {
                CommonGlobals.stdErrPrintln(ar.getString("A3126"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 7: {
                CommonGlobals.stdErrPrintln(ar.getString("A3127"));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                break;
            }
            case 8: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3128"));
                break;
            }
            case 11: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                CommonGlobals.stdErrPrintln(ar.getString("A3140"));
                break;
            }
            case 12: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                CommonGlobals.stdErrPrintln(ar.getString("A3141"));
                break;
            }
            case 15: {
                CommonGlobals.stdErrPrintln(ar.getString("A3120", brokerAdminException.getBrokerHost(), brokerAdminException.getBrokerPort()));
                CommonCmdRunnerUtil.printBrokerAdminExceptionDetails(brokerAdminException, bl);
                CommonGlobals.stdErrPrintln(ar.getString("A3154"));
                break;
            }
            case 16: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3167", brokerAdminException.getBrokerAddress()));
            }
        }
    }

    private static void printBrokerAdminExceptionDetails(BrokerAdminException brokerAdminException, boolean bl) {
        Exception exception = brokerAdminException.getLinkedException();
        String string = brokerAdminException.getBrokerErrorStr();
        if (string != null) {
            CommonGlobals.stdErrPrintln(string);
        }
        if (exception != null) {
            String string2 = exception.getMessage();
            String string3 = exception.toString();
            if (string3 != null) {
                CommonGlobals.stdErrPrintln(string3);
            } else if (string2 != null) {
                CommonGlobals.stdErrPrintln(string2);
            }
            if (bl) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public static void printCommonCmdException(CommonCmdException commonCmdException) {
        Exception exception = commonCmdException.getLinkedException();
        int n = commonCmdException.getType();
        switch (n) {
            case 10006: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3161", exception));
                break;
            }
            default: {
                CommonGlobals.stdErrPrintln("Unknown exception caught: " + n);
            }
        }
    }

    public static String getUserInput(String string) {
        return CommonCmdRunnerUtil.getUserInput(string, null);
    }

    public static String getUserInput(String string, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            CommonGlobals.stdOutPrint(string);
            String string3 = bufferedReader.readLine();
            if (string3.equals("") && string2 != null) {
                string3 = string2;
            }
            return string3;
        }
        catch (IOException iOException) {
            CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3081"));
            return null;
        }
    }

    public static String getPassword() {
        Password password = new Password();
        CommonGlobals.stdOutPrint(ar.getString("A1621"));
        return password.getPassword();
    }

    public static void printBrokerInfo(BrokerAdminConn brokerAdminConn, MultiColumnPrinter multiColumnPrinter) {
        multiColumnPrinter.setNumCol(2);
        multiColumnPrinter.setGap(4);
        multiColumnPrinter.setBorder("-");
        Object[] objectArray = new String[2];
        objectArray[0] = ar.getString("A1440");
        objectArray[1] = ar.getString("A1441");
        multiColumnPrinter.addTitle((String[])objectArray);
        objectArray[0] = brokerAdminConn.getBrokerHost();
        objectArray[1] = brokerAdminConn.getBrokerPort();
        multiColumnPrinter.add(objectArray);
        multiColumnPrinter.println();
    }

    public static void printAttrs(Properties properties, boolean bl, MultiColumnPrinter multiColumnPrinter) {
        Object[] objectArray = new String[2];
        if (bl) {
            multiColumnPrinter.setNumCol(2);
            multiColumnPrinter.setGap(4);
            multiColumnPrinter.setBorder("-");
            objectArray[0] = "Property Name";
            objectArray[1] = "Property Value";
            multiColumnPrinter.addTitle((String[])objectArray);
        } else {
            multiColumnPrinter.setNumCol(2);
            multiColumnPrinter.setGap(4);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            objectArray[0] = string;
            objectArray[1] = string2;
            multiColumnPrinter.add(objectArray);
        }
        multiColumnPrinter.println();
    }

    public static String checkNullAndReturnPrint(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public static String checkNullAndReturnPrintTimestamp(Long l) {
        if (l != null) {
            Date date = new Date(l);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            String string = dateFormat.format(date);
            return string;
        }
        return "";
    }

    public static BrokerAdminConn promptForAuthentication(BrokerAdminConn brokerAdminConn) {
        String string = brokerAdminConn.getUserName();
        String string2 = brokerAdminConn.getPassword();
        boolean bl = false;
        if (string == null) {
            brokerAdminConn.setUserName(CommonCmdRunnerUtil.getUserInput(ar.getString("A1620")));
            bl = true;
        }
        if (string2 == null) {
            String string3 = CommonCmdRunnerUtil.getPassword();
            brokerAdminConn.setPassword(string3);
            bl = false;
        }
        if (bl) {
            CommonGlobals.stdOutPrintln("");
        }
        return brokerAdminConn;
    }

    public static String getPasswordFromFile(String string, String string2, Properties properties) throws CommonCmdException {
        if (string != null) {
            String string3 = null;
            try {
                Properties properties2 = new Properties();
                InputStream inputStream = FileUtil.retrieveObfuscatedFile(string);
                properties2.load(inputStream);
                string3 = properties2.getProperty(string2);
                inputStream.close();
                if (string3 == null) {
                    throw new RuntimeException(ar.getString("A3162", string2, string));
                }
            }
            catch (Exception exception) {
                CommonCmdException commonCmdException = new CommonCmdException(10006);
                commonCmdException.setProperties(properties);
                commonCmdException.setLinkedException(exception);
                throw commonCmdException;
            }
            return string3;
        }
        return null;
    }

    public static void handleArgsParsingExceptions(OptionException optionException, String string, String string2) {
        String string3 = optionException.getOption();
        if (optionException instanceof UnrecognizedOptionException) {
            if (string != null && string3.equals(string)) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3006", string3));
            } else {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3001", string3, string2));
            }
        } else if (optionException instanceof InvalidBasePropNameException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3002", string3));
        } else if (optionException instanceof InvalidHardCodedValueException) {
            Globals.stdErrPrintln(ar.getString("A1002"), ar.getKString("A3003", string3));
        } else if (optionException instanceof MissingArgException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3004", string3, string2));
        } else if (optionException instanceof BadNameValueArgException) {
            BadNameValueArgException badNameValueArgException = (BadNameValueArgException)optionException;
            String string4 = badNameValueArgException.getArg();
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3005", string4, string3));
        } else {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3000"));
        }
    }

    public static void printBanner() {
        Version version = new Version(false);
        CommonGlobals.stdOutPrintln(version.getBanner(false));
    }

    public static void printVersion() {
        Version version = new Version(false);
        Globals.stdOutPrintln(version.getVersion());
        Globals.stdOutPrintln(ar.getString("A1065") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
    }

    public static void handleCommonCheckOptionsExceptions(CommonCmdException commonCmdException, String string, String string2, CommonHelpPrinter commonHelpPrinter) {
        String string3 = commonCmdException.getErrorString();
        String string4 = commonCmdException.getBadValue();
        String[] stringArray = commonCmdException.getValidCmdArgs();
        int n = commonCmdException.getType();
        switch (n) {
            case 10000: {
                CommonCmdRunnerUtil.printBanner();
                commonHelpPrinter.printShortHelp(1);
                break;
            }
            case 10001: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3021", string));
                break;
            }
            case 10003: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3101", string, string2));
                if (stringArray == null) break;
                CommonGlobals.stdErrPrintln(ar.getString("A3102", string));
                for (int i = 0; i < stringArray.length; ++i) {
                    CommonGlobals.stdErrPrintln("\t" + stringArray[i]);
                }
                break;
            }
            case 10004: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3118", string3));
                break;
            }
            case 10005: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3158", string3));
                break;
            }
            case 10007: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3165", string4));
                break;
            }
            default: {
                CommonGlobals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3020"));
            }
        }
    }
}

