/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.StreamMessage;

public final class StreamMessageReader
extends PersistedMessageReader {
    private ArrayList stream_data = new ArrayList();

    public final File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile2 = super.readPersistedMessage(msgArchive);
        BufferedReader br = null;
        File def_file = new File(workdirFile2.getAbsolutePath() + File.separator + "StreamMessageDef");
        if (!def_file.exists()) {
            StreamMessageReader.clearDir(workdirFile2);
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg334") + def_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg335"));
        }
        try {
            br = new BufferedReader(new FileReader(def_file));
            String line = null;
            while ((line = br.readLine()) != null) {
                Property map_prop = new Property();
                ArrayList ar = QBrowserUtil.parseDelimitedString(line, "@@@HzRpWr@@");
                block10: for (int i = 0; i < ar.size(); ++i) {
                    String token = (String)ar.get(i);
                    switch (i) {
                        case 0: {
                            map_prop.setKey(token);
                            continue block10;
                        }
                        case 1: {
                            map_prop.setProperty_type(token);
                            continue block10;
                        }
                        case 2: {
                            Object fullpath = workdirFile2.getAbsolutePath() + File.separator + "StreamMessage" + File.separator + token;
                            Property property = map_prop;
                            String string = fullpath;
                            fullpath = this;
                            fullpath = property.getProperty_type();
                            if (((String)fullpath).equals("String")) {
                                property.setProperty_value(StreamMessageReader.readFileIntoString(new File(string)));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Int")) {
                                property.setProperty_value(Integer.parseInt(StreamMessageReader.readFileIntoString(new File(string))));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Boolean")) {
                                property.setProperty_value(Boolean.parseBoolean(StreamMessageReader.readFileIntoString(new File(string))));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Bytes")) {
                                property.setProperty_value(StreamMessageReader.readFileIntoBytes(new File(string)));
                                property.validated_type = 10;
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Byte")) {
                                property.setProperty_value(Byte.parseByte(StreamMessageReader.readFileIntoString(new File(string))));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Char")) {
                                property.setProperty_value(StreamMessageReader.readFileIntoString(new File(string)));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Double")) {
                                property.setProperty_value(Double.parseDouble(StreamMessageReader.readFileIntoString(new File(string))));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Float")) {
                                property.setProperty_value(Float.valueOf(Float.parseFloat(StreamMessageReader.readFileIntoString(new File(string)))));
                                property.selfValidate();
                                continue block10;
                            }
                            if (((String)fullpath).equals("Long")) {
                                property.setProperty_value(Long.parseLong(StreamMessageReader.readFileIntoString(new File(string))));
                                property.selfValidate();
                                continue block10;
                            }
                            if (!((String)fullpath).equals("Short")) continue block10;
                            property.setProperty_value(Short.parseShort(StreamMessageReader.readFileIntoString(new File(string))));
                            property.selfValidate();
                        }
                    }
                }
                this.stream_data.add(map_prop);
            }
        }
        catch (Exception ie) {
            try {
                StreamMessageReader.clearDir(workdirFile2);
                ie.printStackTrace();
                throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + ie.getMessage() + "\n\nFile=" + def_file.getName());
            }
            catch (Throwable workdirFile2) {
                if (br != null) {
                    br.close();
                }
                throw workdirFile2;
            }
        }
        br.close();
        return workdirFile2;
    }

    public final File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        return workdirFile;
    }

    public final LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        StreamMessage smsg = session.createStreamMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        lmc.setReal_file_path(this.source_file_path);
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)smsg);
        }
        lmc.setMessage((Message)smsg);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)smsg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        try {
            block16: for (int i = 0; i < this.stream_data.size(); ++i) {
                Property sm_body_data = (Property)this.stream_data.get(i);
                switch (sm_body_data.validated_type) {
                    case 0: {
                        continue block16;
                    }
                    case 10: {
                        smsg.writeBytes(sm_body_data.getProperty_valueASBytes());
                        continue block16;
                    }
                    case 1: {
                        smsg.writeString(sm_body_data.getProperty_valueASString());
                        continue block16;
                    }
                    case 3: {
                        smsg.writeBoolean(sm_body_data.getProperty_valueASBoolean());
                        continue block16;
                    }
                    case 2: {
                        smsg.writeInt(sm_body_data.getProperty_valueASInt());
                        continue block16;
                    }
                    case 4: {
                        smsg.writeByte(sm_body_data.getProperty_valueASByte());
                        continue block16;
                    }
                    case 11: {
                        smsg.writeChar(sm_body_data.getProperty_valueASCharacter());
                        continue block16;
                    }
                    case 9: {
                        byte[] bytesarray = QBrowserUtil.extractBytes(sm_body_data.getProperty_valueASString());
                        if (bytesarray == null) {
                            throw new Exception("Q0021");
                        }
                        smsg.writeBytes(bytesarray);
                        continue block16;
                    }
                    case 5: {
                        byte[] bytesarray;
                        smsg.writeDouble(bytesarray.getProperty_valueASDouble());
                        continue block16;
                    }
                    case 6: {
                        byte[] bytesarray;
                        smsg.writeFloat(bytesarray.getProperty_valueASFloat());
                        continue block16;
                    }
                    case 7: {
                        byte[] bytesarray;
                        smsg.writeLong(bytesarray.getProperty_valueASLong());
                        continue block16;
                    }
                    case 8: {
                        byte[] bytesarray;
                        smsg.writeShort(bytesarray.getProperty_valueASShort());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Throwable thex = throwable;
            throwable.printStackTrace();
        }
        return lmc;
    }

    public final LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setMessage_type("StreamMessage");
        return lmc;
    }
}

