/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.Zipper;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;

public class MessagePersister {
    Message message;
    LocalMessageContainer lmc;
    private ArrayList headers = new ArrayList();
    private ArrayList properties = new ArrayList();
    StringBuilder sbuf;
    static ResourceBundle resources = QBrowserV2.resources;

    public MessagePersister() {
    }

    public MessagePersister(Message value) {
        this.message = value;
    }

    public MessagePersister(LocalMessageContainer vlmc) {
        this.lmc = vlmc;
        this.message = vlmc.getMessage();
    }

    public final void setTextBuffer(StringBuilder sbuffer) {
        this.sbuf = sbuffer;
    }

    public final void zipUp(File workdirFile, File targetFile) {
        Zipper mm = new Zipper();
        try {
            File tempzip = new File(QBrowserUtil.getQBrowserTempFileDir() + System.currentTimeMillis());
            this.sbuf.append(resources.getString("qkey.msg.msg257") + " " + targetFile.getAbsolutePath() + "\n");
            mm.zipForDir(workdirFile, tempzip, false, ".zip");
            this.sbuf.append(resources.getString("qkey.msg.msg258") + " " + targetFile.getName() + "\n");
            if (targetFile.exists()) {
                targetFile.delete();
            }
            if (!tempzip.renameTo(targetFile)) {
                this.sbuf.append(resources.getString("qkey.msg.msg254"));
                tempzip.delete();
            }
            this.cleanupWorkDir(workdirFile);
            workdirFile.delete();
            return;
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
            return;
        }
    }

    public File persistToFile() throws Exception {
        Exception ex;
        Object object;
        MessagePersister messagePersister;
        if (this.lmc != null) {
            messagePersister = this;
            try {
                String string = messagePersister.lmc.getVmsgid();
                Property property = new Property();
                property.setKey("JMSMessageID");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                string = messagePersister.lmc.getVdest();
                string = string != null ? (string instanceof Queue ? ((Queue)string).getQueueName() + " : Queue" : ((Topic)string).getTopicName() + " : Topic") : "";
                property = new Property();
                property.setKey("JMSDestination");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                string = messagePersister.lmc.getVreplyto();
                string = string != null ? (string instanceof Queue ? ((Queue)string).getQueueName() + " : Queue" : ((Topic)string).getTopicName() + " : Topic") : "";
                property = new Property();
                property.setKey("JMSReplyTo");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                string = messagePersister.lmc.getVcorrelationid();
                property = new Property();
                property.setKey("JMSCorrelationID");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                int n = messagePersister.lmc.getVdeliverymode();
                property = new Property();
                property.setKey("JMSDeliverMode");
                property.setProperty_type("Int");
                property.setProperty_value(n);
                messagePersister.headers.add(property);
                n = messagePersister.lmc.getVpriority();
                property = new Property();
                property.setKey("JMSPriority");
                property.setProperty_type("Int");
                property.setProperty_value(n);
                messagePersister.headers.add(property);
                long l = messagePersister.lmc.getVexpiration();
                Object object2 = new Property();
                ((Property)object2).setKey("JMSExpiration");
                ((Property)object2).setProperty_type("Long");
                ((Property)object2).setProperty_value(l);
                messagePersister.headers.add(object2);
                object2 = messagePersister.lmc.getVjms_type();
                property = new Property();
                property.setKey("JMSType");
                property.setProperty_type("String");
                property.setProperty_value(object2);
                messagePersister.headers.add(property);
                boolean bl = messagePersister.lmc.isVredelivered();
                property = new Property();
                property.setKey("JMSRedelivered");
                property.setProperty_type("Boolean");
                property.setProperty_value(bl);
                messagePersister.headers.add(property);
                long l2 = messagePersister.lmc.getVtimestamp();
                object = new Property();
                ((Property)object).setKey("JMSTimestamp");
                ((Property)object).setProperty_type("Long");
                ((Property)object).setProperty_value(l2);
                messagePersister.headers.add(object);
                object = messagePersister.lmc.getAdditionalHeaders();
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    messagePersister.headers.add((Property)((ArrayList)object).get(i));
                }
            }
            catch (JMSException jMSException) {
                object = jMSException;
                jMSException.printStackTrace();
            }
        } else {
            messagePersister = this;
            try {
                String string = messagePersister.message.getJMSMessageID();
                Property property = new Property();
                property.setKey("JMSMessageID");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                string = messagePersister.message.getJMSDestination();
                string = string != null ? (string instanceof Queue ? ((Queue)string).getQueueName() + " : Queue" : ((Topic)string).getTopicName() + " : Topic") : "";
                property = new Property();
                property.setKey("JMSDestination");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                string = messagePersister.message.getJMSReplyTo();
                string = string != null ? (string instanceof Queue ? ((Queue)string).getQueueName() + " : Queue" : ((Topic)string).getTopicName() + " : Topic") : "";
                property = new Property();
                property.setKey("JMSReplyTo");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                string = messagePersister.message.getJMSCorrelationID();
                property = new Property();
                property.setKey("JMSCorrelationID");
                property.setProperty_type("String");
                property.setProperty_value(string);
                messagePersister.headers.add(property);
                int n = messagePersister.message.getJMSDeliveryMode();
                property = new Property();
                property.setKey("JMSDeliverMode");
                property.setProperty_type("Int");
                property.setProperty_value(n);
                messagePersister.headers.add(property);
                n = messagePersister.message.getJMSPriority();
                property = new Property();
                property.setKey("JMSPriority");
                property.setProperty_type("Int");
                property.setProperty_value(n);
                messagePersister.headers.add(property);
                long l = messagePersister.message.getJMSExpiration();
                Object object3 = new Property();
                ((Property)object3).setKey("JMSExpiration");
                ((Property)object3).setProperty_type("Long");
                ((Property)object3).setProperty_value(l);
                messagePersister.headers.add(object3);
                object3 = messagePersister.message.getJMSType();
                property = new Property();
                property.setKey("JMSType");
                property.setProperty_type("String");
                property.setProperty_value(object3);
                messagePersister.headers.add(property);
                boolean bl = messagePersister.message.getJMSRedelivered();
                property = new Property();
                property.setKey("JMSRedelivered");
                property.setProperty_type("Boolean");
                property.setProperty_value(bl);
                messagePersister.headers.add(property);
                long l3 = messagePersister.message.getJMSTimestamp();
                object = new Property();
                ((Property)object).setKey("JMSTimestamp");
                ((Property)object).setProperty_type("Long");
                ((Property)object).setProperty_value(l3);
                messagePersister.headers.add(object);
            }
            catch (JMSException jMSException) {
                object = jMSException;
                jMSException.printStackTrace();
            }
        }
        String workdir = QBrowserUtil.getQBrowserTempFileDir() + "JMS" + System.nanoTime() + File.separator;
        File workdirFile = new File(workdir);
        workdirFile.mkdirs();
        File target1 = new File(workdir + "JMSHeaders.txt");
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(target1));
            pwr.println(MessagePersister.propertiesToString(this.headers));
            pwr.close();
        }
        catch (Exception exception) {
            ex = exception;
            exception.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
            }
        }
        this.collectProperties();
        File target2 = new File(workdir + "UserProperties.txt");
        PrintWriter pwr2 = null;
        try {
            pwr2 = new PrintWriter(new FileWriter(target2));
            pwr2.println(MessagePersister.propertiesToString(this.properties));
            pwr2.close();
        }
        catch (Exception exception) {
            ex = exception;
            exception.printStackTrace();
        }
        finally {
            if (pwr2 != null) {
                pwr2.close();
            }
        }
        return workdirFile;
    }

    public final void cleanupWorkDir(File workdir) {
        if (workdir == null) {
            return;
        }
        File[] files = workdir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.cleanupWorkDir(files[i]);
                if (files[i].listFiles().length != 0) continue;
                files[i].delete();
                continue;
            }
            if (!files[i].isFile()) continue;
            try {
                files[i].delete();
                continue;
            }
            catch (Exception exception) {
                Exception ex = exception;
                exception.printStackTrace();
            }
        }
    }

    private static String propertiesToString(ArrayList props) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int i = 0; i < props.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n");
            }
            Property prop = (Property)props.get(i);
            sb.append("\"").append(prop.getKey()).append("\"");
            sb.append(",").append(prop.getProperty_type());
            sb.append("=");
            if (prop.getProperty_type().equals("String")) {
                sb.append("<@begin-@string@>").append(prop.getProperty_value()).append("<@end-@string@>");
                continue;
            }
            sb.append("\"").append(prop.getProperty_value()).append("\"");
        }
        return sb.toString();
    }

    private void collectProperties() {
        try {
            Enumeration enu = this.message.getPropertyNames();
            while (enu.hasMoreElements()) {
                String name = enu.nextElement().toString();
                Object propvalueobj = this.message.getObjectProperty(name);
                Property prop = new Property();
                prop.setKey(name);
                prop.setProperty_value(propvalueobj);
                prop.autoComplementTypeNme();
                this.properties.add(prop);
            }
            return;
        }
        catch (JMSException jMSException) {
            JMSException jmse = jMSException;
            jMSException.printStackTrace();
            return;
        }
    }

    /*
     * Loose catch block
     */
    final void stringPropertyToFile(File efile, String string_property) {
        block22: {
            FileOutputStream fo;
            ByteArrayInputStream bis;
            block20: {
                bis = null;
                fo = null;
                byte[] bibi = new byte[1024];
                if (!efile.getParentFile().exists()) {
                    efile.getParentFile().mkdirs();
                }
                bis = new ByteArrayInputStream(string_property.getBytes());
                fo = new FileOutputStream(efile);
                int len = 0;
                long readfilesize = 0L;
                int count = 0;
                while ((len = bis.read(bibi, 0, bibi.length)) != -1) {
                    fo.write(bibi, 0, len);
                    readfilesize += (long)len;
                    if (++count <= 100) continue;
                    this.sbuf.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + string_property.length() + " " + resources.getString("qkey.msg.msg099") + "\n");
                    count = 0;
                }
                if (count == 0) break block20;
                this.sbuf.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + string_property.length() + " " + resources.getString("qkey.msg.msg099") + "\n");
            }
            try {
                fo.close();
            }
            catch (IOException iOException) {}
            try {
                bis.close();
            }
            catch (IOException iOException) {
                return;
            }
            catch (Throwable throwable) {
                block21: {
                    try {
                        Throwable thex = throwable;
                        throwable.printStackTrace();
                        if (fo == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (fo != null) {
                            try {
                                fo.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable2;
                    }
                    try {
                        fo.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bis == null) break block22;
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
    }

    static void intPropertyToFile(File efile, Integer int_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(int_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void bytePropertyToFile(File efile, Byte byte_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(byte_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void shortPropertyToFile(File efile, Short short_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(short_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void longPropertyToFile(File efile, Long long_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(long_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void booleanPropertyToFile(File efile, Boolean boolean_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(boolean_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void floatPropertyToFile(File efile, Float float_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(float_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void charPropertyToFile(File efile, Character char_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(char_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    static void doublePropertyToFile(File efile, double double_property) {
        block6: {
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            PrintWriter pwr = null;
            try {
                pwr = new PrintWriter(new FileWriter(efile));
                pwr.print(double_property);
                pwr.close();
                return;
            }
            catch (Exception exception) {
                Serializable e = exception;
                exception.printStackTrace();
                return;
            }
            finally {
                if (pwr == null) break block6;
                pwr.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    final void bytesPropertyToFile(File efile, byte[] bytes_property) {
        block22: {
            FileOutputStream fo;
            ByteArrayInputStream bis;
            block20: {
                if (!efile.getParentFile().exists()) {
                    efile.getParentFile().mkdirs();
                }
                bis = null;
                fo = null;
                byte[] bibi = new byte[1024];
                bis = new ByteArrayInputStream(bytes_property);
                fo = new FileOutputStream(efile);
                int len = 0;
                long readfilesize = 0L;
                int count = 0;
                while ((len = bis.read(bibi, 0, bibi.length)) != -1) {
                    fo.write(bibi, 0, len);
                    readfilesize += (long)len;
                    if (++count <= 100) continue;
                    this.sbuf.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + bytes_property.length + " " + resources.getString("qkey.msg.msg099") + "\n");
                    count = 0;
                }
                if (count == 0) break block20;
                this.sbuf.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + bytes_property.length + " " + resources.getString("qkey.msg.msg099") + "\n");
            }
            try {
                fo.close();
            }
            catch (IOException iOException) {}
            try {
                bis.close();
            }
            catch (IOException iOException) {
                return;
            }
            catch (Exception exception) {
                block21: {
                    try {
                        Exception ex = exception;
                        exception.printStackTrace();
                        if (fo == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (fo != null) {
                            try {
                                fo.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        fo.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bis == null) break block22;
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
    }
}

