/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public final class JideCursors {
    private static final Cursor[] predefined = new Cursor[16];

    public static Cursor getPredefinedCursor(int n) {
        if (n < 20 || n > 35) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (predefined[n - 20] == null) {
            Cursor cursor;
            int n2 = n;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getBestCursorSize(32, 32);
            int n3 = toolkit.getMaximumCursorColors();
            switch (n2) {
                case 20: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.hsplit");
                        if (imageIcon == null) {
                            cursor = Cursor.getPredefinedCursor(11);
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Horizonal Split");
                        break;
                    }
                    cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 21: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.vsplit");
                        if (imageIcon == null) {
                            cursor = Cursor.getPredefinedCursor(9);
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Vertical Split");
                        break;
                    }
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 22: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.drag");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(17, 12), "Drag");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 23: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragStop");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(17, 12), "Drag Stop");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 33: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragText");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(0, 0), "Drag Text");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 34: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragTextStop");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Drag Text Stop");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 24: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.north");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 10), "North");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 25: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.south");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 20), "South");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 26: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.east");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(20, 15), "East");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 27: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.west");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(10, 15), "West");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 28: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.tab");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Tabbed");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 29: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.float");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Floating");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 30: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.vertical");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Vertical");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 31: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.horizontal");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Horizontal");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                case 32: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.delete");
                        if (imageIcon == null) {
                            cursor = Cursor.getDefaultCursor();
                            break;
                        }
                        cursor = toolkit.createCustomCursor(imageIcon.getImage(), new Point(10, 10), "Delete");
                        break;
                    }
                    cursor = Cursor.getDefaultCursor();
                    break;
                }
                default: {
                    cursor = null;
                }
            }
            JideCursors.predefined[n - 20] = cursor;
        }
        return predefined[n - 20];
    }

    static {
        for (int i = 20; i < 35; ++i) {
            JideCursors.getPredefinedCursor(i);
        }
    }
}

