/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class XertoUtils {
    private static Color BASE_COLOR;
    private static Color CONTROL_COLOR;
    private static Color LIGHT_CONTROL_COLOR;
    private static Color CONTROL_VERY_LIGHT_SHADOW_COLOR;
    private static Color CONTROL_LIGHT_SHADOW_COLOR;
    private static Color CONTROL_MID_SHADOW_COLOR;
    private static Color CONTROL_DARK_SHADOW_COLOR;
    private static Color SELECTED_TAB_BACKGROUND_COLOR;
    private static Color TAB_FORGROUND_COLOR;
    private static Color DARK_GREEN;
    private static Color DARK_MAGENTA;

    public static Color getControlColor() {
        return CONTROL_COLOR;
    }

    public static Color getLightControlColor() {
        return LIGHT_CONTROL_COLOR;
    }

    public static Color getSelectedTabBackgroundColor() {
        return SELECTED_TAB_BACKGROUND_COLOR;
    }

    public static Color getTabForgroundColor() {
        return TAB_FORGROUND_COLOR;
    }

    public static Color getControlVeryLightShadowColor() {
        return CONTROL_VERY_LIGHT_SHADOW_COLOR;
    }

    public static Color getControlLightShadowColor() {
        return CONTROL_LIGHT_SHADOW_COLOR;
    }

    public static Color getControlMidShadowColor() {
        return CONTROL_MID_SHADOW_COLOR;
    }

    public static Color getControlDarkShadowColor() {
        return CONTROL_DARK_SHADOW_COLOR;
    }

    public static Color getApplicationFrameBackgroundColor() {
        return CONTROL_COLOR;
    }

    public static Color getFrameBorderColor() {
        return UIDefaultsLookup.getColor("controlShadow");
    }

    public static Color getMenuSelectionColor(Color color) {
        int n = XertoUtils.getMenuSelectionValue(color.getRed());
        int n2 = XertoUtils.getMenuSelectionValue(color.getGreen());
        int n3 = XertoUtils.getMenuSelectionValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    private static int getMenuSelectionValue(int n) {
        return (int)((double)n * 76.0 / 255.0 + 179.5);
    }

    public static Color getMenuBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        int n = XertoUtils.getMenuValue(color.getRed());
        int n2 = XertoUtils.getMenuValue(color.getGreen());
        int n3 = XertoUtils.getMenuValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    private static int getMenuValue(int n) {
        return (int)((double)n * 36.0 / 255.0 + 219.5);
    }

    public static Color getToolBarBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        int n = XertoUtils.getToolBarValue(color.getRed());
        int n2 = XertoUtils.getToolBarValue(color.getGreen());
        int n3 = XertoUtils.getToolBarValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    private static int getToolBarValue(int n) {
        return n * 215 / 255 + 40;
    }

    public static Color getGripperForegroundColor(Color color) {
        int n = XertoUtils.getGripperValue(color.getRed());
        int n2 = XertoUtils.getGripperValue(color.getGreen());
        int n3 = XertoUtils.getGripperValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    private static int getGripperValue(int n) {
        if (n == 255) {
            return 0;
        }
        if (n >= 0 && n <= 64) {
            return n * 33 / 64 + 123;
        }
        return (n - 65) * 157 / 189 + 33;
    }

    public static Color getDefaultBackgroundColor(Color color) {
        if (color.getRed() == 212 && color.getGreen() == 208 && color.getBlue() == 200) {
            color = new Color(247, 243, 233);
        } else if (color.getRed() == 236 && color.getGreen() == 233 && color.getBlue() == 216) {
            color = new Color(255, 251, 233);
        } else {
            int n = color.getRed() + 35;
            int n2 = color.getGreen() + 35;
            int n3 = color.getBlue() + 35;
            if (n >= 255) {
                n = 255;
            }
            if (n2 >= 255) {
                n2 = 255;
            }
            if (n3 >= 255) {
                n3 = 255;
            }
            color = new Color(n, n2, n3);
        }
        return color;
    }

    private static int getLightColor(int n, double d) {
        return (int)((double)(255 - n) * d + (double)n);
    }

    private static Color getLighterColor(Color color, double d) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        int n = XertoUtils.getLightColor(color.getRed(), d);
        int n2 = XertoUtils.getLightColor(color.getGreen(), d) + 1;
        int n3 = XertoUtils.getLightColor(color.getBlue(), d);
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    public static Color getEmBaseColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        fArray[1] = fArray[1] + 0.1f;
        if (fArray[1] > 1.0f) {
            fArray[1] = 1.0f;
        }
        fArray[2] = fArray[2] - 0.1f;
        if (fArray[2] < 0.0f) {
            fArray[2] = 0.0f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    public static Color getTextColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        if ((double)fArray[2] > 0.53) {
            return UIDefaultsLookup.getColor("controlText");
        }
        return Color.WHITE;
    }

    public static Color getSelectedAndFocusedButtonColor(Color color) {
        return XertoUtils.getLighterColor(color, 0.67);
    }

    public static Color getFocusedButtonColor(Color color) {
        return XertoUtils.getLighterColor(color, 0.78);
    }

    public static Color getSelectedButtonColor(Color color) {
        return XertoUtils.getLighterColor(color, 0.86);
    }

    static {
        Object object = UIManager.getDefaults();
        BASE_COLOR = ((UIDefaults)object).getColor("activeCaption");
        CONTROL_COLOR = ((UIDefaults)object).getColor("control");
        ((UIDefaults)object).getColor("inactiveCaption");
        LIGHT_CONTROL_COLOR = ((UIDefaults)object).getColor("MenuItem.background");
        object = Color.RGBtoHSB(CONTROL_COLOR.getRed(), CONTROL_COLOR.getGreen(), CONTROL_COLOR.getBlue(), null);
        float[] fArray = Color.RGBtoHSB(BASE_COLOR.getRed(), BASE_COLOR.getGreen(), BASE_COLOR.getBlue(), null);
        Color.getHSBColor((float)object[0], Math.max((float)(object[1] - 0.05f), 0.0f), object[2] < 0.95f ? (float)(object[2] + 0.05f) : 0.98f);
        SELECTED_TAB_BACKGROUND_COLOR = Color.getHSBColor((float)object[0], (float)object[1], object[1] == 0.0f ? 0.75f : 0.85f);
        TAB_FORGROUND_COLOR = Color.getHSBColor((float)object[0], (double)object[1] > 0.01 ? 0.45f : (float)object[0], 0.2f);
        CONTROL_VERY_LIGHT_SHADOW_COLOR = Color.getHSBColor((float)object[0], (float)object[1], (float)(object[2] - 0.02f));
        CONTROL_LIGHT_SHADOW_COLOR = Color.getHSBColor((float)object[0], (float)object[1], (float)(object[2] - 0.06f));
        CONTROL_MID_SHADOW_COLOR = Color.getHSBColor((float)object[0], (float)object[1], (float)(object[2] - 0.16f));
        CONTROL_DARK_SHADOW_COLOR = Color.getHSBColor((float)object[0], (float)object[1], (float)(object[2] - 0.32f));
        Color.getHSBColor(fArray[0], (double)fArray[1] > 0.01 ? 0.45f : fArray[0], 0.8f);
        Color.getHSBColor(fArray[0], (double)fArray[1] > 0.01 ? 0.3f : fArray[0], 0.9f);
        Color.getHSBColor(fArray[0], (double)fArray[1] > 0.01 ? 0.45f : fArray[0], 0.7f);
        Color.getHSBColor((float)object[0], (float)object[1], 0.75f);
        Color.getHSBColor((float)object[0], (float)object[1], 0.5f);
        DARK_GREEN = new Color(0, 128, 0);
        DARK_MAGENTA = new Color(128, 0, 128);
    }
}

