/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.swing.JideSplitPaneDivider;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

final class VsnetUtils {
    private static Color DARK_GREEN = new Color(0, 128, 0);
    private static Color DARK_MAGENTA = new Color(128, 0, 128);
    private static double RATIO1 = 0.8;
    private static double RATIO2 = 0.92f;
    private static double RATIO3 = 0.86f;

    VsnetUtils() {
    }

    static Color getLighterColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return JideSplitPaneDivider.DragController.getDerivedColor(color, 0.93f);
    }

    static Color getMenuSelectionColor(Color color) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        return JideSplitPaneDivider.DragController.getDerivedColor(color, 0.8555f);
    }

    static Color getMenuBackgroundColor(Color color) {
        return VsnetUtils.getLighterColor(color);
    }

    static Color getToolBarBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return JideSplitPaneDivider.DragController.getDerivedColor(color, 0.645f);
    }

    static Color getGripperForegroundColor(Color color) {
        int n = VsnetUtils.getGripperValue(color.getRed());
        int n2 = VsnetUtils.getGripperValue(color.getGreen());
        int n3 = VsnetUtils.getGripperValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new ColorUIResource(n, n2, n3);
    }

    private static int getGripperValue(int n) {
        if (n == 255) {
            return 0;
        }
        if (n >= 0 && n <= 64) {
            return n * 33 / 64 + 123;
        }
        return (n - 65) * 157 / 189 + 33;
    }

    static Color getDefaultBackgroundColor(Color color) {
        if (color.getRed() == 212 && color.getGreen() == 208 && color.getBlue() == 200) {
            color = new ColorUIResource(247, 243, 233);
        } else if (color.getRed() == 236 && color.getGreen() == 233 && color.getBlue() == 216) {
            color = new ColorUIResource(255, 251, 233);
        } else {
            int n = color.getRed() + 35;
            int n2 = color.getGreen() + 35;
            int n3 = color.getBlue() + 35;
            if (n >= 255) {
                n = 255;
            }
            if (n2 >= 255) {
                n2 = 255;
            }
            if (n3 >= 255) {
                n3 = 255;
            }
            color = new ColorUIResource(n, n2, n3);
        }
        return color;
    }

    static Color getLighterColor(Color color, float f) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        return JideSplitPaneDivider.DragController.getDerivedColor(color, f);
    }

    static Color getSelectedAndRolloverButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO1);
    }

    static Color getRolloverButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO2);
    }

    static Color getSelectedButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO3);
    }

    static Color getButtonBorderColor(Color color) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return new ColorUIResource(Color.WHITE);
        }
        return color;
    }
}

