/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class VsnetMetalProgressBarUI
extends MetalProgressBarUI
implements ActionListener {
    private int repaintInterval;
    private int x = 0;
    private int delta = 1;
    private Timer timer = null;
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new VsnetMetalProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        VsnetMetalProgressBarUI vsnetMetalProgressBarUI = this;
        this.repaintInterval = UIDefaultsLookup.getInt("ProgressBar.repaintInterval");
        int cfr_ignored_0 = vsnetMetalProgressBarUI.repaintInterval;
    }

    protected void startAnimationTimer() {
        if (this.timer == null) {
            VsnetMetalProgressBarUI vsnetMetalProgressBarUI = this;
            this.timer = new Timer(vsnetMetalProgressBarUI.repaintInterval / 20, this);
        }
        this.x = 0;
        this.delta = 1;
        this.timer.start();
    }

    protected void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.x == 0) {
            this.delta = 1;
        } else if (this.x == this.progressBar.getWidth()) {
            this.delta = -1;
        }
        this.x += this.delta;
        this.progressBar.repaint();
    }

    public void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        boolean bl;
        super.paintDeterminate(graphics, jComponent);
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Color color = this.progressBar.getForeground();
        Color color2 = VsnetUtils.getLighterColor(color, 0.9f);
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        graphics = (Graphics2D)graphics;
        boolean bl2 = bl = jComponent.getHeight() > jComponent.getWidth();
        if (this.delta > 0) {
            this.boxRect = new Rectangle(0, 0, this.x, this.progressBar.getHeight() - 1);
            JideSwingUtilities.fillNormalGradient((Graphics2D)graphics, this.boxRect, color2, color, bl);
        } else {
            this.boxRect = new Rectangle(this.x, 0, this.progressBar.getWidth() - this.x, this.progressBar.getHeight() - 1);
            JideSwingUtilities.fillNormalGradient((Graphics2D)graphics, this.boxRect, color, color2, bl);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString$2ec8738a(graphics, insets.left, insets.top, n, n2, this.boxRect.x, this.boxRect.width);
                return;
            }
            this.paintString$2ec8738a(graphics, insets.left, insets.top, n, n2, this.boxRect.y, this.boxRect.height);
        }
    }

    private void paintString$2ec8738a(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        graphics = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics.setFont(this.progressBar.getFont());
        Cloneable cloneable = this.getStringPlacement(graphics, string, n, n2, n3, n4);
        Rectangle rectangle = graphics.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics.setColor(this.getSelectionBackground());
            JideSwingUtilities.drawString(this.progressBar, graphics, string, cloneable.x, cloneable.y);
            graphics.setColor(this.getSelectionForeground());
            graphics.clipRect(n5, n2, n6, n4);
            JideSwingUtilities.drawString(this.progressBar, graphics, string, cloneable.x, cloneable.y);
        } else {
            graphics.setColor(this.getSelectionBackground());
            cloneable = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics.setFont(this.progressBar.getFont().deriveFont((AffineTransform)cloneable));
            cloneable = this.getStringPlacement(graphics, string, n, n2, n3, n4);
            JideSwingUtilities.drawString(this.progressBar, graphics, string, cloneable.x, cloneable.y);
            graphics.setColor(this.getSelectionForeground());
            graphics.clipRect(n, n5, n3, n6);
            JideSwingUtilities.drawString(this.progressBar, graphics, string, cloneable.x, cloneable.y);
        }
        graphics.setClip(rectangle);
    }

    public static void main(String[] object) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        object = new JProgressBar();
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setUI(new VsnetMetalProgressBarUI());
        ((JProgressBar)object).setIndeterminate(true);
        ((JProgressBar)object).setString("Percent");
        ((JProgressBar)object).setStringPainted(true);
        jProgressBar.setIndeterminate(true);
        jProgressBar.setString("Percent");
        jProgressBar.setStringPainted(true);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)object, "North");
        jPanel.add((Component)jProgressBar, "South");
        JOptionPane.showMessageDialog(null, jPanel, "ProgressBars made intutive - santhosh@in.fiorano.com", 1);
        System.exit(0);
    }
}

