/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class MetalMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    private Color selectionBackground;
    protected Color selectionForeground;
    private Color disabledForeground;
    private Color acceleratorForeground;
    private Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    private Font acceleratorFont;
    private MouseInputListener mouseInputListener;
    private MenuDragMouseListener menuDragMouseListener;
    private MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    private Icon arrowIcon = null;
    private Icon checkIcon = null;
    private boolean oldBorderPainted;
    InputMap windowInputMap;
    private ThemePainter _painter;
    private static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle acceleratorRect = new Rectangle();
    private static Rectangle checkIconRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalMenuItemUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuItem = (JMenuItem)jComponent;
        this.installDefaults();
        jComponent = this.menuItem;
        BasicHTML.updateRenderer(jComponent, ((AbstractButton)jComponent).getText());
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        String string = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(string + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, string + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIDefaultsLookup.get(string + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, string + ".background", string + ".foreground", string + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(string + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(string + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(string + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(string + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(string + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(string + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(string + ".checkIcon");
        }
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        MetalMenuItemUI metalMenuItemUI;
        this.mouseInputListener = this.createMouseInputListener$3921fa06();
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener$546f662f()) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener$65e00b43()) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = new PropertyChangeHandler(metalMenuItemUI = this)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent container) {
        this.menuItem = (JMenuItem)container;
        this.uninstallDefaults();
        container = this.menuItem;
        BasicHTML.updateRenderer((JComponent)container, "");
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        container = this.menuItem.getParent();
        if (!(container == null || !(container instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            ((JComponent)container).putClientProperty("maxAccWidth", null);
            ((JComponent)container).putClientProperty("maxTextWidth", null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        this._painter = null;
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener$3921fa06() {
        return new MouseInputHandler(this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener$546f662f() {
        return new MenuDragMouseHandler(this);
    }

    protected MenuKeyListener createMenuKeyListener$65e00b43() {
        return new MenuKeyHandler(this);
    }

    ActionMap getActionMap() {
        String string = this.getPropertyPrefix();
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get(string = string + ".actionMap");
        if (actionMap == null) {
            actionMap = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("doClick", new ClickAction());
        return actionMapUIResource;
    }

    final InputMap createInputMap(int n) {
        return new ComponentInputMapUIResource(this.menuItem);
    }

    final void updateAcceleratorBinding() {
        KeyStroke keyStroke = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (keyStroke != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(keyStroke, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent object) {
        int n = this.defaultTextIconGap;
        Object object2 = this.arrowIcon;
        Object object3 = this.checkIcon;
        JComponent jComponent = object;
        object = this;
        jComponent = (JMenuItem)jComponent;
        Object object4 = ((AbstractButton)jComponent).getIcon();
        String string = ((AbstractButton)jComponent).getText();
        Serializable serializable = ((JMenuItem)jComponent).getAccelerator();
        String string2 = "";
        if (serializable != null) {
            int n2 = ((AWTKeyStroke)serializable).getModifiers();
            if (n2 > 0) {
                string2 = KeyEvent.getKeyModifiersText(n2);
                string2 = string2 + ((MetalMenuItemUI)object).acceleratorDelimiter;
            }
            string2 = (n2 = ((AWTKeyStroke)serializable).getKeyCode()) != 0 ? string2 + KeyEvent.getKeyText(n2) : string2 + ((AWTKeyStroke)serializable).getKeyChar();
        }
        Serializable serializable2 = jComponent.getFont();
        serializable2 = jComponent.getFontMetrics((Font)serializable2);
        serializable = jComponent.getFontMetrics(((MetalMenuItemUI)object).acceleratorFont);
        MetalMenuItemUI.resetRects();
        super.layoutMenuItem((FontMetrics)serializable2, string, (FontMetrics)serializable, string2, (Icon)object4, (Icon)object3, (Icon)object2, ((AbstractButton)jComponent).getVerticalAlignment(), ((AbstractButton)jComponent).getHorizontalAlignment(), ((AbstractButton)jComponent).getVerticalTextPosition(), ((AbstractButton)jComponent).getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, string == null ? 0 : n, n);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(MetalMenuItemUI.iconRect.x, MetalMenuItemUI.iconRect.y, MetalMenuItemUI.iconRect.width, MetalMenuItemUI.iconRect.height, r);
        object3 = ((MetalMenuItemUI)object).menuItem.getParent();
        if (!(object3 == null || !(object3 instanceof JComponent) || ((MetalMenuItemUI)object).menuItem instanceof JMenu && ((JMenu)((MetalMenuItemUI)object).menuItem).isTopLevelMenu())) {
            int n3;
            object3 = (JComponent)object3;
            object2 = (Integer)((JComponent)object3).getClientProperty("maxTextWidth");
            object4 = (Integer)((JComponent)object3).getClientProperty("maxAccWidth");
            int n4 = object2 != null ? (Integer)object2 : 0;
            int n5 = n3 = object4 != null ? (Integer)object4 : 0;
            if (MetalMenuItemUI.r.width < n4) {
                MetalMenuItemUI.r.width = n4;
            } else {
                ((JComponent)object3).putClientProperty("maxTextWidth", MetalMenuItemUI.r.width);
            }
            if (MetalMenuItemUI.acceleratorRect.width > n3) {
                n3 = MetalMenuItemUI.acceleratorRect.width;
                ((JComponent)object3).putClientProperty("maxAccWidth", MetalMenuItemUI.acceleratorRect.width);
            }
            MetalMenuItemUI.r.width += n3;
            MetalMenuItemUI.r.width += n;
        }
        if (super.useCheckAndArrow()) {
            MetalMenuItemUI.r.width += MetalMenuItemUI.checkIconRect.width;
            MetalMenuItemUI.r.width += n;
            MetalMenuItemUI.r.width += n;
            MetalMenuItemUI.r.width += MetalMenuItemUI.arrowIconRect.width;
        }
        MetalMenuItemUI.r.width += n * 2;
        object3 = jComponent.getInsets();
        if (object3 != null) {
            MetalMenuItemUI.r.width += ((Insets)object3).left + ((Insets)object3).right;
            MetalMenuItemUI.r.height += ((Insets)object3).top + ((Insets)object3).bottom;
        }
        if (MetalMenuItemUI.r.width % 2 == 0) {
            ++MetalMenuItemUI.r.width;
        }
        if (MetalMenuItemUI.r.height % 2 == 0) {
            ++MetalMenuItemUI.r.height;
        }
        if (JideSwingUtilities.getOrientationOf(((MetalMenuItemUI)object).menuItem) == 0) {
            return r.getSize();
        }
        return new Dimension(MetalMenuItemUI.r.height, MetalMenuItemUI.r.width);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension = this.getPreferredSize(jComponent);
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    private static void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics object, JComponent object2) {
        Color color;
        Font font;
        ButtonModel buttonModel;
        JComponent jComponent;
        Icon icon;
        Color color2;
        block22: {
            int n;
            String string;
            Object object3;
            block25: {
                block23: {
                    JMenuItem jMenuItem;
                    block24: {
                        int n2;
                        int n3;
                        int n4 = this.defaultTextIconGap;
                        color2 = this.selectionForeground;
                        Serializable serializable = this.selectionBackground;
                        icon = this.arrowIcon;
                        Object object4 = this.checkIcon;
                        jComponent = object2;
                        object2 = object;
                        object = this;
                        jMenuItem = (JMenuItem)jComponent;
                        buttonModel = jMenuItem.getModel();
                        if (JideSwingUtilities.getOrientationOf(((MetalMenuItemUI)object).menuItem) == 0) {
                            n3 = jMenuItem.getWidth();
                            n2 = jMenuItem.getHeight();
                        } else {
                            n3 = jMenuItem.getHeight();
                            n2 = jMenuItem.getWidth();
                            object3 = (Graphics2D)object2;
                            ((Graphics2D)object3).getTransform();
                            ((Graphics2D)object3).rotate(1.5707963267948966);
                            ((Graphics2D)object3).translate(0, -n2 + 1);
                        }
                        object3 = jComponent.getInsets();
                        MetalMenuItemUI.resetRects();
                        viewRect.setBounds(0, 0, n3, n2);
                        MetalMenuItemUI.viewRect.x += ((Insets)object3).left;
                        MetalMenuItemUI.viewRect.y += ((Insets)object3).top;
                        MetalMenuItemUI.viewRect.width -= ((Insets)object3).right + MetalMenuItemUI.viewRect.x;
                        MetalMenuItemUI.viewRect.height -= ((Insets)object3).bottom + MetalMenuItemUI.viewRect.y;
                        font = ((Graphics)object2).getFont();
                        Serializable serializable2 = jComponent.getFont();
                        ((Graphics)object2).setFont((Font)serializable2);
                        serializable2 = ((Graphics)object2).getFontMetrics((Font)serializable2);
                        object3 = ((Graphics)object2).getFontMetrics(((MetalMenuItemUI)object).acceleratorFont);
                        KeyStroke keyStroke = jMenuItem.getAccelerator();
                        string = "";
                        if (keyStroke != null) {
                            int n5;
                            int n6 = keyStroke.getModifiers();
                            if (n6 > 0) {
                                string = KeyEvent.getKeyModifiersText(n6);
                                string = string + ((MetalMenuItemUI)object).acceleratorDelimiter;
                            }
                            string = (n5 = keyStroke.getKeyCode()) != 0 ? string + KeyEvent.getKeyText(n5) : string + keyStroke.getKeyChar();
                        }
                        String string2 = super.layoutMenuItem((FontMetrics)serializable2, jMenuItem.getText(), (FontMetrics)object3, string, jMenuItem.getIcon(), (Icon)object4, icon, jMenuItem.getVerticalAlignment(), jMenuItem.getHorizontalAlignment(), jMenuItem.getVerticalTextPosition(), jMenuItem.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, jMenuItem.getText() == null ? 0 : n4, n4);
                        ((MetalMenuItemUI)object).paintBackground((Graphics)object2, jMenuItem, (Color)serializable);
                        color = ((Graphics)object2).getColor();
                        if (object4 != null) {
                            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                                ((Graphics)object2).setColor(color2);
                            } else {
                                ((Graphics)object2).setColor(color);
                            }
                            if (super.useCheckAndArrow()) {
                                object4.paintIcon(jComponent, (Graphics)object2, MetalMenuItemUI.checkIconRect.x, MetalMenuItemUI.checkIconRect.y);
                            }
                            ((Graphics)object2).setColor(color);
                        }
                        if (jMenuItem.getIcon() != null) {
                            if (!buttonModel.isEnabled()) {
                                object4 = jMenuItem.getDisabledIcon();
                            } else if (!buttonModel.isPressed() || !buttonModel.isArmed() || (object4 = jMenuItem.getPressedIcon()) == null) {
                                object4 = jMenuItem.getIcon();
                            }
                            if (object4 != null) {
                                object4.paintIcon(jComponent, (Graphics)object2, MetalMenuItemUI.iconRect.x, MetalMenuItemUI.iconRect.y);
                            }
                        }
                        if (string2 != null) {
                            object4 = (View)jComponent.getClientProperty("html");
                            if (object4 != null) {
                                ((View)object4).paint((Graphics)object2, textRect);
                            } else {
                                ((MetalMenuItemUI)object).paintText((Graphics)object2, jMenuItem, textRect, string2);
                            }
                        }
                        if (string == null || string.equals("")) break block22;
                        n = 0;
                        serializable = ((MetalMenuItemUI)object).menuItem.getParent();
                        if (serializable != null && serializable instanceof JComponent) {
                            Serializable serializable3 = (JComponent)serializable;
                            n = (serializable3 = (Integer)((JComponent)serializable3).getClientProperty("maxAccWidth")) != null ? (Integer)serializable3 : MetalMenuItemUI.acceleratorRect.width;
                            n = n - MetalMenuItemUI.acceleratorRect.width;
                        }
                        ((Graphics)object2).setFont(((MetalMenuItemUI)object).acceleratorFont);
                        if (buttonModel.isEnabled()) break block23;
                        if (((MetalMenuItemUI)object).disabledForeground == null) break block24;
                        ((Graphics)object2).setColor(((MetalMenuItemUI)object).disabledForeground);
                        break block25;
                    }
                    ((Graphics)object2).setColor(jMenuItem.getBackground().brighter());
                    JideSwingUtilities.drawString(((MetalMenuItemUI)object).menuItem, (Graphics)object2, string, MetalMenuItemUI.acceleratorRect.x - n, MetalMenuItemUI.acceleratorRect.y + ((FontMetrics)object3).getAscent());
                    ((Graphics)object2).setColor(jMenuItem.getBackground().darker());
                    JideSwingUtilities.drawString(((MetalMenuItemUI)object).menuItem, (Graphics)object2, string, MetalMenuItemUI.acceleratorRect.x - n - 1, MetalMenuItemUI.acceleratorRect.y + ((FontMetrics)object3).getAscent() - 1);
                    break block22;
                }
                if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                    ((Graphics)object2).setColor(((MetalMenuItemUI)object).acceleratorSelectionForeground);
                } else {
                    ((Graphics)object2).setColor(((MetalMenuItemUI)object).acceleratorForeground);
                }
            }
            JideSwingUtilities.drawString(((MetalMenuItemUI)object).menuItem, (Graphics)object2, string, MetalMenuItemUI.acceleratorRect.x - n, MetalMenuItemUI.acceleratorRect.y + ((FontMetrics)object3).getAscent());
        }
        if (icon != null) {
            if (buttonModel.isArmed() || jComponent instanceof JMenu && buttonModel.isSelected()) {
                ((Graphics)object2).setColor(color2);
            }
            if (super.useCheckAndArrow()) {
                icon.paintIcon(jComponent, (Graphics)object2, MetalMenuItemUI.arrowIconRect.x, MetalMenuItemUI.arrowIconRect.y);
            }
        }
        ((Graphics)object2).setColor(color);
        ((Graphics)object2).setFont(font);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = jMenuItem.getDisplayedMnemonicIndex();
        if (!buttonModel.isEnabled()) {
            if (!(UIDefaultsLookup.get("MenuItem.disabledForeground") instanceof Color)) {
                graphics.setColor(jMenuItem.getBackground().brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
                return;
            }
            graphics.setColor(UIDefaultsLookup.getColor("MenuItem.disabledForeground"));
        } else if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(this.selectionForeground);
        }
        JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    private String layoutMenuItem(FontMetrics object, String object2, FontMetrics fontMetrics, String string, Icon icon, Icon icon2, Icon icon3, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, Rectangle rectangle6, int n5, int n6) {
        if (icon != null && (icon.getIconHeight() == 0 || icon.getIconWidth() == 0)) {
            icon = null;
        }
        rectangle.width -= this.getRightMargin();
        object = SwingUtilities.layoutCompoundLabel(this.menuItem, (FontMetrics)object, (String)object2, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
        if (this.getRightMargin() > 0) {
            object2 = object;
        }
        rectangle.width += this.getRightMargin();
        if (string == null || string.equals("")) {
            rectangle4.height = 0;
            rectangle4.width = 0;
        } else {
            rectangle4.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            rectangle4.height = fontMetrics.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (icon2 != null) {
                rectangle5.width = icon2.getIconWidth();
                rectangle5.height = icon2.getIconHeight();
            } else {
                rectangle5.height = 0;
                rectangle5.width = 0;
            }
            if (icon3 != null) {
                rectangle6.width = icon3.getIconWidth();
                rectangle6.height = icon3.getIconHeight();
            } else {
                rectangle6.height = 0;
                rectangle6.width = 0;
            }
        }
        object = rectangle2.union(rectangle3);
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (this.getRightMargin() == 0) {
                rectangle3.x += n6;
                rectangle2.x += n6;
            }
            rectangle4.x = rectangle.x + rectangle.width - rectangle6.width - n6 - rectangle4.width;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + n6;
                rectangle3.x += n6 + rectangle5.width;
                rectangle2.x += n6 + rectangle5.width;
                rectangle6.x = rectangle.x + rectangle.width - n6 - rectangle6.width;
            }
        } else {
            if (this.getRightMargin() == 0) {
                rectangle3.x -= n6;
                rectangle2.x -= n6;
            }
            rectangle4.x = rectangle.x + rectangle6.width + n6;
            if (this.useCheckAndArrow()) {
                rectangle5.x = rectangle.x + rectangle.width - n6 - rectangle5.width;
                rectangle3.x -= n6 + rectangle5.width;
                rectangle2.x -= n6 + rectangle5.width;
                rectangle6.x = rectangle.x + n6;
            }
        }
        rectangle4.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle4.height / 2;
        if (this.useCheckAndArrow()) {
            rectangle6.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle6.height / 2;
            rectangle5.y = ((Rectangle)object).y + ((Rectangle)object).height / 2 - rectangle5.height / 2;
        }
        return object2;
    }

    private boolean useCheckAndArrow() {
        boolean bl = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            bl = false;
        }
        return bl;
    }

    public final MenuElement[] getPath() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager();
        int n = (menuElementArray = menuElementArray.getSelectedPath()).length;
        if (n == 0) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray2 = this.menuItem.getParent();
        if (menuElementArray[n - 1].getComponent() == menuElementArray2) {
            menuElementArray2 = new MenuElement[n + 1];
            System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n);
            menuElementArray2[n] = this.menuItem;
        } else {
            for (n = menuElementArray.length - 1; n >= 0 && menuElementArray[n].getComponent() != menuElementArray2; --n) {
            }
            menuElementArray2 = new MenuElement[n + 2];
            System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n + 1);
            menuElementArray2[n + 1] = this.menuItem;
        }
        return menuElementArray2;
    }

    protected final void doClick(MenuSelectionManager menuSelectionManager) {
        if (menuSelectionManager == null) {
            menuSelectionManager = MenuSelectionManager.defaultManager();
        }
        menuSelectionManager.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    public final ThemePainter getPainter() {
        return this._painter;
    }

    protected static boolean isDownArrowVisible(Container container) {
        if (container instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return false;
        }
        if (container instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)container)).isMenuBar()) {
            return true;
        }
        return !(container instanceof JMenuBar);
    }

    protected int getRightMargin() {
        return 0;
    }

    static final class ClickAction
    extends AbstractAction {
        private ClickAction(byte by) {
        }

        public final void actionPerformed(ActionEvent serializable) {
            serializable = (JMenuItem)((EventObject)serializable).getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ((AbstractButton)serializable).doClick();
        }

        /* synthetic */ ClickAction() {
            this(0);
        }
    }

    final class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ MetalMenuItemUI this$0;

        private PropertyChangeHandler(MetalMenuItemUI metalMenuItemUI, byte by) {
            this.this$0 = metalMenuItemUI;
        }

        public final void propertyChange(PropertyChangeEvent serializable) {
            String string = serializable.getPropertyName();
            if (string.equals("labelFor") || string.equals("displayedMnemonic") || string.equals("accelerator")) {
                this.this$0.updateAcceleratorBinding();
                return;
            }
            if (string.equals("text") || "font".equals(string) || "foreground".equals(string)) {
                serializable = (JMenuItem)serializable.getSource();
                string = ((AbstractButton)serializable).getText();
                BasicHTML.updateRenderer((JComponent)serializable, string);
            }
        }

        /* synthetic */ PropertyChangeHandler(MetalMenuItemUI metalMenuItemUI) {
            this(metalMenuItemUI, 0);
        }
    }

    final class MenuKeyHandler
    implements MenuKeyListener {
        private /* synthetic */ MetalMenuItemUI this$0;

        private MenuKeyHandler(MetalMenuItemUI metalMenuItemUI, byte by) {
            this.this$0 = metalMenuItemUI;
        }

        public final void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (this.this$0.menuItem != null && this.this$0.menuItem.isEnabled()) {
                int n = this.this$0.menuItem.getMnemonic();
                if (n == 0 || menuKeyEvent.getPath().length != 2) {
                    return;
                }
                char c = (char)n;
                n = c;
                char c2 = menuKeyEvent.getKeyChar();
                n = c2;
                if (Character.toLowerCase(c) == Character.toLowerCase(c2)) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    this.this$0.doClick(menuSelectionManager);
                    menuKeyEvent.consume();
                }
            }
        }

        public final void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public final void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        /* synthetic */ MenuKeyHandler(MetalMenuItemUI metalMenuItemUI) {
            this(metalMenuItemUI, 0);
        }
    }

    final class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private /* synthetic */ MetalMenuItemUI this$0;

        private MenuDragMouseHandler(MetalMenuItemUI metalMenuItemUI, byte by) {
            this.this$0 = metalMenuItemUI;
        }

        public final void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public final void menuDragMouseDragged(MenuDragMouseEvent menuElementArray) {
            if (this.this$0.menuItem != null && this.this$0.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = menuElementArray.getMenuSelectionManager();
                menuElementArray = menuElementArray.getPath();
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }

        public final void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public final void menuDragMouseReleased(MenuDragMouseEvent serializable) {
            if (this.this$0.menuItem != null && this.this$0.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = serializable.getMenuSelectionManager();
                serializable = serializable.getPoint();
                if (((Point)serializable).x >= 0 && ((Point)serializable).x < this.this$0.menuItem.getWidth() && ((Point)serializable).y >= 0 && ((Point)serializable).y < this.this$0.menuItem.getHeight()) {
                    this.this$0.doClick(menuSelectionManager);
                    return;
                }
                menuSelectionManager.clearSelectedPath();
            }
        }

        /* synthetic */ MenuDragMouseHandler(MetalMenuItemUI metalMenuItemUI) {
            this(metalMenuItemUI, 0);
        }
    }

    public final class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ MetalMenuItemUI this$0;

        protected MouseInputHandler(MetalMenuItemUI metalMenuItemUI) {
            this.this$0 = metalMenuItemUI;
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
        }

        public final void mousePressed(MouseEvent mouseEvent) {
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.this$0.menuItem != null && this.this$0.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                Point point = mouseEvent.getPoint();
                if (point.x >= 0 && point.x < this.this$0.menuItem.getWidth() && point.y >= 0 && point.y < this.this$0.menuItem.getHeight()) {
                    this.this$0.doClick(menuSelectionManager);
                    return;
                }
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            if (this.this$0.menuItem != null && this.this$0.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = mouseEvent.getModifiers();
                if ((n & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                    return;
                }
                menuSelectionManager.setSelectedPath(this.this$0.getPath());
            }
        }

        public final void mouseExited(MouseEvent menuElementArray) {
            if (this.this$0.menuItem != null && this.this$0.menuItem.isEnabled()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                int n = menuElementArray.getModifiers();
                if ((n & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent((MouseEvent)menuElementArray);
                    return;
                }
                menuElementArray = menuSelectionManager.getSelectedPath();
                if (menuElementArray.length > 1) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    int n2 = menuElementArray.length - 1;
                    for (int i = 0; i < n2; ++i) {
                        menuElementArray2[i] = menuElementArray[i];
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                }
            }
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public final void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

