/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalBumps;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

final class BumpBuffer {
    private static Dimension imageSize = new Dimension(64, 64);
    private transient Image image;
    private Color topColor;
    private Color shadowColor;
    private Color backColor;
    private GraphicsConfiguration gc;

    public BumpBuffer(GraphicsConfiguration object, Color object2, Color color, Color color2) {
        this.gc = object;
        this.topColor = object2;
        this.shadowColor = color;
        this.backColor = color2;
        object = this;
        if (((BumpBuffer)object).gc != null) {
            ((BumpBuffer)object).image = ((BumpBuffer)object).gc.createCompatibleImage(64, 64, ((BumpBuffer)object).backColor != MetalBumps.ALPHA ? 1 : 2);
        } else {
            object2 = new int[]{((BumpBuffer)object).backColor.getRGB(), ((BumpBuffer)object).topColor.getRGB(), ((BumpBuffer)object).shadowColor.getRGB()};
            object2 = new IndexColorModel(8, 3, (int[])object2, 0, false, ((BumpBuffer)object).backColor == MetalBumps.ALPHA ? 0 : -1, 0);
            ((BumpBuffer)object).image = new BufferedImage(64, 64, 13, (IndexColorModel)object2);
        }
        this.fillBumpBuffer();
    }

    public final boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.gc != null ? !this.gc.equals(graphicsConfiguration) : graphicsConfiguration != null) {
            return false;
        }
        if (this.backColor != null ? !this.backColor.equals(color3) : color3 != null) {
            return false;
        }
        if (this.shadowColor != null ? !this.shadowColor.equals(color2) : color2 != null) {
            return false;
        }
        return !(this.topColor != null ? !this.topColor.equals(color) : color != null);
    }

    public final Image getImage() {
        return this.image;
    }

    public static Dimension getImageSize() {
        return imageSize;
    }

    private void fillBumpBuffer() {
        int n;
        int n2;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(this.topColor);
        for (n2 = 0; n2 < 64; n2 += 4) {
            for (n = 0; n < 64; n += 4) {
                graphics.drawLine(n2, n, n2, n);
                graphics.drawLine(n2 + 2, n + 2, n2 + 2, n + 2);
            }
        }
        graphics.setColor(this.shadowColor);
        for (n2 = 0; n2 < 64; n2 += 4) {
            for (n = 0; n < 64; n += 4) {
                graphics.drawLine(n2 + 1, n + 1, n2 + 1, n + 1);
                graphics.drawLine(n2 + 3, n + 3, n2 + 3, n + 3);
            }
        }
        graphics.dispose();
    }
}

