/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.HeaderBoxUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.HeaderBox;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;

public class BasicHeaderBoxUI
extends HeaderBoxUI {
    private static HeaderBoxUI _headerBoxUI;
    private ThemePainter _painter;

    public static ComponentUI createUI(JComponent jComponent) {
        if (_headerBoxUI == null) {
            _headerBoxUI = new BasicHeaderBoxUI();
        }
        return _headerBoxUI;
    }

    public void installUI(JComponent object) {
        object = (HeaderBox)object;
        super.installUI((JComponent)object);
        JComponent jComponent = object;
        BasicHeaderBoxUI basicHeaderBoxUI = this;
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColorsAndFont(jComponent, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(jComponent, "Panel.border");
        jComponent = object;
        basicHeaderBoxUI = this;
        object = basicHeaderBoxUI;
        object = new RolloverMouseInputAdapter((BasicHeaderBoxUI)object);
        jComponent.addMouseListener((MouseListener)object);
    }

    public void uninstallUI(JComponent jComponent) {
        MouseMotionListener[] mouseMotionListenerArray;
        HeaderBox headerBox;
        HeaderBox headerBox2 = headerBox = (HeaderBox)jComponent;
        MouseMotionListener[] mouseMotionListenerArray2 = this;
        LookAndFeel.uninstallBorder(headerBox2);
        mouseMotionListenerArray2._painter = null;
        headerBox2 = headerBox;
        mouseMotionListenerArray2 = this;
        headerBox = headerBox2;
        mouseMotionListenerArray2 = headerBox;
        mouseMotionListenerArray2 = headerBox.getMouseMotionListeners();
        if (mouseMotionListenerArray2 != null) {
            int n = mouseMotionListenerArray2.length;
            for (int i = 0; i < n; ++i) {
                MouseMotionListener mouseMotionListener = mouseMotionListenerArray2[i];
                if (!(mouseMotionListener instanceof RolloverMouseInputAdapter)) continue;
                mouseMotionListenerArray = (MouseMotionListener[])mouseMotionListener;
                break;
            }
        } else {
            mouseMotionListenerArray = mouseMotionListenerArray2 = null;
        }
        if (mouseMotionListenerArray != null) {
            headerBox.removeMouseListener((MouseListener)mouseMotionListenerArray2);
        }
        super.uninstallUI(jComponent);
    }

    public void paint(Graphics object, JComponent object2) {
        super.paint((Graphics)object, (JComponent)object2);
        JComponent jComponent = object2;
        object2 = object;
        object = this;
        HeaderBox headerBox = (HeaderBox)jComponent;
        Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (headerBox.getModel().isPressed()) {
            ((BasicHeaderBoxUI)object)._painter.paintHeaderBoxBackground(jComponent, (Graphics)object2, rectangle, 0, 1);
            return;
        }
        if (headerBox.getModel().isSelected()) {
            ((BasicHeaderBoxUI)object)._painter.paintHeaderBoxBackground(jComponent, (Graphics)object2, rectangle, 0, 3);
            return;
        }
        if (headerBox.getModel().isRollover()) {
            ((BasicHeaderBoxUI)object)._painter.paintHeaderBoxBackground(jComponent, (Graphics)object2, rectangle, 0, 2);
            return;
        }
        ((BasicHeaderBoxUI)object)._painter.paintHeaderBoxBackground(jComponent, (Graphics)object2, rectangle, 0, 0);
    }

    public final class RolloverMouseInputAdapter
    extends MouseInputAdapter {
        private long lastPressedTimestamp = -1L;
        private boolean shouldDiscardRelease = false;

        protected RolloverMouseInputAdapter(BasicHeaderBoxUI basicHeaderBoxUI) {
        }

        public final void mousePressed(MouseEvent object) {
            AbstractButton abstractButton;
            if (SwingUtilities.isLeftMouseButton((MouseEvent)object) && (abstractButton = (AbstractButton)((EventObject)object).getSource()).contains(((MouseEvent)object).getX(), ((MouseEvent)object).getY())) {
                long l = abstractButton.getMultiClickThreshhold();
                long l2 = this.lastPressedTimestamp;
                long l3 = this.lastPressedTimestamp = ((InputEvent)object).getWhen();
                if (l2 != -1L && l3 - l2 < l) {
                    this.shouldDiscardRelease = true;
                    return;
                }
                object = abstractButton.getModel();
                if (!object.isEnabled()) {
                    return;
                }
                if (!object.isArmed()) {
                    object.setArmed(true);
                }
                object.setPressed(true);
                if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                    abstractButton.requestFocus();
                }
            }
        }

        public final void mouseReleased(MouseEvent object) {
            if (SwingUtilities.isLeftMouseButton((MouseEvent)object)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                    return;
                }
                object = (AbstractButton)((EventObject)object).getSource();
                object = ((AbstractButton)object).getModel();
                object.setPressed(false);
                object.setArmed(false);
            }
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setRollover(true);
            }
            if (buttonModel.isPressed()) {
                buttonModel.setArmed(true);
            }
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && !abstractButton.contains(mouseEvent.getPoint())) {
                buttonModel.setRollover(false);
            }
            buttonModel.setArmed(false);
        }
    }
}

