/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.hints.AbstractIntelliHints;
import com.jidesoft.hints.FileIntelliHints;
import com.jidesoft.plaf.basic.BasicFileSystemTree;
import com.jidesoft.plaf.basic.BasicFileSystemTreeModel;
import com.jidesoft.plaf.basic.BasicFileSystemTreeNode;
import com.jidesoft.plaf.basic.FolderChooserResource;
import com.jidesoft.plaf.basic.FolderToolBar;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.plaf.basic.LazyMutableTreeNode;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.SelectAllUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;

public class BasicFolderChooserUI
extends BasicFileChooserUI {
    private FolderChooser _folderChooser;
    private FolderToolBar _toolbar;
    private JTree _fileSystemTree;
    private JScrollPane _treeScrollPane;
    private JButton _approveButton;
    private JButton _cancelButton;
    private JTextField _navigationTextField;
    private JPanel _buttonPanel;
    private JPanel _navigationPanel;
    private Action _approveSelectionAction = new ApproveSelectionAction(this);
    private FolderChooserSelectionListener _selectionListener;
    private FolderToolBarListener _folderToolbarListener;

    private BasicFolderChooserUI(FolderChooser folderChooser) {
        super(folderChooser);
        BasicFileSystemTreeNode.clearCache();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicFolderChooserUI((FolderChooser)jComponent);
    }

    public void installComponents(JFileChooser object) {
        this._folderChooser = (FolderChooser)object;
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        Object object2 = this;
        this._toolbar = new FolderToolBar(true, ((BasicFolderChooserUI)object2)._folderChooser.getRecentList());
        ((BasicFolderChooserUI)object2)._folderToolbarListener = new FolderToolBarListener(){
            private Cursor m_oldCursor;

            public final void deleteFolderButtonClicked() {
                TreePath treePath = BasicFolderChooserUI.this._fileSystemTree.getSelectionPaths()[0];
                Object object = 3.getSelectedFolders(new TreePath[]{treePath});
                Object object2 = FolderChooserResource.getResourceBundle(Locale.getDefault());
                String string = object.size() > 1 ? MessageFormat.format(((ResourceBundle)object2).getString("FolderChooser.delete.message2"), object.size()) : ((ResourceBundle)object2).getString("FolderChooser.delete.message1");
                object2 = ((ResourceBundle)object2).getString("FolderChooser.delete.title");
                int n = JOptionPane.showConfirmDialog(BasicFolderChooserUI.this._folderChooser, string, (String)object2, 2, 2);
                if (n == 0) {
                    TreePath treePath2 = treePath.getParentPath();
                    object2 = treePath2.getLastPathComponent();
                    Object object3 = treePath.getLastPathComponent();
                    int n2 = BasicFolderChooserUI.this._fileSystemTree.getModel().getIndexOfChild(object2, object3);
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object4 = object.next();
                        object4 = (File)object4;
                        this.recursiveDelete((File)object4);
                    }
                    ((BasicFileSystemTreeModel)BasicFolderChooserUI.this._fileSystemTree.getModel()).removePath(treePath, n2, object3);
                    object = treePath2;
                    if (n2 >= ((MutableTreeNode)object2).getChildCount()) {
                        n2 = ((MutableTreeNode)object2).getChildCount() - 1;
                    }
                    if (n2 > 0) {
                        object = treePath2.pathByAddingChild(((MutableTreeNode)object2).getChildAt(n2));
                    }
                    BasicFolderChooserUI.this._fileSystemTree.setSelectionPath((TreePath)object);
                    BasicFolderChooserUI.this._fileSystemTree.scrollPathToVisible((TreePath)object);
                }
            }

            private boolean recursiveDelete(File file) {
                if (BasicFolderChooserUI.isFileSystem(file)) {
                    if (file.isDirectory()) {
                        File[] fileArray = FileSystemView.getFileSystemView().getFiles(file, false);
                        File[] fileArray2 = fileArray;
                        fileArray2 = fileArray;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            File file2 = fileArray2[i];
                            if (this.recursiveDelete(file2)) continue;
                            return false;
                        }
                        return file.delete();
                    }
                    return file.delete();
                }
                return false;
            }

            public final void newFolderButtonClicked() {
                Object object = BasicFolderChooserUI.this._fileSystemTree.getSelectionPaths();
                Object object2 = 3.getSelectedFolders((TreePath[])object);
                if (object2.size() > 1 || object2.size() == 0) {
                    return;
                }
                object2 = (File)object2.get(0);
                ResourceBundle object3 = FolderChooserResource.getResourceBundle(Locale.getDefault());
                String n = JOptionPane.showInputDialog(BasicFolderChooserUI.this._folderChooser, object3.getString("FolderChooser.new.folderName"), object3.getString("FolderChooser.new.title"), 3);
                if (n != null) {
                    object2 = new File((File)object2, n);
                    boolean treePath = ((File)object2).mkdir();
                    object = object[0];
                    boolean bl = BasicFolderChooserUI.this._fileSystemTree.isExpanded((TreePath)object);
                    if (!bl) {
                        BasicFolderChooserUI.this._fileSystemTree.expandPath((TreePath)object);
                    }
                    LazyMutableTreeNode lazyMutableTreeNode = (LazyMutableTreeNode)((TreePath)object).getLastPathComponent();
                    object2 = BasicFileSystemTreeNode.createFileSystemTreeNode((File)object2, BasicFolderChooserUI.this._folderChooser);
                    if (treePath) {
                        lazyMutableTreeNode.clear();
                        int n2 = BasicFolderChooserUI.this._fileSystemTree.getModel().getIndexOfChild(lazyMutableTreeNode, object2);
                        if (n2 != -1) {
                            ((BasicFileSystemTreeModel)BasicFolderChooserUI.this._fileSystemTree.getModel()).nodeStructureChanged(lazyMutableTreeNode);
                        }
                    }
                    TreePath treePath2 = ((TreePath)object).pathByAddingChild(object2);
                    BasicFolderChooserUI.this._fileSystemTree.setSelectionPath(treePath2);
                    BasicFolderChooserUI.this._fileSystemTree.scrollPathToVisible(treePath2);
                }
            }

            public final void myDocumentsButtonClicked() {
                File file = FileSystemView.getFileSystemView().getDefaultDirectory();
                BasicFolderChooserUI.this.ensureFileIsVisible(file, true);
            }

            public final void desktopButtonClicked() {
                File file = FileSystemView.getFileSystemView().getHomeDirectory();
                BasicFolderChooserUI.this.ensureFileIsVisible(file, true);
            }

            public final void refreshButtonClicked() {
                File file = BasicFolderChooserUI.this._folderChooser.getSelectedFolder();
                BasicFolderChooserUI.this._folderChooser.updateUI();
                while (file != null) {
                    if (file.exists()) {
                        BasicFolderChooserUI.this._folderChooser.getUI().ensureFileIsVisible(BasicFolderChooserUI.this._folderChooser, file);
                        return;
                    }
                    if ((file = file.getParentFile()) != null) continue;
                }
            }

            public final void recentFolderSelected(File file) {
                new Thread(new Runnable(this, file){
                    private /* synthetic */ File val$file;
                    private /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$file = file;
                    }

                    public final void run() {
                        3.access$500(this.this$1, true);
                        try {
                            this.this$1.BasicFolderChooserUI.this.ensureFileIsVisible(this.val$file, true);
                            return;
                        }
                        finally {
                            3.access$500(this.this$1, false);
                        }
                    }
                }).start();
            }

            private static List getSelectedFolders(TreePath[] treePathArray) {
                if (treePathArray == null || treePathArray.length == 0) {
                    return new ArrayList();
                }
                ArrayList<File> arrayList = new ArrayList<File>(treePathArray.length);
                for (TreePath treePath : treePathArray) {
                    BasicFileSystemTreeNode serializable = (BasicFileSystemTreeNode)treePath.getLastPathComponent();
                    arrayList.add(serializable.getFile());
                }
                return arrayList;
            }

            static /* synthetic */ void access$500(3 var0, boolean bl) {
                Window window = SwingUtilities.getWindowAncestor(var0.BasicFolderChooserUI.this._folderChooser);
                if (bl) {
                    Cursor cursor = new Cursor(3);
                    var0.m_oldCursor = window.getCursor();
                    window.setCursor(cursor);
                    return;
                }
                if (var0.m_oldCursor != null) {
                    window.setCursor(var0.m_oldCursor);
                    var0.m_oldCursor = null;
                }
            }
        };
        ((BasicFolderChooserUI)object2)._toolbar.addListener(((BasicFolderChooserUI)object2)._folderToolbarListener);
        ((BasicFolderChooserUI)object2).updateToolbarButtons();
        jPanel.add((Component)((BasicFolderChooserUI)object2)._toolbar, "First");
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel jPanel2 = new JPanel();
        object2 = new BorderLayout();
        ((BorderLayout)object2).setHgap(7);
        jPanel2.setLayout((LayoutManager)object2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        object2 = this;
        Object object3 = new NavigationTextFieldListener((BasicFolderChooserUI)object2);
        ((BasicFolderChooserUI)object2)._navigationTextField = new JTextField(24);
        SelectAllUtils.install(((BasicFolderChooserUI)object2)._navigationTextField);
        Object object4 = new FileIntelliHints(((BasicFolderChooserUI)object2)._navigationTextField);
        ((FileIntelliHints)object4).setFolderOnly(true);
        ((FileIntelliHints)object4).setShowFullPath(false);
        ((AbstractIntelliHints)object4).setFollowCaret(true);
        ((BasicFolderChooserUI)object2)._navigationTextField.addActionListener((ActionListener)object3);
        object3 = new JPanel();
        object4 = new BorderLayout();
        ((Container)object3).setLayout((LayoutManager)object4);
        ((JComponent)object3).setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        ((Container)object3).add((Component)((BasicFolderChooserUI)object2)._navigationTextField, "Center");
        this._navigationPanel = object3;
        jPanel2.add((Component)this._navigationPanel, "North");
        object2 = this;
        object3 = new JPanel(new BorderLayout());
        ((BasicFolderChooserUI)object2)._fileSystemTree = new BasicFileSystemTree(((BasicFolderChooserUI)object2)._folderChooser);
        super.updateMultiSelectionEnabled();
        ((BasicFolderChooserUI)object2)._treeScrollPane = new JScrollPane(((BasicFolderChooserUI)object2)._fileSystemTree);
        ((Container)object3).add(((BasicFolderChooserUI)object2)._treeScrollPane);
        jPanel2.add((Component)object3, "Center");
        object2 = this;
        this._approveButton = new JButton();
        ((BasicFolderChooserUI)object2)._approveButton.setAction(((BasicFolderChooserUI)object2).getApproveSelectionAction());
        ((BasicFolderChooserUI)object2)._cancelButton = new JButton();
        ((BasicFolderChooserUI)object2)._cancelButton.addActionListener(((BasicFileChooserUI)object2).getCancelSelectionAction());
        object3 = new ButtonPanel();
        ((JComponent)object3).setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 0));
        ((ButtonPanel)object3).addButton(((BasicFolderChooserUI)object2)._approveButton, "AFFIRMATIVE");
        ((ButtonPanel)object3).addButton(((BasicFolderChooserUI)object2)._cancelButton, "CANCEL");
        this._buttonPanel = object3;
        jPanel2.add((Component)this._buttonPanel, "South");
        object2 = ((JFileChooser)object).getAccessory();
        if (object2 != null) {
            ((Container)object).add((Component)((JFileChooser)object).getAccessory(), "First");
        }
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add(jPanel);
        ((Container)object).add((Component)jPanel2, "Last");
        ((JFileChooser)object).setFileSelectionMode(1);
        if (this._folderChooser.isNavigationFieldVisible()) {
            this.setNavigationFieldVisible(true);
        } else {
            this.setNavigationFieldVisible(false);
        }
        this.updateView((JFileChooser)object);
        object = new Runnable(this){
            private /* synthetic */ BasicFolderChooserUI this$0;
            {
                this.this$0 = basicFolderChooserUI;
            }

            public final void run() {
                this.this$0._fileSystemTree.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
        this._folderChooser.addHierarchyListener(new HierarchyListener(this){
            private /* synthetic */ BasicFolderChooserUI this$0;
            {
                this.this$0 = basicFolderChooserUI;
            }

            public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (this.this$0._folderChooser.getRootPane() != null) {
                    this.this$0._folderChooser.getRootPane().setDefaultButton(this.this$0._approveButton);
                }
            }
        });
    }

    public final void setNavigationFieldVisible(boolean bl) {
        this._navigationPanel.setVisible(bl);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        super.rescanCurrentDirectory(jFileChooser);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        super.ensureFileIsVisible(jFileChooser, file);
        this.ensureFileIsVisible(file, true);
    }

    protected final void updateToolbarButtons() {
        TreePath[] treePathArray = this._fileSystemTree == null ? new TreePath[]{} : this._fileSystemTree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            this._toolbar.enableDelete();
        } else {
            this._toolbar.disableDelete();
        }
        if (treePathArray != null && treePathArray.length == 1) {
            this._toolbar.enableNewFolder();
            return;
        }
        this._toolbar.disableNewFolder();
    }

    private void updateMultiSelectionEnabled() {
        if (this._folderChooser.isMultiSelectionEnabled()) {
            this._fileSystemTree.getSelectionModel().setSelectionMode(4);
            return;
        }
        this._fileSystemTree.getSelectionModel().setSelectionMode(1);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.remove(this._treeScrollPane);
        jFileChooser.remove(this._buttonPanel);
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this._selectionListener = new FolderChooserSelectionListener(this);
        this._fileSystemTree.addTreeSelectionListener(this._selectionListener);
        this._fileSystemTree.registerKeyboardAction(new AbstractAction(this){
            private /* synthetic */ BasicFolderChooserUI this$0;
            {
                this.this$0 = basicFolderChooserUI;
            }

            public final void actionPerformed(ActionEvent actionEvent) {
                if (this.this$0._folderToolbarListener != null) {
                    this.this$0._folderToolbarListener.refreshButtonClicked();
                }
            }
        }, KeyStroke.getKeyStroke(116, 0), 0);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        this._fileSystemTree.removeTreeSelectionListener(this._selectionListener);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new FolderChooserPropertyChangeListener(this);
    }

    private void updateView(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonText() != null) {
            this._approveButton.setText(jFileChooser.getApproveButtonText());
            this._approveButton.setMnemonic(jFileChooser.getApproveButtonMnemonic());
        } else if (0 == jFileChooser.getDialogType()) {
            this._approveButton.setText(this.openButtonText);
            this._approveButton.setToolTipText(this.openButtonToolTipText);
            this._approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this._approveButton.setText(this.saveButtonText);
            this._approveButton.setToolTipText(this.saveButtonToolTipText);
            this._approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        this._cancelButton.setText(this.cancelButtonText);
        this._cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this._buttonPanel.setVisible(jFileChooser.getControlButtonsAreShown());
    }

    public static boolean isFileSystem(File file) {
        if (file instanceof ShellFolder) {
            return ((ShellFolder)(file = (ShellFolder)file)).isFileSystem() && (!((ShellFolder)file).isLink() || !((ShellFolder)file).isDirectory());
        }
        return true;
    }

    private TreePath getTreePathForFile(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        Stack<Object> stack = new Stack<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this._fileSystemTree.getModel().getRoot());
        Object object = this._folderChooser.getFileSystemView();
        File[] fileArray = null;
        File file2 = null;
        if (SystemInfo.isWindows() && BasicFolderChooserUI.isFileSystem(file2 = (object = object.getRoots())[0]) && file2.isDirectory()) {
            fileArray = file2.listFiles();
        }
        object = file;
        block0: do {
            stack.push(object);
            if (fileArray == null) continue;
            file = fileArray;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file3 = file[i];
                if (!file3.equals(object)) continue;
                stack.push(file2);
                break block0;
            }
        } while ((object = this._folderChooser.getFileSystemView().getParentDirectory((File)object)) != null);
        while (!stack.empty()) {
            arrayList.add(BasicFileSystemTreeNode.createFileSystemTreeNode((File)stack.pop(), this._folderChooser));
        }
        return new TreePath(arrayList.toArray());
    }

    private void ensureFileIsVisible(File object, boolean bl) {
        if ((object = object == null ? new TreePath(this._fileSystemTree.getModel().getRoot()) : this.getTreePathForFile((File)object)) != null) {
            this._fileSystemTree.setSelectionPath((TreePath)object);
            this._fileSystemTree.expandPath((TreePath)object);
            if (bl) {
                object = new Runnable(this, (TreePath)object){
                    private /* synthetic */ TreePath val$path;
                    private /* synthetic */ BasicFolderChooserUI this$0;
                    {
                        this.this$0 = basicFolderChooserUI;
                        this.val$path = treePath;
                    }

                    public final void run() {
                        this.this$0._fileSystemTree.scrollPathToVisible(this.val$path);
                    }
                };
                SwingUtilities.invokeLater((Runnable)object);
            }
        }
    }

    public Action getApproveSelectionAction() {
        return this._approveSelectionAction;
    }

    static /* synthetic */ void access$1200(BasicFolderChooserUI basicFolderChooserUI) {
        TreePath[] treePathArray = basicFolderChooserUI._fileSystemTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            basicFolderChooserUI._folderChooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = treePathArray.length;
        for (int i = 0; i < n; ++i) {
            File file = ((BasicFileSystemTreeNode)treePathArray[i].getLastPathComponent()).getFile();
            arrayList.add(file);
        }
        basicFolderChooserUI._folderChooser.setSelectedFiles(arrayList.toArray(new File[arrayList.size()]));
    }

    final class ApproveSelectionAction
    extends AbstractAction {
        private /* synthetic */ BasicFolderChooserUI this$0;

        public ApproveSelectionAction(BasicFolderChooserUI basicFolderChooserUI) {
            this.this$0 = basicFolderChooserUI;
            this.setEnabled(false);
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            BasicFolderChooserUI.access$1200(this.this$0);
            this.this$0._folderChooser.approveSelection();
        }
    }

    final class FolderChooserSelectionListener
    implements TreeSelectionListener {
        private /* synthetic */ BasicFolderChooserUI this$0;

        private FolderChooserSelectionListener(BasicFolderChooserUI basicFolderChooserUI, byte by) {
            this.this$0 = basicFolderChooserUI;
        }

        public final void valueChanged(TreeSelectionEvent object) {
            this.this$0.getApproveSelectionAction().setEnabled(this.this$0._fileSystemTree.getSelectionCount() > 0);
            if (this.this$0._toolbar != null) {
                this.this$0.updateToolbarButtons();
            }
            if (this.this$0._fileSystemTree.getSelectionCount() > 0 && (object = ((TreeSelectionEvent)object).getNewLeadSelectionPath()) != null) {
                object = ((TreePath)object).getLastPathComponent().toString();
                object = new File((String)object);
                this.this$0._folderChooser.setSelectedFolder((File)object);
                object = this.this$0._fileSystemTree.getSelectionPath();
                if (object != null) {
                    this.this$0._navigationTextField.setText("" + ((TreePath)object).getLastPathComponent());
                }
            }
        }

        /* synthetic */ FolderChooserSelectionListener(BasicFolderChooserUI basicFolderChooserUI) {
            this(basicFolderChooserUI, 0);
        }
    }

    final class FolderChooserPropertyChangeListener
    implements PropertyChangeListener {
        private /* synthetic */ BasicFolderChooserUI this$0;

        private FolderChooserPropertyChangeListener(BasicFolderChooserUI basicFolderChooserUI, byte by) {
            this.this$0 = basicFolderChooserUI;
        }

        public final void propertyChange(PropertyChangeEvent serializable) {
            if ("recentList".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                this.this$0._toolbar.setRecentList((List)((PropertyChangeEvent)serializable).getNewValue());
                return;
            }
            if ("ApproveButtonTextChangedProperty".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                this.this$0.updateView(this.this$0._folderChooser);
                return;
            }
            if ("DialogTypeChangedProperty".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                this.this$0.updateView(this.this$0._folderChooser);
                return;
            }
            if ("MultiSelectionEnabledChangedProperty".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                this.this$0.updateMultiSelectionEnabled();
                return;
            }
            if ("directoryChanged".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                this.this$0.ensureFileIsVisible(this.this$0._folderChooser.getCurrentDirectory(), true);
                return;
            }
            if ("AccessoryChangedProperty".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                Component component = (Component)((PropertyChangeEvent)serializable).getOldValue();
                serializable = (Component)((PropertyChangeEvent)serializable).getNewValue();
                if (component != null) {
                    this.this$0._folderChooser.remove(component);
                }
                if (serializable != null) {
                    this.this$0._folderChooser.add((Component)serializable, "First");
                }
                this.this$0._folderChooser.revalidate();
                this.this$0._folderChooser.repaint();
                return;
            }
            if ("ControlButtonsAreShownChangedProperty".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                this.this$0.updateView(this.this$0._folderChooser);
                return;
            }
            if ("navigationFieldVisible".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                if (this.this$0._folderChooser.isNavigationFieldVisible()) {
                    this.this$0.setNavigationFieldVisible(true);
                    return;
                }
                this.this$0.setNavigationFieldVisible(false);
                return;
            }
            if ("availableButtons".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                Component[] componentArray = this.this$0._toolbar.getComponents();
                serializable = componentArray;
                int n = componentArray.length;
                for (int i = 0; i < n; ++i) {
                    Serializable serializable2 = serializable[i];
                    if (!(serializable2 instanceof JButton)) continue;
                    String string = ((Component)serializable2).getName();
                    int n2 = this.this$0._folderChooser.getAvailableButtons();
                    boolean bl = FolderToolBar.isButtonVisible(string, n2);
                    ((Component)serializable2).setVisible(bl);
                }
                return;
            }
            if ("recentListVisible".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
                Component[] componentArray = this.this$0._toolbar.getComponents();
                serializable = componentArray;
                int n = componentArray.length;
                for (int i = 0; i < n; ++i) {
                    Serializable serializable3 = serializable[i];
                    if (!(serializable3 instanceof JComboBox) && !(serializable3 instanceof JLabel)) continue;
                    ((Component)serializable3).setVisible(this.this$0._folderChooser.isRecentListVisible());
                }
            }
        }

        /* synthetic */ FolderChooserPropertyChangeListener(BasicFolderChooserUI basicFolderChooserUI) {
            this(basicFolderChooserUI, 0);
        }
    }

    public final class NavigationTextFieldListener
    implements ActionListener {
        private /* synthetic */ BasicFolderChooserUI this$0;

        public NavigationTextFieldListener(BasicFolderChooserUI basicFolderChooserUI) {
            this.this$0 = basicFolderChooserUI;
        }

        public final void actionPerformed(ActionEvent object) {
            object = this.this$0._navigationTextField.getText();
            if (object == null || ((String)object).equals("")) {
                return;
            }
            TreePath treePath = this.this$0._fileSystemTree.getSelectionPath();
            if (treePath != null && ((String)object).equals("" + treePath.getLastPathComponent())) {
                this.this$0._approveButton.doClick(200);
            }
            if (((File)(object = new File((String)object))).exists()) {
                this.this$0.ensureFileIsVisible((File)object, true);
                this.this$0._folderChooser.setSelectedFolder((File)object);
            }
        }
    }
}

