/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.MaskFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IconsFactory {
    private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    private static ImageIcon EMPTY_ICON;

    public static ImageIcon getImageIcon(Class<?> serializable, String string) {
        String string2 = serializable.getName() + ":" + string;
        Icon icon = icons.get(string2);
        if (icon != null) {
            return (ImageIcon)icon;
        }
        serializable = IconsFactory.createImageIcon(serializable, string);
        icons.put(string2, (ImageIcon)serializable);
        return serializable;
    }

    public static ImageIcon createGrayImage(Image image) {
        if (image == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }

    public static ImageIcon createGrayImage(Component component, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        if (n == 0 || n2 == 0) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static ImageIcon createMaskImage(Component component, Icon icon, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createImage(bufferedImage, color, color2));
    }

    public static ImageIcon createNegativeImage(Component component, Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(component, bufferedImage.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createNegativeImage(bufferedImage));
    }

    private static ImageIcon createImageIcon(Class<?> object, String string) {
        try {
            object = ((Class)object).getResourceAsStream(string);
            if (object == null) {
                System.err.println("Image file " + string + " is missing");
                return null;
            }
            return new ImageIcon(ImageIO.read((InputStream)object));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return null;
        }
    }

    public static void generateHTML(Class<?> clazz) {
        String string = clazz.getName();
        String string2 = IconsFactory.getClassName(string);
        File file = new File(string + ".html");
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<html>\n<body>\n<p><b><font size=\"5\" face=\"Verdana\">Icons in " + string + "</font></b></p>");
            fileWriter.write("<p><b><font size=\"3\" face=\"Verdana\">Generated by JIDE Icons</font></b></p>");
            fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">1. If you cannot view the images in this page, make sure the file is at the same directory as " + string2 + ".java</font></b></p>");
            fileWriter.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">2. To get a particular icon in your code, call " + string2 + ".getImageIcon(FULL_CONSTANT_NAME). Replace FULL_CONSTANT_NAME with the actual " + "full constant name as in the table below" + "</font></b></p>");
            IconsFactory.generate(clazz, fileWriter, string2);
            fileWriter.write("\n</body>\n</html>");
            fileWriter.close();
            System.out.println("File is generated at \"" + file.getAbsolutePath() + "\". Please copy it to the same directory as " + string2 + ".java");
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    private static String getClassName(String object) {
        int n = ((String)object).lastIndexOf(".");
        if (n != -1) {
            object = ((String)object).substring(n + 1);
        }
        object = new StringTokenizer((String)object, "$");
        StringBuffer stringBuffer = new StringBuffer();
        while (((StringTokenizer)object).hasMoreTokens()) {
            stringBuffer.append(((StringTokenizer)object).nextToken());
            stringBuffer.append(".");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private static void generate(Class<?> clazz, FileWriter fileWriter, String string) throws IOException {
        Field[] fieldArray;
        Class<?>[] classArray = clazz.getDeclaredClasses();
        for (int i = classArray.length - 1; i >= 0; --i) {
            fieldArray = classArray[i];
            IconsFactory.generate(fieldArray, fileWriter, IconsFactory.getClassName(fieldArray.getName()));
        }
        Field[] fieldArray2 = clazz.getFields();
        fileWriter.write("<p><font face=\"Verdana\"><b>" + string + "</b></font></p>");
        fileWriter.write("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#CCCCCC\" width=\"66%\">");
        fileWriter.write("<tr>\n");
        fileWriter.write("<td width=\"24%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Name</font></b></td>\n");
        fileWriter.write("<td width=\"13%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Image</font></b></td>\n");
        fileWriter.write("<td width=\"32%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">File Name</font></b></td>\n");
        fileWriter.write("<td width=\"31%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Full Constant Name</font></b></td>\n");
        fileWriter.write("</tr>\n");
        fieldArray = fieldArray2;
        int n = fieldArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = fieldArray[i];
            try {
                object = ((Field)object2).getName();
                object2 = ((Field)object2).get(clazz);
                fileWriter.write("<tr>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + object + "</font></td>\n");
                fileWriter.write("<td align=\"center\"><font face=\"Verdana\"><img border=\"0\" src=\"" + object2 + "\"></font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + object2 + "</font></td>\n");
                fileWriter.write("<td align=\"left\"><font face=\"Verdana\">" + string + "." + object + "</font></td>\n");
                fileWriter.write("</tr>\n");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = illegalArgumentException;
                illegalArgumentException.printStackTrace();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                object = illegalAccessException;
                illegalAccessException.printStackTrace();
            }
        }
        fileWriter.write("</table><br><p>\n");
    }

    public static ImageIcon getIcon(Component component, ImageIcon imageIcon, int n, int n2, int n3, int n4) {
        int n5 = n4;
        int n6 = n3;
        component = null;
        int n7 = 2;
        ImageObserver imageObserver = null;
        if (imageIcon == null || n < 0 || n + n3 > imageIcon.getIconWidth() || n2 < 0 || n2 + n4 > imageIcon.getIconHeight()) {
            return EMPTY_ICON;
        }
        BufferedImage bufferedImage = new BufferedImage(n6, n5, 2);
        bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n6, n5, n, n2, n + n3, n2 + n4, imageObserver);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon getOverlayIcon(Component component, ImageIcon imageIcon, ImageIcon imageIcon2, int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        n = 0;
        component = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = imageIcon.getIconWidth();
        int n5 = imageIcon.getIconHeight();
        int n6 = imageIcon2.getIconWidth();
        int n7 = imageIcon2.getIconHeight();
        switch (n) {
            case 0: {
                n2 = (n4 - n6) / 2;
                n3 = (n5 - n7) / 2;
                break;
            }
            case 1: {
                n2 = (n4 - n6) / 2;
                n3 = insets.top;
                break;
            }
            case 5: {
                n2 = (n4 - n6) / 2;
                n3 = n5 - insets.bottom - n7;
                break;
            }
            case 7: {
                n2 = insets.left;
                n3 = (n5 - n7) / 2;
                break;
            }
            case 3: {
                n2 = n4 - insets.right - n6;
                n3 = (n5 - n7) / 2;
                break;
            }
            case 2: {
                n2 = n4 - insets.right - n6;
                n3 = insets.top;
                break;
            }
            case 8: {
                n2 = insets.left;
                n3 = insets.top;
                break;
            }
            case 6: {
                n2 = insets.left;
                n3 = n5 - insets.bottom - n7;
                break;
            }
            case 4: {
                n2 = n4 - insets.right - n6;
                n3 = n5 - insets.bottom - n7;
            }
        }
        int n8 = n3;
        n = n2;
        n2 = imageIcon == null ? imageIcon2.getIconWidth() : imageIcon.getIconWidth();
        n3 = imageIcon == null ? imageIcon2.getIconHeight() : imageIcon.getIconHeight();
        n4 = imageIcon2.getIconWidth();
        n5 = imageIcon2.getIconHeight();
        if (n != -1 && n8 != -1) {
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            if (imageIcon != null) {
                bufferedImage.getGraphics().drawImage(imageIcon.getImage(), 0, 0, n2, n3, component);
            }
            bufferedImage.getGraphics().drawImage(imageIcon2.getImage(), n, n8, n4, n5, component);
            return new ImageIcon(bufferedImage);
        }
        return imageIcon;
    }

    static {
        new HashMap();
        new HashMap();
        EMPTY_ICON = new ImageIcon(){

            public final int getIconHeight() {
                return 16;
            }

            public final int getIconWidth() {
                return 16;
            }

            public final synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }
        };
    }
}

