/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public abstract class NumberConverter
implements ObjectConverter {
    private NumberFormat _numberFormat;
    public static final ConverterContext CONTEXT_FRACTION_NUMBER = new ConverterContext("Fraction Number");
    private static boolean _groupingUsed = true;

    public NumberConverter() {
    }

    public NumberConverter(NumberFormat numberFormat) {
        this._numberFormat = numberFormat;
    }

    public String toString(Object object, ConverterContext converterContext) {
        try {
            if (converterContext != null) {
                // empty if block
            }
            if (object instanceof Number && ((Number)object).doubleValue() == Double.NaN) {
                return "";
            }
            return this.getNumberFormat().format(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    private NumberFormat getNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = DecimalFormat.getInstance();
            this._numberFormat.setGroupingUsed(_groupingUsed);
        }
        return this._numberFormat;
    }

    protected final Number parseNumber(String string) {
        Serializable serializable;
        try {
            serializable = this.getNumberFormat().parse(string);
        }
        catch (ParseException parseException) {
            try {
                serializable = DecimalFormat.getInstance(Locale.US);
                ((NumberFormat)serializable).setGroupingUsed(_groupingUsed);
                serializable = ((NumberFormat)serializable).parse(string);
            }
            catch (ParseException parseException2) {
                serializable = null;
            }
        }
        return serializable;
    }

    public final void setFractionDigits(int n, int n2) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
    }
}

