/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.MetricCounters;
import java.io.Serializable;

public class MetricData
implements Serializable {
    public MetricCounters totals = new MetricCounters();
    public MetricCounters rates = new MetricCounters();
    public long totalMemory;
    public long freeMemory;
    public long timestamp;
    public int nConnections;

    public MetricData() {
        this.reset();
    }

    public synchronized void reset() {
        this.totals.reset();
        this.rates.reset();
        this.timestamp = 0L;
        this.totalMemory = 0L;
        this.freeMemory = 0L;
        this.nConnections = 0;
    }

    public synchronized void setTotals(MetricCounters metricCounters) {
        this.totals.reset();
        this.totals.update(metricCounters);
    }

    public synchronized void setRates(MetricCounters metricCounters) {
        this.rates.reset();
        this.rates.update(metricCounters);
    }

    public String toString() {
        String string = "Connections: " + this.nConnections + "    JVM Heap: " + this.totalMemory + " bytes (" + this.freeMemory + " free)" + " Threads: " + this.totals.threadsActive + " (" + this.totals.threadsLowWater + "-" + this.totals.threadsHighWater + ")" + "\n" + "      In: " + this.totals.messagesIn + " msgs (" + this.totals.messageBytesIn + " bytes)  " + this.totals.packetsIn + " pkts (" + this.totals.packetBytesIn + " bytes)\n" + "     Out: " + this.totals.messagesOut + " msgs (" + this.totals.messageBytesOut + " bytes)  " + this.totals.packetsOut + " pkts (" + this.totals.packetBytesOut + " bytes)\n" + " Rate In: " + this.rates.messagesIn + " msgs/sec (" + this.rates.messageBytesIn + " bytes/sec)  " + this.rates.packetsIn + " pkts/sec (" + this.rates.packetBytesIn + " bytes/sec)\n" + "Rate Out: " + this.rates.messagesOut + " msgs/sec (" + this.rates.messageBytesOut + " bytes/sec)  " + this.rates.packetsOut + " pkts/sec (" + this.rates.packetBytesOut + " bytes/sec)";
        return string;
    }
}

