/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.QBrowserV2;
import com.qbrowser.container.MessageContainer;
import com.qbrowser.property.Property;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTable
extends DefaultTableModel {
    static ResourceBundle resources = QBrowserV2.resources;
    final String[] columnNames = new String[]{resources.getString("qkey.proptable.header.key"), resources.getString("qkey.proptable.header.prop_type"), resources.getString("qkey.proptable.header.prop_value")};
    LinkedList list = null;
    private Message innermessage = null;
    ArrayList type_selection = null;

    public PropertyTable() {
        this.init();
        this.add_one_row(new Property());
    }

    public PropertyTable(int number_of_initial_rows) {
        this.init();
        for (int i = 0; i < number_of_initial_rows; ++i) {
            this.add_one_row(new Property());
        }
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class<?> getCellClassAt(int row, int column) {
        return this.getColumnClass(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        p.setKey((String)value);
                    }
                    return;
                }
                case 1: {
                    if (value instanceof String) {
                        p.setProperty_type((String)value);
                    }
                    return;
                }
                case 2: {
                    p.setProperty_value(value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.getKey();
                }
                case 1: {
                    return p.getProperty_type();
                }
                case 2: {
                    return p.getProperty_value();
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public int load(Enumeration e) {
        if (e == null) {
            return 0;
        }
        this.list = new LinkedList();
        while (e.hasMoreElements()) {
            this.list.add(e.nextElement());
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    public Message getInnerMessage() {
        return this.innermessage;
    }

    public int load(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        Message message = mc.getMessage();
        this.list = new LinkedList();
        try {
            Enumeration enu = message.getPropertyNames();
            while (enu.hasMoreElements()) {
                String name = enu.nextElement().toString();
                Object propvalueobj = message.getObjectProperty(name);
                Property prop = new Property();
                prop.setKey(name);
                if (propvalueobj instanceof String) {
                    JTextArea jobj = new JTextArea(1, 10);
                    jobj.setText((String)propvalueobj);
                    jobj.setToolTipText(resources.getString("qkey.msg.msg230"));
                    prop.setProperty_value(jobj);
                } else {
                    prop.setProperty_value(propvalueobj);
                }
                prop.autoComplementTypeNme();
                this.list.add(prop);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.fireTableDataChanged();
        this.innermessage = message;
        return this.list.size();
    }

    void init() {
        this.list = new LinkedList();
    }

    public void add_one_row(Property value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public void add_one_empty_row() {
        this.list.add(new Property());
        this.fireTableDataChanged();
    }

    public void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public Property getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (Property)this.list.get(row);
    }
}

