/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.MessagePersister;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class TextMessagePersister
extends MessagePersister {
    String textbody;

    public TextMessagePersister() {
    }

    public TextMessagePersister(TextMessage val) {
        this.message = val;
        try {
            this.textbody = val.getText();
        }
        catch (JMSException jme) {
            jme.printStackTrace();
        }
    }

    public TextMessagePersister(LocalMessageContainer vlmc) {
        this.lmc = vlmc;
        this.message = vlmc.getMessage();
        try {
            this.textbody = ((TextMessage)this.message).getText();
        }
        catch (JMSException jme) {
            jme.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File persistToFile() throws Exception {
        File workfileDir = super.persistToFile();
        File target1 = new File(workfileDir.getAbsolutePath() + File.separator + "textbodysize");
        PrintWriter pwr = null;
        ByteArrayInputStream bis = null;
        FileOutputStream fo = null;
        try {
            pwr = new PrintWriter(new FileWriter(target1));
            long fsize = 0L;
            File efile = new File(workfileDir.getAbsolutePath() + File.separator + "TextMessageBody.txt");
            if (this.textbody != null && this.textbody.length() > 0) {
                byte[] bibi = new byte[1024];
                bis = new ByteArrayInputStream(this.textbody.getBytes());
                fo = new FileOutputStream(efile);
                int len = 0;
                long readfilesize = 0L;
                while ((len = bis.read(bibi, 0, bibi.length)) != -1) {
                    fo.write(bibi, 0, len);
                    readfilesize += (long)len;
                }
                fsize = readfilesize;
            } else {
                efile.createNewFile();
            }
            pwr.println(fsize);
        }
        catch (Throwable thex) {
            thex.printStackTrace();
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException ioe) {}
                fo = null;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {}
                bis = null;
            }
            if (pwr != null) {
                pwr.close();
            }
        }
        return workfileDir;
    }
}

