/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.StreamMessage;

public class StreamMessageReader
extends PersistedMessageReader {
    ArrayList stream_data = new ArrayList();

    void readFileAndSetPropertyValue(String filepath, Property prop) throws Exception {
        String type = prop.getProperty_type();
        if (type.equals("String")) {
            prop.setProperty_value(this.readFileIntoString(new File(filepath)));
            prop.selfValidate();
        } else if (type.equals("Int")) {
            prop.setProperty_value(Integer.parseInt(this.readFileIntoString(new File(filepath))));
            prop.selfValidate();
        } else if (type.equals("Boolean")) {
            prop.setProperty_value(Boolean.parseBoolean(this.readFileIntoString(new File(filepath))));
            prop.selfValidate();
        } else if (type.equals("Bytes")) {
            prop.setProperty_value(this.readFileIntoBytes(new File(filepath)));
            prop.validated_type = 10;
            prop.selfValidate();
        } else if (type.equals("Byte")) {
            prop.setProperty_value(Byte.parseByte(this.readFileIntoString(new File(filepath))));
            prop.selfValidate();
        } else if (type.equals("Char")) {
            prop.setProperty_value(this.readFileIntoString(new File(filepath)));
            prop.selfValidate();
        } else if (type.equals("Double")) {
            prop.setProperty_value(Double.parseDouble(this.readFileIntoString(new File(filepath))));
            prop.selfValidate();
        } else if (type.equals("Float")) {
            prop.setProperty_value(Float.valueOf(Float.parseFloat(this.readFileIntoString(new File(filepath)))));
            prop.selfValidate();
        } else if (type.equals("Long")) {
            prop.setProperty_value(Long.parseLong(this.readFileIntoString(new File(filepath))));
            prop.selfValidate();
        } else if (type.equals("Short")) {
            prop.setProperty_value(Short.parseShort(this.readFileIntoString(new File(filepath))));
            prop.selfValidate();
        }
    }

    public File readPersistedMessage(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessage(msgArchive);
        BufferedReader br = null;
        File def_file = new File(workdirFile.getAbsolutePath() + File.separator + "StreamMessageDef");
        if (def_file == null || !def_file.exists()) {
            StreamMessageReader.clearDir(workdirFile);
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg334") + def_file.getName() + QBrowserV2.resources.getString("qkey.msg.msg335"));
        }
        try {
            br = new BufferedReader(new FileReader(def_file));
            String line = null;
            while ((line = br.readLine()) != null) {
                Property map_prop = new Property();
                ArrayList ar = QBrowserUtil.parseDelimitedString(line, "@@@HzRpWr@@");
                block11: for (int i = 0; i < ar.size(); ++i) {
                    String token = (String)ar.get(i);
                    switch (i) {
                        case 0: {
                            map_prop.setKey(token);
                            continue block11;
                        }
                        case 1: {
                            map_prop.setProperty_type(token);
                            continue block11;
                        }
                        case 2: {
                            String fullpath = workdirFile.getAbsolutePath() + File.separator + "StreamMessage" + File.separator + token;
                            this.readFileAndSetPropertyValue(fullpath, map_prop);
                        }
                    }
                }
                this.stream_data.add(map_prop);
            }
        }
        catch (Exception ie) {
            StreamMessageReader.clearDir(workdirFile);
            ie.printStackTrace();
            throw new IOException(QBrowserV2.resources.getString("qkey.msg.msg331") + ie.getMessage() + "\n\nFile=" + def_file.getName());
        }
        finally {
            if (br != null) {
                br.close();
                br = null;
            }
        }
        return workdirFile;
    }

    public File readPersistedMessageWithLazyLoad(File msgArchive) throws Exception {
        File workdirFile = super.readPersistedMessageWithLazyLoad(msgArchive);
        return workdirFile;
    }

    public LocalMessageContainer recreateMessagefromReadData(Session session) throws Exception {
        StreamMessage smsg = session.createStreamMessage();
        LocalMessageContainer lmc = new LocalMessageContainer();
        lmc.setReal_file_path(this.source_file_path);
        if (this.properties != null) {
            QBrowserUtil.copyUserProperties(this.properties, (Message)smsg);
        }
        lmc.setMessage((Message)smsg);
        if (this.headers != null) {
            QBrowserUtil.copyMessageHeaders(this.headers, (Message)smsg);
            QBrowserUtil.populateHeadersOfLocalMessageContainer(this.headers, lmc);
        }
        try {
            block16: for (int i = 0; i < this.stream_data.size(); ++i) {
                Property sm_body_data = (Property)this.stream_data.get(i);
                switch (sm_body_data.validated_type) {
                    case 0: {
                        continue block16;
                    }
                    case 10: {
                        smsg.writeBytes(sm_body_data.getProperty_valueASBytes());
                        continue block16;
                    }
                    case 1: {
                        smsg.writeString(sm_body_data.getProperty_valueASString());
                        continue block16;
                    }
                    case 3: {
                        smsg.writeBoolean(sm_body_data.getProperty_valueASBoolean());
                        continue block16;
                    }
                    case 2: {
                        smsg.writeInt(sm_body_data.getProperty_valueASInt());
                        continue block16;
                    }
                    case 4: {
                        smsg.writeByte(sm_body_data.getProperty_valueASByte());
                        continue block16;
                    }
                    case 11: {
                        smsg.writeChar(sm_body_data.getProperty_valueASCharacter());
                        continue block16;
                    }
                    case 9: {
                        byte[] bytesarray = QBrowserUtil.extractBytes(sm_body_data.getProperty_valueASString());
                        if (bytesarray == null) {
                            throw new Exception("Q0021");
                        }
                        smsg.writeBytes(bytesarray);
                        continue block16;
                    }
                    case 5: {
                        smsg.writeDouble(sm_body_data.getProperty_valueASDouble());
                        continue block16;
                    }
                    case 6: {
                        smsg.writeFloat(sm_body_data.getProperty_valueASFloat());
                        continue block16;
                    }
                    case 7: {
                        smsg.writeLong(sm_body_data.getProperty_valueASLong());
                        continue block16;
                    }
                    case 8: {
                        smsg.writeShort(sm_body_data.getProperty_valueASShort());
                        continue block16;
                    }
                }
            }
        }
        catch (Throwable thex) {
            thex.printStackTrace();
        }
        return lmc;
    }

    public LocalMessageContainer recreateMessagefromReadDataWithLazyLoad() throws Exception {
        LocalMessageContainer lmc = super.recreateMessagefromReadDataWithLazyLoad();
        lmc.setMessage_type("StreamMessage");
        return lmc;
    }
}

