/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.persist;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.persist.Zipper;
import com.qbrowser.property.Property;
import com.qbrowser.util.QBrowserUtil;
import java.awt.TextArea;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.swing.JDialog;

public class MessagePersister {
    Message message;
    LocalMessageContainer lmc;
    ArrayList headers = new ArrayList();
    ArrayList properties = new ArrayList();
    TextArea ta;
    JDialog msgDialog;
    public static final String STRING_START = "<@begin-@string@>";
    public static final String STRING_END = "<@end-@string@>";
    public static final String BYTES_START = "<@begin-@bytes@>";
    public static final String BYTES_END = "<@end-@bytes@>";
    static ResourceBundle resources = QBrowserV2.resources;

    public MessagePersister() {
    }

    public MessagePersister(Message value) {
        this.message = value;
    }

    public MessagePersister(LocalMessageContainer vlmc) {
        this.lmc = vlmc;
        this.message = vlmc.getMessage();
    }

    public void setTextArea(TextArea taval) {
        this.ta = taval;
    }

    public void setMsgDialog(JDialog value) {
        this.msgDialog = value;
    }

    public void zipUp(File workdirFile, File targetFile) {
        Zipper mm = new Zipper();
        try {
            File tempzip = new File(QBrowserUtil.getQBrowserTempFileDir() + System.currentTimeMillis());
            this.ta.append(resources.getString("qkey.msg.msg257") + " " + targetFile.getAbsolutePath() + "\n");
            mm.zipForDir(workdirFile, tempzip, false, ".zip");
            this.ta.append(resources.getString("qkey.msg.msg258") + " " + targetFile.getName() + "\n");
            if (targetFile.exists()) {
                targetFile.delete();
            }
            if (!tempzip.renameTo(targetFile)) {
                this.ta.append(resources.getString("qkey.msg.msg254"));
                tempzip.delete();
            }
            this.cleanupWorkDir(workdirFile);
            workdirFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File persistToFile() throws Exception {
        if (this.lmc != null) {
            this.collectJMSHeadersFromLMC();
        } else {
            this.collectJMSHeaders();
        }
        String workdir = QBrowserUtil.getQBrowserTempFileDir() + "JMS" + System.nanoTime() + File.separator;
        File workdirFile = new File(workdir);
        workdirFile.mkdirs();
        File target1 = new File(workdir + "JMSHeaders.txt");
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(target1));
            pwr.println(this.propertiesToString(this.headers));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
        this.collectProperties();
        File target2 = new File(workdir + "UserProperties.txt");
        PrintWriter pwr2 = null;
        try {
            pwr2 = new PrintWriter(new FileWriter(target2));
            pwr2.println(this.propertiesToString(this.properties));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (pwr2 != null) {
                pwr2.close();
                pwr2 = null;
            }
        }
        return workdirFile;
    }

    public void cleanupWorkDir(File workdir) {
        if (workdir == null) {
            return;
        }
        File[] files = workdir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.cleanupWorkDir(files[i]);
                if (files[i].listFiles().length != 0) continue;
                files[i].delete();
                continue;
            }
            if (!files[i].isFile()) continue;
            try {
                files[i].delete();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    String propertiesToString(ArrayList props) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int i = 0; i < props.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n");
            }
            Property prop = (Property)props.get(i);
            sb.append("\"").append(prop.getKey()).append("\"");
            sb.append(",").append(prop.getProperty_type());
            sb.append("=");
            if (prop.getProperty_type().equals("String")) {
                sb.append(STRING_START).append(prop.getProperty_value()).append(STRING_END);
                continue;
            }
            sb.append("\"").append(prop.getProperty_value()).append("\"");
        }
        return sb.toString();
    }

    void collectJMSHeaders() {
        try {
            String msgid = this.message.getJMSMessageID();
            Property msgidp = new Property();
            msgidp.setKey("JMSMessageID");
            msgidp.setProperty_type("String");
            msgidp.setProperty_value(msgid);
            this.headers.add(msgidp);
            Destination d1 = this.message.getJMSDestination();
            String s1 = null;
            s1 = d1 != null ? (d1 instanceof Queue ? ((Queue)d1).getQueueName() + " : Queue" : ((Topic)d1).getTopicName() + " : Topic") : "";
            Property jdestp = new Property();
            jdestp.setKey("JMSDestination");
            jdestp.setProperty_type("String");
            jdestp.setProperty_value(s1);
            this.headers.add(jdestp);
            Destination d = this.message.getJMSReplyTo();
            String s = null;
            s = d != null ? (d instanceof Queue ? ((Queue)d).getQueueName() + " : Queue" : ((Topic)d).getTopicName() + " : Topic") : "";
            Property jrepto = new Property();
            jrepto.setKey("JMSReplyTo");
            jrepto.setProperty_type("String");
            jrepto.setProperty_value(s);
            this.headers.add(jrepto);
            String jcorid = this.message.getJMSCorrelationID();
            Property jcoridp = new Property();
            jcoridp.setKey("JMSCorrelationID");
            jcoridp.setProperty_type("String");
            jcoridp.setProperty_value(jcorid);
            this.headers.add(jcoridp);
            int delivermode = this.message.getJMSDeliveryMode();
            Property delivermodep = new Property();
            delivermodep.setKey("JMSDeliverMode");
            delivermodep.setProperty_type("Int");
            delivermodep.setProperty_value(delivermode);
            this.headers.add(delivermodep);
            int jpri = this.message.getJMSPriority();
            Property jprip = new Property();
            jprip.setKey("JMSPriority");
            jprip.setProperty_type("Int");
            jprip.setProperty_value(jpri);
            this.headers.add(jprip);
            long jexp = this.message.getJMSExpiration();
            Property jexp_prop = new Property();
            jexp_prop.setKey("JMSExpiration");
            jexp_prop.setProperty_type("Long");
            jexp_prop.setProperty_value(jexp);
            this.headers.add(jexp_prop);
            String jtype = this.message.getJMSType();
            Property jtypep = new Property();
            jtypep.setKey("JMSType");
            jtypep.setProperty_type("String");
            jtypep.setProperty_value(jtype);
            this.headers.add(jtypep);
            boolean redelivered = this.message.getJMSRedelivered();
            Property redvd = new Property();
            redvd.setKey("JMSRedelivered");
            redvd.setProperty_type("Boolean");
            redvd.setProperty_value(redelivered);
            this.headers.add(redvd);
            long jtimestamp = this.message.getJMSTimestamp();
            Property jtimestampp = new Property();
            jtimestampp.setKey("JMSTimestamp");
            jtimestampp.setProperty_type("Long");
            jtimestampp.setProperty_value(jtimestamp);
            this.headers.add(jtimestampp);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    void collectJMSHeadersFromLMC() {
        try {
            String msgid = this.lmc.getVmsgid();
            Property msgidp = new Property();
            msgidp.setKey("JMSMessageID");
            msgidp.setProperty_type("String");
            msgidp.setProperty_value(msgid);
            this.headers.add(msgidp);
            Destination d1 = this.lmc.getVdest();
            String s1 = null;
            s1 = d1 != null ? (d1 instanceof Queue ? ((Queue)d1).getQueueName() + " : Queue" : ((Topic)d1).getTopicName() + " : Topic") : "";
            Property jdestp = new Property();
            jdestp.setKey("JMSDestination");
            jdestp.setProperty_type("String");
            jdestp.setProperty_value(s1);
            this.headers.add(jdestp);
            Destination d = this.lmc.getVreplyto();
            String s = null;
            s = d != null ? (d instanceof Queue ? ((Queue)d).getQueueName() + " : Queue" : ((Topic)d).getTopicName() + " : Topic") : "";
            Property jrepto = new Property();
            jrepto.setKey("JMSReplyTo");
            jrepto.setProperty_type("String");
            jrepto.setProperty_value(s);
            this.headers.add(jrepto);
            String jcorid = this.lmc.getVcorrelationid();
            Property jcoridp = new Property();
            jcoridp.setKey("JMSCorrelationID");
            jcoridp.setProperty_type("String");
            jcoridp.setProperty_value(jcorid);
            this.headers.add(jcoridp);
            int delivermode = this.lmc.getVdeliverymode();
            Property delivermodep = new Property();
            delivermodep.setKey("JMSDeliverMode");
            delivermodep.setProperty_type("Int");
            delivermodep.setProperty_value(delivermode);
            this.headers.add(delivermodep);
            int jpri = this.lmc.getVpriority();
            Property jprip = new Property();
            jprip.setKey("JMSPriority");
            jprip.setProperty_type("Int");
            jprip.setProperty_value(jpri);
            this.headers.add(jprip);
            long jexp = this.lmc.getVexpiration();
            Property jexp_prop = new Property();
            jexp_prop.setKey("JMSExpiration");
            jexp_prop.setProperty_type("Long");
            jexp_prop.setProperty_value(jexp);
            this.headers.add(jexp_prop);
            String jtype = this.lmc.getVjms_type();
            Property jtypep = new Property();
            jtypep.setKey("JMSType");
            jtypep.setProperty_type("String");
            jtypep.setProperty_value(jtype);
            this.headers.add(jtypep);
            boolean redelivered = this.lmc.isVredelivered();
            Property redvd = new Property();
            redvd.setKey("JMSRedelivered");
            redvd.setProperty_type("Boolean");
            redvd.setProperty_value(redelivered);
            this.headers.add(redvd);
            long jtimestamp = this.lmc.getVtimestamp();
            Property jtimestampp = new Property();
            jtimestampp.setKey("JMSTimestamp");
            jtimestampp.setProperty_type("Long");
            jtimestampp.setProperty_value(jtimestamp);
            this.headers.add(jtimestampp);
            ArrayList<Property> aps = this.lmc.getAdditionalHeaders();
            for (int i = 0; i < aps.size(); ++i) {
                this.headers.add(aps.get(i));
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    void collectProperties() {
        try {
            Enumeration enu = this.message.getPropertyNames();
            while (enu.hasMoreElements()) {
                String name = enu.nextElement().toString();
                Object propvalueobj = this.message.getObjectProperty(name);
                Property prop = new Property();
                prop.setKey(name);
                prop.setProperty_value(propvalueobj);
                prop.autoComplementTypeNme();
                this.properties.add(prop);
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stringPropertyToFile(File efile, String string_property) {
        ByteArrayInputStream bis = null;
        FileOutputStream fo = null;
        try {
            byte[] bibi = new byte[1024];
            if (!efile.getParentFile().exists()) {
                efile.getParentFile().mkdirs();
            }
            bis = new ByteArrayInputStream(string_property.getBytes());
            fo = new FileOutputStream(efile);
            int len = 0;
            long readfilesize = 0L;
            int count = 0;
            while ((len = bis.read(bibi, 0, bibi.length)) != -1) {
                fo.write(bibi, 0, len);
                readfilesize += (long)len;
                if (++count <= 100) continue;
                this.ta.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + string_property.length() + " " + resources.getString("qkey.msg.msg099") + "\n");
                this.ta.setCaretPosition(this.ta.getText().length());
                count = 0;
            }
            if (count != 0) {
                this.ta.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + string_property.length() + " " + resources.getString("qkey.msg.msg099") + "\n");
                this.ta.setCaretPosition(this.ta.getText().length());
            }
        }
        catch (Throwable thex) {
            thex.printStackTrace();
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException ioe) {}
                fo = null;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {}
                bis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void intPropertyToFile(File efile, Integer int_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(int_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bytePropertyToFile(File efile, Byte byte_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(byte_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shortPropertyToFile(File efile, Short short_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(short_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void longPropertyToFile(File efile, Long long_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(long_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void booleanPropertyToFile(File efile, Boolean boolean_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(boolean_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void floatPropertyToFile(File efile, Float float_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(float_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void charPropertyToFile(File efile, Character char_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(char_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doublePropertyToFile(File efile, double double_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        PrintWriter pwr = null;
        try {
            pwr = new PrintWriter(new FileWriter(efile));
            pwr.print(double_property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwr != null) {
                pwr.close();
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bytesPropertyToFile(File efile, byte[] bytes_property) {
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        ByteArrayInputStream bis = null;
        FileOutputStream fo = null;
        try {
            byte[] bibi = new byte[1024];
            bis = new ByteArrayInputStream(bytes_property);
            fo = new FileOutputStream(efile);
            int len = 0;
            long readfilesize = 0L;
            int count = 0;
            while ((len = bis.read(bibi, 0, bibi.length)) != -1) {
                fo.write(bibi, 0, len);
                readfilesize += (long)len;
                if (++count <= 100) continue;
                this.ta.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + bytes_property.length + " " + resources.getString("qkey.msg.msg099") + "\n");
                this.ta.setCaretPosition(this.ta.getText().length());
                count = 0;
            }
            if (count != 0) {
                this.ta.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + bytes_property.length + " " + resources.getString("qkey.msg.msg099") + "\n");
                this.ta.setCaretPosition(this.ta.getText().length());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException ioe) {}
                fo = null;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {}
                bis = null;
            }
        }
    }
}

