/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.VRFileRAF;
import com.sun.messaging.jmq.io.VRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class VRecordRAF
extends VRecord {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    private VRFileRAF parent;
    private long recordStartAt;
    private int index;

    VRecordRAF(VRFileRAF vRFileRAF, long l, int n, short s) throws IOException {
        this(vRFileRAF, l, n, s, false);
        this.cookie = vRFileRAF.readShort(this.recordStartAt + 10L);
    }

    VRecordRAF(VRFileRAF vRFileRAF, long l, int n, short s, boolean bl) throws IOException {
        if (DEBUG) {
            System.out.println("VRecordRAF:new record: from " + l + " for " + n);
        }
        this.parent = vRFileRAF;
        this.recordStartAt = l;
        this.capacity = n;
        this.state = s;
        if (bl) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(12);
            byteBuffer.putInt(this.magic);
            byteBuffer.putInt(this.capacity);
            byteBuffer.putShort(this.state);
            byteBuffer.putShort((short)0);
            byteBuffer.rewind();
            vRFileRAF.writeByteBuffer(this.recordStartAt, byteBuffer);
        }
        this.index = 12;
        if (DEBUG) {
            System.out.println("index start at " + this.index);
        }
    }

    public void setCookie(short s) throws IOException {
        this.cookie = s;
        try {
            this.parent.writeShort(this.recordStartAt + 10L, this.cookie);
            if (this.parent.getSafe()) {
                this.force();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.toString() + ":setCookie()", iOException);
        }
    }

    public short getCookie() {
        return this.cookie;
    }

    public void force() throws IOException {
        if (DEBUG) {
            System.out.println("will do force on " + this.parent);
        }
        this.parent.force();
    }

    public String toString() {
        return "VRecordRAF: start=" + this.recordStartAt + "; cap=" + this.capacity + ";state=" + this.state + ";index=" + this.index;
    }

    void free() {
        this.index = 12;
        this.state = 1;
        try {
            this.parent.writeShort(this.recordStartAt + 8L, this.state);
            this.parent.writeShort(this.recordStartAt + 10L, (short)0);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.toString() + ":free()", iOException);
        }
    }

    void allocate(short s) {
        this.state = s;
        try {
            this.parent.writeShort(this.recordStartAt + 8L, this.state);
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.toString() + ":allocate()", iOException);
        }
    }

    public void writeInt(int n, int n2) throws IOException {
        if (n > this.getDataCapacity() - 4) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write integer at position " + n);
        }
        this.parent.writeInt(this.recordStartAt + 12L + (long)n, n2);
    }

    public void writeInt(int n) throws IOException {
        if (this.index > this.capacity - 4) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write integer at position " + this.index);
        }
        this.parent.writeInt((long)this.index + this.recordStartAt, n);
        this.index += 4;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after writeInt");
        }
    }

    public int readInt() throws IOException {
        if (this.index > this.capacity - 4) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read an integer from position " + this.index);
        }
        int n = this.parent.readInt((long)this.index + this.recordStartAt);
        this.index += 4;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after readInt");
        }
        return n;
    }

    public long readLong() throws IOException {
        if (this.index > this.capacity - 8) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read a long from position " + this.index);
        }
        long l = this.parent.readLong((long)this.index + this.recordStartAt);
        this.index += 8;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after readLong");
        }
        return l;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (this.index > this.capacity - byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write " + byteBuffer.remaining() + " bytes at position " + this.index);
        }
        int n = this.parent.writeByteBuffer((long)this.index + this.recordStartAt, byteBuffer);
        this.index += n;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after write ByteBuffer");
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.index > this.capacity - n2) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write " + n2 + " bytes at position " + this.index);
        }
        this.parent.write((long)this.index + this.recordStartAt, byArray, n, n2);
        this.index += n2;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after write byte[]");
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.index > this.capacity - n2) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read " + n2 + "bytes from position " + this.index);
        }
        int n3 = this.parent.read((long)this.index + this.recordStartAt, byArray, n, n2);
        this.index += n3;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after read byte[]");
        }
        return n3;
    }

    public FileChannel getChannel() {
        return this.parent.getChannel();
    }

    public void rewind() {
        this.index = 12;
        if (DEBUG) {
            System.out.println("rewind index to " + this.index);
        }
    }

    public void position(int n) {
        if (n > this.getDataCapacity()) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to position at position " + n);
        }
        this.index = 12 + n;
    }

    public int remaining() {
        return this.capacity - this.index;
    }

    public void writeLong(long l) throws IOException {
        if (this.index > this.capacity - 8) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write a long at position " + this.index);
        }
        this.parent.writeLong((long)this.index + this.recordStartAt, l);
        this.index += 8;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after writeLong");
        }
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.index > this.capacity - byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to read " + byteBuffer.remaining() + " bytes at position " + this.index);
        }
        int n = this.parent.readByteBuffer((long)this.index + this.recordStartAt, byteBuffer);
        this.index += n;
        if (DEBUG) {
            System.out.println("index = " + this.index + " after read ByteBuffer");
        }
        return n;
    }

    public void writeShort(int n, short s) throws IOException {
        if (n > this.getDataCapacity() - 2) {
            throw new IndexOutOfBoundsException(this.toString() + ": try to write a short at position " + n);
        }
        this.parent.writeShort(this.recordStartAt + 12L + (long)n, s);
        if (DEBUG) {
            System.out.println("this writeShort does not change index");
        }
    }
}

