/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private SessionImpl _session;
    private ConnectionImpl _connection;
    private Transaction _transaction = null;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    protected static Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = 0;
    public static final Integer XA_END = 1;
    public static final Integer XA_PREPARE = 2;
    public static final Integer XA_ROLLBACK_ONLY = 4;
    public static boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static boolean XATracking = !turnOffXATracking;

    public XAResourceImpl(SessionImpl sessionImpl) throws JMSException {
        this._session = sessionImpl;
        this._connection = sessionImpl.connection;
        this.resourceManagerId = this._connection.protocolHandler.generateUID();
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:new:RMId=" + this.resourceManagerId);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:onePhase=" + bl + "\txid=\n" + jMQXid.toString());
        }
        if (this._session.isRollbackOnly) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
            XAException xAException = new XAException(-7);
            xAException.initCause(this._session.rollbackCause);
            throw xAException;
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                if (Debug.debug) {
                    Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:using 0 as txnID");
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HACommit(xid, jMQXid, bl);
                } else {
                    this._connection.getProtocolHandler().commit(0L, bl ? 0x40000000 : 0, jMQXid);
                }
            } else {
                if (Debug.debug) {
                    Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:commit:using real txnID");
                }
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    this._session.receiveCommit();
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HACommit(xid, jMQXid, bl);
                } else {
                    this._transaction.commitXATransaction(jMQXid, bl);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        finally {
            this._session.releaseInSyncState();
            this._session.switchOffXATransaction();
        }
    }

    public void end(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:end:flags=" + n + "\txid=\n" + jMQXid.toString());
        }
        try {
            this._session.transaction.endXATransaction(n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this.getClass().isInstance(xAResource) ? this.isSameJMQRM((XAResourceImpl)xAResource) : false;
    }

    public boolean isSameJMQRM(XAResourceImpl xAResourceImpl) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xAResourceImpl.getResourceManagerId();
        }
        return false;
    }

    public int prepare(Xid xid, boolean bl) throws XAException {
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:txid=\n" + jMQXid.toString());
        }
        if (this._session.isRollbackOnly) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:prepare:forcing Rollback due to:" + this._session.rollbackCause.getMessage());
            XAException xAException = new XAException(-7);
            xAException.initCause(this._session.rollbackCause);
            throw xAException;
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                this._connection.getProtocolHandler().prepare(0L, jMQXid, bl);
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (bl) {
                    this._connection.getProtocolHandler().prepare(0L, jMQXid, bl);
                } else {
                    this._transaction.prepareXATransaction(jMQXid);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:recover:flags=" + n);
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            xidArray = this._connection.getProtocolHandler().recover(n);
            this._connection.closeConnectionFromRA();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:rollback:txid=\n" + jMQXid.toString());
        }
        try {
            try {
                this._connection.openConnectionFromRA(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnectionFromRA(true);
            }
            if (this._transaction == null) {
                if (this._connection.isConnectedToHABroker) {
                    this.HARollback(jMQXid);
                } else {
                    this._connection.getProtocolHandler().rollback(0L, jMQXid);
                }
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    this._session.receiveRollback();
                }
                if (this._connection.isConnectedToHABroker) {
                    this.HARollback(jMQXid);
                } else {
                    this._transaction.rollbackXATransaction(jMQXid);
                }
            }
            this._connection.closeConnectionFromRA();
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        finally {
            this._session.failoverOccurred = false;
            this._session.releaseInSyncState();
            this._session.switchOffXATransaction();
            this._session.isRollbackOnly = false;
            this._session.rollbackCause = null;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (Debug.debug) {
            Debug.println("*=*=*=*=*=*=*=*=*=*=XAR:start:flags=" + n + "\txid=\n" + jMQXid.toString());
        }
        try {
            this._session.switchOnXATransaction();
            this._transaction = this._session.transaction;
            this._transaction.startXATransaction(n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    protected static synchronized void setState(Object object, Object object2) {
        xaTable.put(object, object2);
    }

    protected static synchronized Integer getState(Object object) {
        return (Integer)xaTable.get(object);
    }

    protected static synchronized Object removeXid(Object object) {
        return xaTable.remove(object);
    }

    protected static synchronized boolean isPrepared(Object object) {
        boolean bl = false;
        Integer n = (Integer)xaTable.get(object);
        if (n != null && n.intValue() == XA_PREPARE.intValue()) {
            bl = true;
        }
        return bl;
    }

    protected static synchronized boolean isRollbackOnly(Object object) {
        boolean bl = false;
        Integer n = (Integer)xaTable.get(object);
        if (n != null && n.intValue() == XA_ROLLBACK_ONLY.intValue()) {
            bl = true;
        }
        return bl;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        JMQXid jMQXid = null;
        if (this._connection.isConnectedToHABroker) {
            jMQXid = new JMQXid(xid);
        }
        try {
            this.prepare(xid, false);
        }
        catch (XAException xAException) {
            if (this._connection.isConnectedToHABroker) {
                this.checkPrepareStatus(xAException, jMQXid);
            }
            throw xAException;
        }
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XA_PREPARE);
        }
        return n;
    }

    private boolean isXATracking() {
        return this._connection.isConnectedToHABroker() && XATracking;
    }

    private void checkPrepareStatus(XAException xAException, JMQXid jMQXid) throws XAException {
        if (!this._connection.imqReconnect) {
            throw xAException;
        }
        try {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw xAException;
            }
            this.verifyPrepare(jMQXid);
        }
        catch (XAException xAException2) {
            throw xAException2;
        }
        catch (Exception exception) {
            XAException xAException3 = new XAException(-7);
            xAException3.initCause(exception);
            throw xAException3;
        }
    }

    private void verifyPrepare(JMQXid jMQXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jMQXid);
        int n = this._connection.protocolHandler.verifyHATransaction(0L, 1, jMQXid);
        switch (n) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + jMQXid);
                return;
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void HAOnePhaseCommit(Xid xid, JMQXid jMQXid) throws JMSException, XAException {
        int n = 1;
        try {
            this.prepare(xid, true);
            n = 2;
            if (this.isXATracking()) {
                xaTable.put(jMQXid, XAResourceForRA.XA_PREPARE);
            }
            this._connection.getProtocolHandler().commit(0L, 0, jMQXid, true);
        }
        catch (Exception exception) {
            this.checkCommitStatus(exception, n, jMQXid, true);
        }
        XAResourceImpl.removeXid(jMQXid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void HATwoPhaseCommit(JMQXid jMQXid) throws JMSException, XAException {
        block2: {
            try {
                this._connection.getProtocolHandler().commit(0L, 0, jMQXid);
            }
            catch (JMSException jMSException) {
                if (!this.isXATracking()) throw jMSException;
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n == null || n != 2) break block2;
                this.checkCommitStatus(jMSException, 2, jMQXid, false);
            }
        }
        XAResourceImpl.removeXid(jMQXid);
    }

    private void checkCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(exception, n, jMQXid, bl);
        }
        catch (Exception exception2) {
            if (exception2 instanceof JMSException) {
                throw (JMSException)exception2;
            }
            if (exception2 instanceof XAException) {
                throw (XAException)exception2;
            }
            XAException xAException = new XAException(-7);
            xAException.initCause(exception2);
            throw xAException;
        }
    }

    private void doCheckCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws Exception {
        if (!this._connection.imqReconnect) {
            throw exception;
        }
        SessionImpl.yield();
        this._connection.checkReconnecting(null);
        if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
            throw exception;
        }
        this.verifyTransaction(n, jMQXid, bl);
    }

    private void verifyTransaction(int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        int n2 = this._connection.protocolHandler.verifyHATransaction(0L, n, jMQXid);
        switch (n2) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + jMQXid);
                    this._connection.getProtocolHandler().commit(0L, 0, jMQXid, bl);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + jMQXid);
                    return;
                }
                catch (JMSException jMSException) {
                    SessionImpl.yield();
                    this._connection.checkReconnecting(null);
                    throw jMSException;
                }
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void HACommit(Xid xid, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        if (bl) {
            this.HAOnePhaseCommit(xid, jMQXid);
        } else {
            this.HATwoPhaseCommit(jMQXid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void HARollback(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jMQXid, true);
        }
        catch (JMSException jMSException) {
            SessionImpl.yield();
            this._connection.checkReconnecting(null);
            if (this._connection.isCloseCalled || this._connection.connectionIsBroken) {
                throw jMSException;
            }
            this.retryRollBack(jMQXid);
        }
        finally {
            XAResourceImpl.removeXid(jMQXid);
        }
    }

    private void retryRollBack(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this._connection.getProtocolHandler().rollback(0L, jMQXid, true, true);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jMSException.toString());
                }
                throw jMSException;
            }
            throw jMSException;
        }
    }
}

