/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jms.ra.OnMessageRunner;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForRA
implements XAResource {
    private ConnectionImpl raConnection;
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private OnMessageRunner omr;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    private boolean setRollback = false;
    private Exception rollbackCause = null;
    private static Hashtable xaTable = new Hashtable();
    public static final Integer XA_START = 0;
    public static final Integer XA_END = 1;
    public static final Integer XA_PREPARE = 2;
    public static boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static boolean XATracking = !turnOffXATracking;

    public XAResourceForRA(OnMessageRunner onMessageRunner, ConnectionImpl connectionImpl, ConnectionImpl connectionImpl2) throws JMSException {
        this.omr = onMessageRunner;
        this.id = onMessageRunner.getId();
        this.raConnection = connectionImpl;
        this.epConnection = connectionImpl2;
        if (connectionImpl == null) {
            System.err.println("MQRA:XARFRA:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (connectionImpl._isClosed()) {
            System.err.println("MQRA:XARFRA:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = connectionImpl.getProtocolHandler().generateUID();
            }
            catch (Exception exception) {
                System.err.println("MQRA:XARFRA:constr:Exc acquiring RMId:assuming distinct");
            }
        }
    }

    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid;
        block11: {
            jMQXid = new JMQXid(xid);
            if (bl && this.setRollback) {
                Debug.printStackTrace(this.rollbackCause);
                XAException xAException = new XAException(-7);
                xAException.initCause(this.rollbackCause);
                throw xAException;
            }
            try {
                if (!this.epConnection._isClosed()) {
                    if (bl) {
                        if (this.epConnection.isConnectedToHABroker()) {
                            this.HAOnePhaseCommit(xid, jMQXid);
                        } else {
                            this.epConnection.getProtocolHandler().commit(0L, 0x40000000, jMQXid);
                        }
                    } else if (this.epConnection.isConnectedToHABroker()) {
                        this.HATwoPhaseCommit(jMQXid);
                    } else {
                        this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid);
                    }
                    break block11;
                }
                System.err.println("MQRA:XARFRA:commit:ConnectionClosed:throw XAExc txn:1p=" + bl + ":xid=" + jMQXid.toString());
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof RemoteAcknowledgeException) {
                    exception2 = (RemoteAcknowledgeException)exception;
                    XASessionImpl xASessionImpl = (XASessionImpl)this.omr.getEndpointConsumer().getXASession();
                    xASessionImpl.notifyRemoteAcknowledgeException((RemoteAcknowledgeException)exception2);
                }
                this.epConnection.waitForReconnecting(exception);
                Debug.printStackTrace(exception);
                exception2 = new XAException(-7);
                exception2.initCause(exception);
                throw exception2;
            }
        }
        this.removeXid(jMQXid);
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        if (this.epConnection._isClosed()) {
            XAException xAException = new XAException(-7);
            throw xAException;
        }
        try {
            this.epConnection.getProtocolHandler().endTransaction(0L, n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = false;
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XA_END);
        }
    }

    public synchronized void _endLocal() throws XAException {
        try {
            this.epConnection.getProtocolHandler().commit(this.transactionID, 0, null);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = false;
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this.getClass().isInstance(xAResource) ? this.isSameJMQRM((XAResourceForRA)xAResource) : false;
    }

    public boolean isSameJMQRM(XAResourceForRA xAResourceForRA) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xAResourceForRA.getResourceManagerId();
        }
        return false;
    }

    public synchronized int prepare(Xid xid, boolean bl) throws XAException {
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        if (this.setRollback) {
            Debug.printStackTrace(this.rollbackCause);
            XAException xAException = new XAException(-7);
            xAException.initCause(this.rollbackCause);
            throw xAException;
        }
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jMQXid, bl);
        }
        catch (Exception exception) {
            Exception exception2;
            if (exception instanceof RemoteAcknowledgeException) {
                exception2 = (RemoteAcknowledgeException)exception;
                ((XASessionImpl)this.omr.getEndpointConsumer().getXASession()).notifyRemoteAcknowledgeException((RemoteAcknowledgeException)exception2);
            }
            Debug.printStackTrace(exception);
            exception2 = new XAException(-7);
            exception2.initCause(exception);
            throw exception2;
        }
        return n;
    }

    public synchronized int prepare(Xid xid) throws XAException {
        int n = 0;
        try {
            this.prepare(xid, false);
        }
        catch (XAException xAException) {
            if (this.epConnection.isConnectedToHABroker) {
                this.checkPrepareStatus(xAException, this.jmqXid);
            }
            throw xAException;
        }
        if (this.isXATracking()) {
            xaTable.put(this.jmqXid, XA_PREPARE);
        }
        return n;
    }

    private void HAOnePhaseCommit(Xid xid, JMQXid jMQXid) throws JMSException, XAException {
        int n = 1;
        try {
            this.prepare(xid, true);
            n = 2;
            if (this.isXATracking()) {
                xaTable.put(jMQXid, XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid, true);
        }
        catch (Exception exception) {
            this.checkCommitStatus(exception, n, jMQXid, true);
        }
        this.removeXid(jMQXid);
    }

    private void HATwoPhaseCommit(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n == 2) {
                    this.checkCommitStatus(jMSException, 2, jMQXid, false);
                }
            }
            throw jMSException;
        }
        this.removeXid(jMQXid);
    }

    private void checkPrepareStatus(XAException xAException, JMQXid jMQXid) throws XAException {
        if (!this.epConnection.imqReconnect) {
            throw xAException;
        }
        try {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw xAException;
            }
            this.verifyPrepare(jMQXid);
        }
        catch (XAException xAException2) {
            throw xAException2;
        }
        catch (Exception exception) {
            XAException xAException3 = new XAException(-7);
            xAException3.initCause(exception);
            throw xAException3;
        }
    }

    private void verifyPrepare(JMQXid jMQXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jMQXid);
        int n = this.epConnection.protocolHandler.verifyHATransaction(0L, 1, jMQXid);
        switch (n) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + this.transactionID);
                return;
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    private void checkCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(exception, n, jMQXid, bl);
        }
        catch (Exception exception2) {
            if (exception2 instanceof JMSException) {
                throw (JMSException)exception2;
            }
            if (exception2 instanceof XAException) {
                throw (XAException)exception2;
            }
            XAException xAException = new XAException(-7);
            xAException.initCause(exception2);
            throw xAException;
        }
    }

    private void doCheckCommitStatus(Exception exception, int n, JMQXid jMQXid, boolean bl) throws Exception {
        if (!this.epConnection.imqReconnect) {
            throw exception;
        }
        SessionImpl.yield();
        this.epConnection.checkReconnecting(null);
        if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
            throw exception;
        }
        this.verifyTransaction(n, jMQXid, bl);
    }

    private void verifyTransaction(int n, JMQXid jMQXid, boolean bl) throws JMSException, XAException {
        int n2 = this.epConnection.protocolHandler.verifyHATransaction(0L, n, jMQXid);
        switch (n2) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.epConnection.getProtocolHandler().commit(0L, 0, jMQXid, bl);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jMSException) {
                    SessionImpl.yield();
                    this.epConnection.checkReconnecting(null);
                    throw jMSException;
                }
            }
        }
        XAException xAException = new XAException(100);
        throw xAException;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            xidArray = this.epConnection.getProtocolHandler().recover(n);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return xidArray;
    }

    public synchronized void rollback(Xid xid) throws XAException {
        JMQXid jMQXid;
        block5: {
            jMQXid = new JMQXid(xid);
            try {
                if (!this.epConnection._isClosed()) {
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HARollback(jMQXid);
                    } else {
                        this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true);
                    }
                    break block5;
                }
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            catch (JMSException jMSException) {
                Debug.printStackTrace(jMSException);
                XAException xAException = new XAException(-7);
                xAException.initCause(jMSException);
                throw xAException;
            }
        }
        this.removeXid(jMQXid);
    }

    private void HARollback(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true);
        }
        catch (JMSException jMSException) {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw jMSException;
            }
            this.retryRollBack(jMQXid);
        }
        this.removeXid(jMQXid);
    }

    private void retryRollBack(JMQXid jMQXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jMQXid, true, true);
        }
        catch (JMSException jMSException) {
            if (this.isXATracking()) {
                Integer n = (Integer)xaTable.get(jMQXid);
                if (n != null && n != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jMSException.toString());
                }
                throw jMSException;
            }
            throw jMSException;
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            if (this.epConnection._isClosed()) {
                XAException xAException = new XAException(-7);
                throw xAException;
            }
            this.transactionID = this.epConnection.getProtocolHandler().startTransaction(this.transactionID, n, jMQXid);
            this.jmqXid = jMQXid;
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = true;
        if (this.isXATracking()) {
            xaTable.put(jMQXid, XA_START);
        }
    }

    public synchronized void _startLocal() throws XAException {
        try {
            this.transactionID = this.epConnection.protocolHandler.startTransaction(-1L, 0, null);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace(jMSException);
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        this.started = true;
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    public void setRollback(boolean bl, Exception exception) {
        this.setRollback = bl;
        this.rollbackCause = exception;
    }

    private boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XATracking;
    }

    private void removeXid(JMQXid jMQXid) {
        if (this.isXATracking()) {
            xaTable.remove(jMQXid);
        }
    }
}

