/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.JMSXAConnection;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXAQueueConnection;
import com.sun.jms.spi.xa.JMSXAQueueConnectionFactory;
import com.sun.jms.spi.xa.JMSXASession;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicConnectionFactory;
import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedTransactionListener;
import com.sun.messaging.jmq.jmsclient.XAResourceImpl;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class JMSXAWrappedXAResourceImpl
implements XAResource {
    private static final boolean debug = JMSXAWrappedConnectionFactoryImpl.debug;
    private XAResource xar;
    private JMSXAConnectionFactory cf = null;
    private boolean isQueue;
    private String username = null;
    private String password = null;
    private boolean closed = false;
    private JMSXAWrappedTransactionListener listener = null;

    public JMSXAWrappedXAResourceImpl(XAResource xAResource, boolean bl, JMSXAConnectionFactory jMSXAConnectionFactory, String string, String string2) {
        this.xar = xAResource;
        this.cf = jMSXAConnectionFactory;
        this.isQueue = bl;
        this.username = string;
        this.password = string2;
    }

    protected void setTransactionListener(JMSXAWrappedTransactionListener jMSXAWrappedTransactionListener) {
        this.listener = jMSXAWrappedTransactionListener;
    }

    protected void close() {
        this.closed = true;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("commit(Xid=" + xid + " onePhase=" + bl + "), closed=" + this.closed);
            boolean bl2 = false;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                this.xar.commit(xid, bl);
                bl2 = true;
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        bl2 = false;
                        break;
                    }
                    case 4: {
                        bl2 = false;
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                throw xAException;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(xid, bl2);
                }
            }
        }
        JMSXAConnection jMSXAConnection = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed commit() ...");
            jMSXAConnection = this.getConnection();
            XAResource xAResource = this.getXAResource(jMSXAConnection);
            JMSXAWrappedXAResourceImpl.dlog("closed commit(Xid=" + xid + " onePhase=" + bl + ")");
            xAResource.commit(xid, bl);
        }
        catch (JMSException jMSException) {
            JMSXAWrappedXAResourceImpl.log("Error:", jMSException);
            throw new XAException(-7);
        }
        finally {
            if (jMSXAConnection != null) {
                try {
                    jMSXAConnection.close();
                }
                catch (Exception exception) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "commit():Connection.close(): " + exception.getMessage());
                }
            }
        }
    }

    public void end(Xid xid, int n) throws XAException {
        boolean bl = false;
        try {
            if (this.listener != null) {
                this.listener.beforeTransactionComplete();
            }
            this.xar.end(xid, n);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            throw xAException;
        }
        finally {
            if (this.listener != null) {
                this.listener.afterTransactionComplete(xid, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("forget(Xid=" + xid + "), closed=" + this.closed);
            boolean bl = false;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                this.xar.forget(xid);
                bl = true;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(xid, bl);
                }
            }
        }
        JMSXAConnection jMSXAConnection = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed forget(Xid=" + xid + ")");
            jMSXAConnection = this.getConnection();
            XAResource xAResource = this.getXAResource(jMSXAConnection);
            xAResource.forget(xid);
        }
        catch (JMSException jMSException) {
            JMSXAWrappedXAResourceImpl.log("Error:", jMSException);
            throw new XAException(-7);
        }
        finally {
            if (jMSXAConnection != null) {
                try {
                    jMSXAConnection.close();
                }
                catch (Exception exception) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "forget():Connection.close(): " + exception.getMessage());
                }
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.xar.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        JMSXAWrappedXAResourceImpl.dlog(this.xar.getClass().getName() + ".isSameRM(" + xAResource.getClass().getName() + ")");
        return this.xar.isSameRM(xAResource);
    }

    public int prepare(Xid xid) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("prepare(Xid=" + xid + "), closed=" + this.closed);
            boolean bl = false;
            int n = 0;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                if ((n = this.xar.prepare(xid)) == 3) {
                    bl = true;
                }
                int n2 = n;
                return n2;
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                throw xAException;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(xid, bl);
                }
            }
        }
        JMSXAConnection jMSXAConnection = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed prepare(Xid=" + xid + ")");
            jMSXAConnection = this.getConnection();
            XAResource xAResource = this.getXAResource(jMSXAConnection);
            int n = xAResource.prepare(xid);
            return n;
        }
        catch (JMSException jMSException) {
            JMSXAWrappedXAResourceImpl.log("Error:", jMSException);
            throw new XAException(-7);
        }
        finally {
            if (jMSXAConnection != null) {
                try {
                    jMSXAConnection.close();
                }
                catch (Exception exception) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "prepare():Connection.close():" + exception.getMessage());
                }
            }
        }
    }

    public Xid[] recover(int n) throws XAException {
        return this.xar.recover(n);
    }

    public void rollback(Xid xid) throws XAException {
        if (!this.closed || this.xar instanceof XAResourceImpl) {
            JMSXAWrappedXAResourceImpl.dlog("rollback(Xid=" + xid + "), closed=" + this.closed);
            boolean bl = false;
            try {
                if (this.listener != null) {
                    this.listener.beforeTransactionComplete();
                }
                this.xar.rollback(xid);
                bl = true;
            }
            catch (XAException xAException) {
                switch (xAException.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        bl = false;
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                throw xAException;
            }
            finally {
                if (this.listener != null) {
                    this.listener.afterTransactionComplete(xid, bl);
                }
            }
        }
        JMSXAConnection jMSXAConnection = null;
        try {
            JMSXAWrappedXAResourceImpl.dlog("closed rollback() ...");
            jMSXAConnection = this.getConnection();
            XAResource xAResource = this.getXAResource(jMSXAConnection);
            JMSXAWrappedXAResourceImpl.dlog("closed rollback(Xid=" + xid + ")");
            xAResource.rollback(xid);
        }
        catch (JMSException jMSException) {
            JMSXAWrappedXAResourceImpl.log("Error:", jMSException);
            throw new XAException(-7);
        }
        finally {
            if (jMSXAConnection != null) {
                try {
                    jMSXAConnection.close();
                }
                catch (Exception exception) {
                    JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "rollback():Connection.close():" + exception.getMessage());
                }
            }
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return this.xar.setTransactionTimeout(n);
    }

    public void start(Xid xid, int n) throws XAException {
        boolean bl = false;
        try {
            if (this.listener != null) {
                this.listener.beforeTransactionStart();
            }
            this.xar.start(xid, n);
            if (n == 0) {
                bl = true;
            }
        }
        catch (JMSException jMSException) {
            JMSXAWrappedXAResourceImpl.log("Error:", jMSException);
            throw new XAException(-7);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            throw xAException;
        }
        finally {
            if (this.listener != null) {
                this.listener.afterTransactionStart(xid, bl);
            }
        }
    }

    private JMSXAConnection getConnection() throws JMSException {
        JMSXAConnection jMSXAConnection = null;
        jMSXAConnection = this.isQueue ? (this.username == null ? ((JMSXAQueueConnectionFactory)this.cf).createXAQueueConnection() : ((JMSXAQueueConnectionFactory)this.cf).createXAQueueConnection(this.username, this.password)) : (this.username == null ? ((JMSXATopicConnectionFactory)this.cf).createXATopicConnection() : ((JMSXATopicConnectionFactory)this.cf).createXATopicConnection(this.username, this.password));
        return jMSXAConnection;
    }

    public XAResource getDelegatedXAResource() {
        return this.xar;
    }

    private XAResource getXAResource(JMSXAConnection jMSXAConnection) throws JMSException, XAException {
        JMSXASession jMSXASession = this.isQueue ? ((JMSXAQueueConnection)jMSXAConnection).createXAQueueSession(true, 1) : ((JMSXATopicConnection)jMSXAConnection).createXATopicSession(true, 1);
        XAResource xAResource = jMSXASession.getXAResource();
        String string = null;
        string = xAResource instanceof JMSXAWrappedXAResourceImpl ? ((JMSXAWrappedXAResourceImpl)xAResource).getDelegatedXAResource().getClass().getName() : xAResource.getClass().getName();
        boolean bl = JMSXAWrappedXAResourceImpl.isSystemPropertySetFor("skipIsSameRMCheckForExternalJMSXAResource", string);
        if (xAResource.isSameRM(this.xar)) {
            JMSXAWrappedXAResourceImpl.dlog("isSameRM() true - " + this.xar.getClass().getName());
            try {
                int n = this.xar.getTransactionTimeout();
                if (n >= 0) {
                    xAResource.setTransactionTimeout(n);
                }
            }
            catch (Exception exception) {
                JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "get/setTransactionTimeout(): " + exception.getMessage());
            }
        } else {
            if (!bl) {
                JMSXAWrappedXAResourceImpl.log("Error:", "isSameRM() false - " + this.xar.getClass().getName());
                throw new XAException(-7);
            }
            JMSXAWrappedXAResourceImpl.log(AdministeredObject.cr.getKString("W2002"), "isSameRM() false, ignore.  - " + this.xar.getClass().getName());
        }
        return xAResource;
    }

    public static boolean isSystemPropertySetFor(String string, String string2) {
        boolean bl = false;
        String string3 = System.getProperty(string);
        if (string3 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                if (!string2.equals(stringTokenizer.nextToken().trim())) continue;
                bl = true;
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bl;
    }

    private static final void dlog(String string) {
        if (debug) {
            JMSXAWrappedXAResourceImpl.log("Info:", string);
        }
    }

    private static final void dlogStack(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
    }

    private static final void log(String string, Exception exception) {
        JMSXAWrappedXAResourceImpl.log(string, exception.getMessage());
        exception.printStackTrace();
    }

    private static final void log(String string, String string2) {
        System.out.println(string + " " + "JMSXAWrappedXAResource: " + string2);
    }
}

