/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.QueueBrowserImpl;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

class BrowserConsumer
extends Consumer
implements Enumeration,
Traceable {
    protected SessionImpl session = null;
    protected QueueBrowserImpl browser = null;
    protected ReceiveQueue receiveQueue = null;
    private long browseTimeout = 60000L;
    private int browseChunkLimit = 1000;
    private SysMessageID[] messageIDs = null;
    private int cursor = 0;
    private int cursorEnd = 0;
    private int waitCounter = 0;

    public BrowserConsumer(QueueBrowserImpl queueBrowserImpl, Destination destination) throws JMSException {
        this(queueBrowserImpl, destination, null);
    }

    public BrowserConsumer(QueueBrowserImpl queueBrowserImpl, Destination destination, String string) throws JMSException {
        super(queueBrowserImpl.getSession().getConnection(), destination, string, false);
        this.browser = queueBrowserImpl;
        this.session = queueBrowserImpl.getSession();
        try {
            this.browseTimeout = Long.parseLong(this.session.getConnection().getProperty("imqQueueBrowserRetrieveTimeout"));
            this.browseChunkLimit = Integer.parseInt(this.session.getConnection().getProperty("imqQueueBrowserMaxMessagesPerRetrieve"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.init();
    }

    private void init() throws JMSException {
        this.receiveQueue = new ReceiveQueue();
        this.messageIDs = this.session.getMessageIdSet(this);
        this.cursorEnd = this.messageIDs.length - 1;
        this.cursor = 0;
        this.addInterest();
        this.waitCounter = 0;
        this.moreMessage();
    }

    private void addInterest() {
        this.connection.addLocalInterest(this);
    }

    private void removeInterest() {
        this.connection.removeLocalInterest(this);
        this.session.removeBrowserConsumer(this);
        FlowControl flowControl = this.connection.getReadChannel().flowControl;
        flowControl.removeConsumerFlowControl(this);
    }

    protected Long getReadQueueId() {
        return this.session.getSessionId();
    }

    protected void onMessage(MessageImpl messageImpl) throws JMSException {
        if (this.receiveQueue.getIsClosed()) {
            return;
        }
        this.receiveQueue.enqueueNotify(messageImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receive(long l) throws JMSException {
        MessageImpl messageImpl = null;
        try {
            messageImpl = (MessageImpl)this.receiveQueue.dequeueWait(l);
            if (messageImpl != null) {
                messageImpl.setIsBrowserMsg(true);
            }
        }
        finally {
            this.receiveQueue.setReceiveInProcess(false);
        }
        return messageImpl;
    }

    private void moreMessage() throws JMSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(36);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        boolean bl = false;
        SysMessageID sysMessageID = null;
        while (!bl && this.cursor <= this.cursorEnd) {
            int n;
            for (n = 0; this.cursor <= this.cursorEnd && n < this.browseChunkLimit; ++n) {
                sysMessageID = this.messageIDs[this.cursor];
                try {
                    sysMessageID.writeID(dataOutputStream);
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException((Exception)iOException, "C4038");
                }
                ++this.cursor;
            }
            if (n <= 0) continue;
            try {
                dataOutputStream.flush();
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4038");
            }
            bl = this.session.requestMessages(byteArrayOutputStream, this);
            byteArrayOutputStream.reset();
        }
        if (bl) {
            ++this.waitCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        if (this.receiveQueue.getIsClosed()) {
            String string = AdministeredObject.cr.getKString("C4046");
            throw new NoSuchElementException(string);
        }
        BrowserConsumer browserConsumer = this;
        synchronized (browserConsumer) {
            return this.waitCounter != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        Message message = null;
        Object object = this;
        synchronized (object) {
            if (!this.hasMoreElements()) {
                String string = AdministeredObject.cr.getKString("C4045");
                throw new NoSuchElementException(string);
            }
            try {
                message = this.receive(this.browseTimeout);
                if (message != null && this.isLast((MessageImpl)message)) {
                    --this.waitCounter;
                    this.moreMessage();
                }
            }
            catch (JMSException jMSException) {
                this.close();
                throw new NoSuchElementException(jMSException.getMessage());
            }
        }
        if (message == null) {
            if (this.receiveQueue.getIsClosed()) {
                object = AdministeredObject.cr.getKString("C4046");
                throw new NoSuchElementException((String)object);
            }
            this.close();
            object = AdministeredObject.cr.getKString("C4044");
            throw new NoSuchElementException((String)object);
        }
        return message;
    }

    private boolean isLast(MessageImpl messageImpl) {
        return messageImpl.getPacket().getIsLast();
    }

    protected QueueBrowserImpl getBrowser() {
        return this.browser;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected void close() {
        if (this.receiveQueue.getIsClosed()) {
            return;
        }
        this.receiveQueue.close();
        this.removeInterest();
        if (this.debug) {
            Debug.println("browser consumer closed ...");
            Debug.println(this);
        }
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ BrowserConsumer dump ------");
        printStream.println("Interest ID: " + this.getInterestId());
        printStream.println("destination: " + this.getDestination());
        printStream.println("selector: " + this.messageSelector);
        printStream.println("waitCounter: " + this.waitCounter);
        if (this.receiveQueue != null) {
            this.receiveQueue.dump(printStream);
        } else {
            printStream.println("receiveQueue is null.");
        }
    }
}

