/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel;

import com.sun.messaging.jmq.transport.httptunnel.ExtHttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDefaults;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDriver;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelTimerTask;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.TimerTask;
import java.util.Vector;

public class HttpTunnelConnection
implements HttpTunnelDefaults {
    private HttpTunnelDriver wire;
    private int connId;
    private int nextRecvSeq;
    private int rxWindowMax;
    private HttpTunnelPacket[] recvQ;
    private Object recvQLock;
    private int readOffset;
    private boolean sendWindowUpdate;
    private boolean connCloseReceived;
    private boolean connAbortReceived;
    private int rxConnCloseSeq;
    private int lastAckSeq;
    private int nextSendSeq;
    private int txWindowMax;
    private int dupAckCount;
    private Vector sendQ;
    private Object sendQLock;
    private boolean txDataDisabled;
    private boolean connCloseSent;
    private int txConnCloseSeq;
    private Hashtable rexmitTable;
    private long RTO;
    private long measuredRTO;
    private int pullPeriod;
    private int connectionTimeout;
    private int nRetransmit;
    private int nFastRetransmit;
    private static MQTimer timer = new MQTimer(true);
    private static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    private static long CLOSE_WAIT_TIMEOUT = Long.getLong("imq.httptunnel.close_wait", 60000L);
    private String remoteip = null;
    Random r = new Random();
    int total = 0;
    int drop = 0;
    static final int ERRORRATE = -1;

    public HttpTunnelConnection(int n, HttpTunnelDriver httpTunnelDriver) {
        this.wire = httpTunnelDriver;
        this.connId = n;
        this.nextRecvSeq = 0;
        this.rxWindowMax = 64;
        this.recvQ = new HttpTunnelPacket[64];
        this.recvQLock = new Object();
        this.readOffset = 0;
        this.sendWindowUpdate = false;
        this.connCloseReceived = false;
        this.connAbortReceived = false;
        this.rxConnCloseSeq = 0;
        this.lastAckSeq = -1;
        this.nextSendSeq = 0;
        this.txWindowMax = 16;
        this.dupAckCount = 0;
        this.sendQ = new Vector();
        this.sendQLock = new Object();
        this.txDataDisabled = false;
        this.connCloseSent = false;
        this.txConnCloseSeq = 0;
        this.rexmitTable = new Hashtable();
        this.RTO = 15000L;
        this.measuredRTO = 15000L;
        this.pullPeriod = -1;
        this.connectionTimeout = -1;
        this.nRetransmit = 0;
        this.nFastRetransmit = 0;
        TimerTask timerTask = new TimerTask(){

            public void run() {
            }
        };
        try {
            timer.schedule(timerTask, 1000L);
            timerTask.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            timer = new MQTimer(true);
        }
    }

    public void setRemoteAddr(String string) {
        this.remoteip = string;
    }

    public String getRemoteAddr() {
        return this.remoteip;
    }

    private boolean checkRange(int n, int n2, int n3) {
        if (n < n2) {
            return n3 >= n && n3 <= n2;
        }
        if (n > n2) {
            return n3 >= n || n3 <= n2;
        }
        return n == n3;
    }

    public void receivePacket(HttpTunnelPacket httpTunnelPacket, boolean bl) {
        int n = httpTunnelPacket.getPacketType();
        if (n == 4) {
            this.receiveData(httpTunnelPacket, bl);
        } else {
            this.receiveAck(httpTunnelPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveData(HttpTunnelPacket httpTunnelPacket, boolean bl) {
        int n = httpTunnelPacket.getSequence();
        boolean bl2 = true;
        Object object = this.recvQLock;
        synchronized (object) {
            if (httpTunnelPacket.getPacketType() == 5) {
                this.connCloseReceived = true;
                this.rxConnCloseSeq = n;
            }
            if (this.recvQ == null) {
                if (this.connCloseReceived) {
                    this.flushAndClose();
                }
                return;
            }
            if (this.checkRange(this.nextRecvSeq, this.nextRecvSeq + this.rxWindowMax - 1, n)) {
                if (this.connCloseReceived && httpTunnelPacket.getPacketType() == 4 && this.checkRange(this.rxConnCloseSeq, this.rxConnCloseSeq + this.rxWindowMax - 1, n)) {
                    return;
                }
                int n2 = this.nextRecvSeq;
                if (this.recvQ[0] != null) {
                    n2 = this.recvQ[0].getSequence();
                }
                this.recvQ[n - n2] = httpTunnelPacket;
                if (n == this.nextRecvSeq) {
                    int n3;
                    for (n3 = 0; n3 < this.recvQ.length && this.recvQ[n3] != null; ++n3) {
                    }
                    this.nextRecvSeq = n2 + n3;
                    this.rxWindowMax = this.recvQ.length - n3;
                    this.recvQLock.notify();
                    boolean bl3 = bl2 = !bl;
                }
            }
            if (bl2) {
                this.sendAck();
            }
        }
    }

    private void sendAck() {
        if (this.connAbortReceived) {
            return;
        }
        int n = this.nextRecvSeq - 1;
        HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
        httpTunnelPacket.setPacketType(6);
        httpTunnelPacket.setPacketBody(null);
        httpTunnelPacket.setConnId(this.connId);
        httpTunnelPacket.setSequence(n);
        httpTunnelPacket.setWinsize(this.rxWindowMax);
        httpTunnelPacket.setChecksum(0);
        this.wire.sendPacket(httpTunnelPacket);
        if (this.connCloseReceived && this.rxConnCloseSeq == n) {
            this.wire.shutdown(this.connId);
        }
        this.sendWindowUpdate = !this.connCloseReceived && this.rxWindowMax == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRetransmitTimer(int n) {
        HttpTunnelTimerTask httpTunnelTimerTask = new HttpTunnelTimerTask(this, n);
        Hashtable hashtable = this.rexmitTable;
        synchronized (hashtable) {
            this.rexmitTable.put(Integer.toString(n), httpTunnelTimerTask);
            timer.schedule((TimerTask)httpTunnelTimerTask, this.RTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRetransmitTimer(int n) {
        HttpTunnelTimerTask httpTunnelTimerTask = null;
        Hashtable hashtable = this.rexmitTable;
        synchronized (hashtable) {
            httpTunnelTimerTask = (HttpTunnelTimerTask)this.rexmitTable.remove(Integer.toString(n));
            if (httpTunnelTimerTask != null) {
                httpTunnelTimerTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRetransmitTimers() {
        Hashtable hashtable = this.rexmitTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.rexmitTable.elements();
            while (enumeration.hasMoreElements()) {
                ((HttpTunnelTimerTask)enumeration.nextElement()).cancel();
            }
            this.rexmitTable.clear();
        }
    }

    private boolean dropPacket(ExtHttpTunnelPacket extHttpTunnelPacket) {
        ++this.total;
        if ((int)(this.r.nextFloat() * 100.0f) < -1) {
            ++this.drop;
            if (this.drop % 100 == 0) {
                System.out.println("Packet drop rate : " + this.drop * 100 / this.total + " %");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(ExtHttpTunnelPacket extHttpTunnelPacket) throws IOException {
        Object object = this.sendQLock;
        synchronized (object) {
            if (this.txDataDisabled) {
                throw new IOException("Connection closed.");
            }
            if (this.sendQ == null) {
                if (extHttpTunnelPacket.getPacketType() == 5) {
                    return;
                }
                if (this.connCloseReceived) {
                    throw new IOException("Broken pipe.");
                }
                throw new IOException("Connection closed.");
            }
            int n = this.nextSendSeq++;
            extHttpTunnelPacket.setSequence(n);
            long l = -1L;
            while (this.txWindowMax == 0 || !this.checkRange(this.lastAckSeq + 1, this.lastAckSeq + this.txWindowMax, n)) {
                if (l == -1L) {
                    l = System.currentTimeMillis();
                }
                try {
                    this.sendQLock.wait(180000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.sendQ == null) {
                    throw new IOException("Broken pipe.");
                }
                if (this.txWindowMax != 0 || System.currentTimeMillis() - l < 180000L) continue;
                extHttpTunnelPacket.setDirtyFlag(true);
                this.wire.sendPacket(extHttpTunnelPacket);
                l = -1L;
            }
            this.sendQ.addElement(extHttpTunnelPacket);
            if (extHttpTunnelPacket.getPacketType() == 5) {
                this.txDataDisabled = true;
                this.connCloseSent = true;
                this.txConnCloseSeq = n;
            }
        }
        extHttpTunnelPacket.setTxTime(System.currentTimeMillis());
        this.startRetransmitTimer(extHttpTunnelPacket.getSequence());
        this.wire.sendPacket(extHttpTunnelPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retransmitPacket(int n, boolean bl) {
        ExtHttpTunnelPacket extHttpTunnelPacket = null;
        boolean bl2 = false;
        Object object = this.sendQLock;
        synchronized (object) {
            int n2;
            if (this.sendQ == null) {
                return;
            }
            if (this.sendQ.size() == 0) {
                return;
            }
            int n3 = ((HttpTunnelPacket)this.sendQ.elementAt(0)).getSequence();
            if (!this.checkRange(n3, n2 = n3 + this.sendQ.size() - 1, n)) {
                return;
            }
            extHttpTunnelPacket = (ExtHttpTunnelPacket)this.sendQ.elementAt(n - n3);
            extHttpTunnelPacket.setDirtyFlag(true);
            if (n3 == n) {
                bl2 = true;
            }
        }
        if (bl) {
            this.startRetransmitTimer(extHttpTunnelPacket.getSequence());
        }
        if (bl2) {
            int n4 = extHttpTunnelPacket.getRetransmitCount();
            extHttpTunnelPacket.setRetransmitCount(n4 + 1);
            this.wire.sendPacket(extHttpTunnelPacket);
            if (bl && extHttpTunnelPacket.getRetransmitCount() > 1) {
                this.RTO <<= 1;
                if (this.RTO > 180000L) {
                    this.RTO = 180000L;
                }
            }
            if (bl) {
                ++this.nRetransmit;
            } else {
                ++this.nFastRetransmit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAck(HttpTunnelPacket httpTunnelPacket) {
        int n = httpTunnelPacket.getSequence();
        Object object = this.sendQLock;
        synchronized (object) {
            if (this.sendQ == null) {
                return;
            }
            if (this.connCloseSent && this.txConnCloseSeq == n) {
                this.txShutdown();
                this.wire.shutdown(this.connId);
                return;
            }
            if (this.sendQ.size() > 0) {
                int n2;
                int n3 = ((HttpTunnelPacket)this.sendQ.elementAt(0)).getSequence();
                if (this.checkRange(n3, n2 = n3 + this.sendQ.size() - 1, n)) {
                    ExtHttpTunnelPacket extHttpTunnelPacket;
                    do {
                        extHttpTunnelPacket = (ExtHttpTunnelPacket)this.sendQ.elementAt(0);
                        this.sendQ.removeElementAt(0);
                        this.stopRetransmitTimer(extHttpTunnelPacket.getSequence());
                    } while (extHttpTunnelPacket.getSequence() != n);
                    if (!extHttpTunnelPacket.getDirtyFlag()) {
                        this.updateRTO(extHttpTunnelPacket);
                    }
                    this.dupAckCount = 0;
                    this.RTO = this.measuredRTO;
                } else if (n == n3 - 1) {
                    ++this.dupAckCount;
                    if (this.dupAckCount == 3) {
                        this.retransmitPacket(n3, false);
                    }
                }
            }
            this.lastAckSeq = n;
            this.txWindowMax = httpTunnelPacket.getWinsize();
            this.sendQLock.notify();
        }
    }

    private void updateRTO(ExtHttpTunnelPacket extHttpTunnelPacket) {
        this.measuredRTO >>= 1;
        long l = System.currentTimeMillis() - extHttpTunnelPacket.getTxTime();
        long l2 = (this.measuredRTO << 3) - this.measuredRTO + l >>> 3;
        this.measuredRTO = l2 << 1;
        if (this.measuredRTO < 1000L) {
            this.measuredRTO = 1000L;
        }
    }

    public int readData(byte[] byArray) throws IOException {
        return this.readData(byArray, 0, byArray.length);
    }

    private void discardPackets(int n) {
        System.arraycopy(this.recvQ, n, this.recvQ, 0, this.recvQ.length - n);
        for (int i = this.recvQ.length - n; i < this.recvQ.length; ++i) {
            this.recvQ[i] = null;
        }
        this.rxWindowMax += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.recvQLock;
        synchronized (object) {
            int n4;
            while (true) {
                if (this.recvQ == null) {
                    if (this.connCloseReceived) {
                        throw new IOException("Connection reset by peer.");
                    }
                    throw new IOException("Connection closed.");
                }
                if (this.recvQ[0] != null) {
                    n4 = this.recvQ[0].getPacketType();
                    if (n4 == 4 || n4 == 5) break;
                    this.discardPackets(1);
                    bl2 = true;
                    continue;
                }
                try {
                    this.recvQLock.wait();
                }
                catch (Exception exception) {}
            }
            n4 = 0;
            while (n4 < this.recvQ.length && this.recvQ[n4] != null && n3 < n2) {
                HttpTunnelPacket httpTunnelPacket = this.recvQ[n4];
                if (httpTunnelPacket.getPacketType() == 5) {
                    bl = true;
                    ++n4;
                    continue;
                }
                if (httpTunnelPacket.getPacketType() == 10) {
                    ++n4;
                    continue;
                }
                int n5 = httpTunnelPacket.getPacketDataSize() - this.readOffset;
                if (n5 > n2 - n3) {
                    n5 = n2 - n3;
                }
                if (byArray != null) {
                    System.arraycopy(httpTunnelPacket.getPacketBody(), this.readOffset, byArray, n, n5);
                }
                this.readOffset += n5;
                n += n5;
                n3 += n5;
                if (this.readOffset != httpTunnelPacket.getPacketDataSize()) continue;
                this.readOffset = 0;
                ++n4;
            }
            if (bl) {
                this.rxShutdown();
            } else {
                if (n4 > 0) {
                    this.discardPackets(n4);
                    bl2 = true;
                }
                if (bl2 && this.sendWindowUpdate) {
                    this.sendAck();
                }
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.recvQLock;
        synchronized (object) {
            int n = 0;
            if (this.recvQ == null || this.recvQ[0] == null) {
                return 0;
            }
            if (this.recvQ[0].getPacketType() == 4) {
                n += this.recvQ[0].getPacketDataSize() - this.readOffset;
            }
            for (int i = 1; i < this.recvQ.length && this.recvQ[i] != null; ++i) {
                if (this.recvQ[i].getPacketType() != 4) continue;
                n += this.recvQ[i].getPacketDataSize();
            }
            return n;
        }
    }

    public void writeData(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        ExtHttpTunnelPacket extHttpTunnelPacket = new ExtHttpTunnelPacket();
        extHttpTunnelPacket.setPacketType(4);
        extHttpTunnelPacket.setPacketBody(byArray);
        extHttpTunnelPacket.setConnId(this.connId);
        extHttpTunnelPacket.setWinsize(0);
        extHttpTunnelPacket.setChecksum(0);
        this.sendData(extHttpTunnelPacket);
    }

    private void flushAndClose() {
        this.nextRecvSeq = this.rxConnCloseSeq + 1;
        this.sendAck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConn() throws IOException {
        boolean bl = true;
        Object object = this.recvQLock;
        synchronized (object) {
            if (this.connCloseReceived) {
                this.flushAndClose();
                bl = false;
            }
        }
        object = this.sendQLock;
        synchronized (object) {
            this.rxShutdown();
            if (bl) {
                ExtHttpTunnelPacket extHttpTunnelPacket = new ExtHttpTunnelPacket();
                extHttpTunnelPacket.setPacketType(5);
                extHttpTunnelPacket.setPacketBody(null);
                extHttpTunnelPacket.setConnId(this.connId);
                extHttpTunnelPacket.setWinsize(0);
                extHttpTunnelPacket.setChecksum(0);
                this.sendData(extHttpTunnelPacket);
            }
            long l = System.currentTimeMillis();
            while (this.sendQ != null && this.sendQ.size() > 1) {
                try {
                    this.sendQLock.wait(CLOSE_WAIT_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.sendQ != null) {
                    this.sendQLock.notify();
                }
                if (System.currentTimeMillis() - l <= CLOSE_WAIT_TIMEOUT) continue;
            }
        }
    }

    public int getConnId() {
        return this.connId;
    }

    public int getPullPeriod() {
        return this.pullPeriod;
    }

    public void setPullPeriod(int n) throws IOException {
        if (this.pullPeriod == n) {
            return;
        }
        this.pullPeriod = n;
        ExtHttpTunnelPacket extHttpTunnelPacket = new ExtHttpTunnelPacket();
        extHttpTunnelPacket.setPacketType(10);
        extHttpTunnelPacket.setConnId(this.connId);
        extHttpTunnelPacket.setWinsize(0);
        extHttpTunnelPacket.setChecksum(0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        extHttpTunnelPacket.setPacketBody(byArray);
        this.sendData(extHttpTunnelPacket);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) throws IOException {
        if (this.connectionTimeout == n) {
            return;
        }
        this.connectionTimeout = n;
        ExtHttpTunnelPacket extHttpTunnelPacket = new ExtHttpTunnelPacket();
        extHttpTunnelPacket.setPacketType(10);
        extHttpTunnelPacket.setConnId(this.connId);
        extHttpTunnelPacket.setWinsize(0);
        extHttpTunnelPacket.setChecksum(0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        extHttpTunnelPacket.setPacketBody(byArray);
        this.sendData(extHttpTunnelPacket);
    }

    public void handleConnOption(HttpTunnelPacket httpTunnelPacket) {
        byte[] byArray = httpTunnelPacket.getPacketBody();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            switch (n) {
                case 1: {
                    this.pullPeriod = dataInputStream.readInt();
                    break;
                }
                case 2: {
                    this.connectionTimeout = dataInputStream.readInt();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receiveData(httpTunnelPacket, false);
    }

    public void handleClose(HttpTunnelPacket httpTunnelPacket) {
        this.txShutdown();
        this.receiveData(httpTunnelPacket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAbort(HttpTunnelPacket httpTunnelPacket) {
        Object object = this.recvQLock;
        synchronized (object) {
            if (this.connAbortReceived) {
                return;
            }
            this.connAbortReceived = true;
            httpTunnelPacket.setPacketType(5);
            httpTunnelPacket.setSequence(this.nextRecvSeq);
            this.handleClose(httpTunnelPacket);
            this.wire.shutdown(this.connId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rxShutdown() {
        Object object = this.recvQLock;
        synchronized (object) {
            this.recvQ = null;
            this.recvQLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txShutdown() {
        Object object = this.sendQLock;
        synchronized (object) {
            this.stopRetransmitTimers();
            this.sendQ = null;
            this.sendQLock.notifyAll();
        }
    }

    public Vector getStats() {
        if (this.sendQ == null && this.recvQ == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("connId = " + this.connId);
        vector.addElement("RX.nextRecvSeq = " + this.nextRecvSeq);
        vector.addElement("RX.rxWindowMax = " + this.rxWindowMax);
        vector.addElement("RX.rxConnCloseSeq = " + this.rxConnCloseSeq);
        vector.addElement("sendWindowUpdate = " + this.sendWindowUpdate);
        vector.addElement("connCloseReceived = " + this.connCloseReceived);
        vector.addElement("connAbortReceived = " + this.connAbortReceived);
        vector.addElement("TX.lastAckSeq = " + this.lastAckSeq);
        vector.addElement("TX.nextSendSeq = " + this.nextSendSeq);
        vector.addElement("TX.txWindowMax = " + this.txWindowMax);
        vector.addElement("TX.dupAckCount = " + this.dupAckCount);
        vector.addElement("TX.txConnCloseSeq = " + this.txConnCloseSeq);
        vector.addElement("txDataDisabled = " + this.txDataDisabled);
        vector.addElement("connCloseSent = " + this.connCloseSent);
        vector.addElement("RTO = " + this.RTO);
        vector.addElement("measuredRTO = " + this.measuredRTO);
        vector.addElement("TX.nRetransmit = " + this.nRetransmit);
        vector.addElement("TX.nFastRetransmit = " + this.nFastRetransmit);
        return vector;
    }

    public Hashtable getDebugState() {
        Hashtable hashtable = this.wire.getDebugState();
        hashtable.put("connId", String.valueOf(this.connId));
        hashtable.put("RX.nextRecvSeq", String.valueOf(this.nextRecvSeq));
        hashtable.put("RX.rxWindowMax", String.valueOf(this.rxWindowMax));
        hashtable.put("RX.rxConnCloseSeq", String.valueOf(this.rxConnCloseSeq));
        hashtable.put("sendWindowUpdate", String.valueOf(this.sendWindowUpdate));
        hashtable.put("connCloseReceived", String.valueOf(this.connCloseReceived));
        hashtable.put("connAbortReceived", String.valueOf(this.connAbortReceived));
        hashtable.put("TX.lastAckSeq", String.valueOf(this.lastAckSeq));
        hashtable.put("TX.nextSendSeq", String.valueOf(this.nextSendSeq));
        hashtable.put("TX.txWindowMax", String.valueOf(this.txWindowMax));
        hashtable.put("TX.dupAckCount", String.valueOf(this.dupAckCount));
        hashtable.put("TX.txConnCloseSeq", String.valueOf(this.txConnCloseSeq));
        hashtable.put("txDataDisabled", String.valueOf(this.txDataDisabled));
        hashtable.put("connCloseSent", String.valueOf(this.connCloseSent));
        hashtable.put("RTO", String.valueOf(this.RTO));
        hashtable.put("measuredRTO", String.valueOf(this.measuredRTO));
        hashtable.put("TX.nRetransmit", String.valueOf(this.nRetransmit));
        hashtable.put("TX.nFastRetransmit", String.valueOf(this.nFastRetransmit));
        return hashtable;
    }
}

