/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.Queue;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.Topic;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.apps.console.AController;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObjStoreManager;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAddDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryAddDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestAddDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestPropsDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStorePasswdDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStorePropsDialog;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.objstore.AuthenticationException;
import com.sun.messaging.jmq.admin.objstore.NameAlreadyExistsException;
import com.sun.messaging.jmq.admin.objstore.NameNotFoundException;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public class ObjAdminHandler
implements AdminEventListener {
    private static String OBJSTORELIST_FILENAME = "objstorelist.properties";
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private AdminApp app;
    private AController controller;
    private ObjStoreAddDialog objStoreAddDialog = null;
    private ObjStorePropsDialog objStorePropsDialog = null;
    private ObjStorePasswdDialog objStorePasswdDialog = null;
    private ObjStoreDestAddDialog objStoreDestAddDialog = null;
    private ObjStoreDestPropsDialog objStoreDestPropsDialog = null;
    private ObjStoreConFactoryAddDialog objStoreConFactoryAddDialog = null;
    private ObjStoreConFactoryPropsDialog objStoreConFactoryPropsDialog = null;

    public ObjAdminHandler(AdminApp adminApp, AController aController) {
        this.app = adminApp;
        this.controller = aController;
    }

    public void init() {
        this.loadObjStoreList();
    }

    public void adminEventDispatched(AdminEvent adminEvent) {
        if (adminEvent instanceof DialogEvent) {
            this.handleDialogEvents((DialogEvent)adminEvent);
        } else if (adminEvent instanceof ObjAdminEvent) {
            this.handleObjAdminEvents((ObjAdminEvent)adminEvent);
        }
    }

    public void handleDialogEvents(DialogEvent dialogEvent) {
        ConsoleObj consoleObj = this.app.getSelectedObj();
        int n = dialogEvent.getDialogType();
        switch (n) {
            case 0: {
                ObjStore objStore;
                if (consoleObj instanceof ObjStoreListCObj) {
                    if (this.objStoreAddDialog == null) {
                        this.objStoreAddDialog = new ObjStoreAddDialog(this.app.getFrame(), (ObjStoreListCObj)consoleObj);
                        this.objStoreAddDialog.addAdminEventListener(this);
                        this.objStoreAddDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    this.objStoreAddDialog.show();
                    break;
                }
                if (consoleObj instanceof ObjStoreDestListCObj) {
                    ObjStore objStore2;
                    if (this.objStoreDestAddDialog == null) {
                        this.objStoreDestAddDialog = new ObjStoreDestAddDialog(this.app.getFrame());
                        this.objStoreDestAddDialog.addAdminEventListener(this);
                        this.objStoreDestAddDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!(objStore2 = ((ObjStoreDestListCObj)consoleObj).getObjStore()).isOpen()) {
                        JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", objStore2.getID()), acr.getString("A1129") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                    }
                    this.objStoreDestAddDialog.show((ObjStoreDestListCObj)consoleObj);
                    break;
                }
                if (!(consoleObj instanceof ObjStoreConFactoryListCObj)) break;
                if (this.objStoreConFactoryAddDialog == null) {
                    this.objStoreConFactoryAddDialog = new ObjStoreConFactoryAddDialog(this.app.getFrame());
                    this.objStoreConFactoryAddDialog.addAdminEventListener(this);
                    this.objStoreConFactoryAddDialog.setLocationRelativeTo(this.app.getFrame());
                }
                if (!(objStore = ((ObjStoreConFactoryListCObj)consoleObj).getObjStore()).isOpen()) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", objStore.getID()), acr.getString("A1130") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                    return;
                }
                this.objStoreConFactoryAddDialog.show((ObjStoreConFactoryListCObj)consoleObj);
                break;
            }
            case 1: {
                if (consoleObj instanceof ObjStoreCObj) {
                    this.doDeleteObjStore(consoleObj);
                    break;
                }
                if (consoleObj instanceof ObjStoreDestCObj) {
                    this.doDeleteDestination(consoleObj);
                    break;
                }
                if (!(consoleObj instanceof ObjStoreConFactoryCObj)) break;
                this.doDeleteConnFactory(consoleObj);
                break;
            }
            case 3: {
                ObjStore objStore;
                if (consoleObj instanceof ObjStoreCObj) {
                    if (this.objStorePropsDialog == null) {
                        ObjStoreCObj objStoreCObj = (ObjStoreCObj)consoleObj;
                        ObjStoreListCObj objStoreListCObj = (ObjStoreListCObj)objStoreCObj.getParent();
                        this.objStorePropsDialog = new ObjStorePropsDialog(this.app.getFrame(), objStoreListCObj);
                        this.objStorePropsDialog.addAdminEventListener(this);
                        this.objStorePropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    this.objStorePropsDialog.show((ObjStoreCObj)consoleObj);
                    break;
                }
                if (consoleObj instanceof ObjStoreDestCObj) {
                    ObjStore objStore3;
                    if (this.objStoreDestPropsDialog == null) {
                        this.objStoreDestPropsDialog = new ObjStoreDestPropsDialog(this.app.getFrame());
                        this.objStoreDestPropsDialog.addAdminEventListener(this);
                        this.objStoreDestPropsDialog.setLocationRelativeTo(this.app.getFrame());
                    }
                    if (!(objStore3 = ((ObjStoreDestCObj)consoleObj).getObjStore()).isOpen()) {
                        JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", objStore3.getID()), acr.getString("A1300") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                        return;
                    }
                    this.objStoreDestPropsDialog.show((ObjStoreDestCObj)consoleObj);
                    break;
                }
                if (!(consoleObj instanceof ObjStoreConFactoryCObj)) break;
                if (this.objStoreConFactoryPropsDialog == null) {
                    this.objStoreConFactoryPropsDialog = new ObjStoreConFactoryPropsDialog(this.app.getFrame());
                    this.objStoreConFactoryPropsDialog.addAdminEventListener(this);
                    this.objStoreConFactoryPropsDialog.setLocationRelativeTo(this.app.getFrame());
                }
                if (!(objStore = ((ObjStoreConFactoryCObj)consoleObj).getObjStore()).isOpen()) {
                    JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", objStore.getID()), acr.getString("A1301") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
                    return;
                }
                this.objStoreConFactoryPropsDialog.show((ObjStoreConFactoryCObj)consoleObj);
                break;
            }
            case 8: {
                if (!(consoleObj instanceof ObjStoreCObj)) break;
                this.doConnectObjStore(consoleObj);
                break;
            }
            case 9: {
                if (!(consoleObj instanceof ObjStoreCObj)) break;
                this.doDisconnectObjStore(consoleObj);
                break;
            }
            case 10: {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A1222"), acr.getString("A1223"), 0, 1, null, close, close[0]);
                break;
            }
        }
    }

    public void handleObjAdminEvents(ObjAdminEvent objAdminEvent) {
        ConsoleObj consoleObj = this.app.getSelectedObj();
        int n = objAdminEvent.getType();
        switch (n) {
            case 1: {
                this.doAddObjStore(objAdminEvent, consoleObj);
                break;
            }
            case 2: {
                this.doUpdateObjStore(objAdminEvent, consoleObj);
                break;
            }
            case 4: {
                this.doAddDestination(objAdminEvent, consoleObj);
                break;
            }
            case 5: {
                this.doUpdateDestination(objAdminEvent, consoleObj);
                break;
            }
            case 6: {
                this.doAddConnFactory(objAdminEvent, consoleObj);
                break;
            }
            case 7: {
                this.doUpdateConnFactory(objAdminEvent, consoleObj);
                break;
            }
            case 8: {
                this.doUpdateCredentials(objAdminEvent, consoleObj);
            }
        }
    }

    private void doAddObjStore(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        ObjStoreAttrs objStoreAttrs = objAdminEvent.getObjStoreAttrs();
        ObjStoreManager objStoreManager = this.app.getObjStoreListCObj().getObjStoreManager();
        boolean bl = objAdminEvent.isConnectAttempt();
        ObjStoreCObj objStoreCObj = null;
        ObjStore objStore = this.createStore(objStoreManager, objStoreAttrs, bl);
        if (objStore != null) {
            objStoreCObj = new ObjStoreCObj(objStore);
            if (objStore.isOpen()) {
                this.readObjStore(objStoreCObj, objStoreManager, objStore);
            }
        }
        if (objStoreCObj != null) {
            this.app.getExplorer().addObjStore(objStoreCObj);
            this.app.getInspector().refresh();
            this.app.getStatusArea().appendText(acr.getString("A6000", objStoreCObj.toString()));
        }
        if (objAdminEvent.isOKAction() && objStore != null) {
            this.objStoreAddDialog.hide();
        }
        this.saveObjStoreList();
    }

    private void doUpdateObjStore(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        String string;
        ObjStoreAttrs objStoreAttrs = objAdminEvent.getObjStoreAttrs();
        ObjStoreManager objStoreManager = this.app.getObjStoreListCObj().getObjStoreManager();
        boolean bl = objAdminEvent.isConnectAttempt();
        ObjStore objStore = ((ObjStoreCObj)consoleObj).getObjStore();
        ObjStore objStore2 = this.updateStore(objStore, string = objAdminEvent.getObjStoreID(), objStoreManager, objStoreAttrs, bl);
        if (objStore2 == null) {
            return;
        }
        if (objStore2.isOpen()) {
            this.readObjStore(consoleObj, objStoreManager, objStore2);
        }
        ((ObjStoreCObj)consoleObj).setObjStore(objStore2);
        ObjStoreDestListCObj objStoreDestListCObj = (ObjStoreDestListCObj)consoleObj.getChildAt(0);
        ObjStoreConFactoryListCObj objStoreConFactoryListCObj = (ObjStoreConFactoryListCObj)consoleObj.getChildAt(1);
        objStoreDestListCObj.setObjStore(objStore2);
        objStoreConFactoryListCObj.setObjStore(objStore2);
        this.app.getExplorer().nodeChanged(consoleObj);
        this.app.getStatusArea().appendText(acr.getString("A6001", consoleObj.toString()));
        this.app.getInspector().selectedObjectUpdated();
        this.controller.setActions(consoleObj);
        if (!bl) {
            this.clearStore(consoleObj);
        }
        if (objAdminEvent.isOKAction() && objStore2 != null) {
            this.objStorePropsDialog.hide();
        }
        this.saveObjStoreList();
    }

    private boolean readObjStore(ConsoleObj consoleObj, ObjStoreManager objStoreManager, ObjStore objStore) {
        ConsoleObj consoleObj2;
        Vector vector = null;
        try {
            vector = objStore.list();
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3007", objStore.getID(), exception.toString()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3007"), 0, 0, null, close, close[0]);
            try {
                objStore.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
        ObjStoreDestListCObj objStoreDestListCObj = (ObjStoreDestListCObj)consoleObj.getChildAt(0);
        ObjStoreConFactoryListCObj objStoreConFactoryListCObj = (ObjStoreConFactoryListCObj)consoleObj.getChildAt(1);
        Enumeration<TreeNode> enumeration = objStoreDestListCObj.children();
        while (enumeration.hasMoreElements()) {
            consoleObj2 = (ConsoleObj)enumeration.nextElement();
            this.app.getExplorer().removeFromParent(consoleObj2);
            enumeration = objStoreDestListCObj.children();
        }
        enumeration = objStoreConFactoryListCObj.children();
        while (enumeration.hasMoreElements()) {
            consoleObj2 = (ConsoleObj)enumeration.nextElement();
            this.app.getExplorer().removeFromParent(consoleObj2);
            enumeration = objStoreConFactoryListCObj.children();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ObjStoreAdminCObj objStoreAdminCObj;
            NameClassPair nameClassPair = (NameClassPair)vector.get(i);
            String string = nameClassPair.getName();
            Object object = null;
            try {
                object = objStore.retrieve(string);
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3037", string, objStore.getID()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3037"), 0, 0, null, close, close[0]);
                continue;
            }
            if (Topic.class.getName().equals(nameClassPair.getClassName()) || Queue.class.getName().equals(nameClassPair.getClassName())) {
                objStoreAdminCObj = new ObjStoreDestCObj((ObjStoreCObj)consoleObj, string, object);
                this.app.getExplorer().addToParent(objStoreDestListCObj, objStoreAdminCObj);
                continue;
            }
            if (!TopicConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !QueueConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !ConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !XATopicConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !XAQueueConnectionFactory.class.getName().equals(nameClassPair.getClassName()) && !XAConnectionFactory.class.getName().equals(nameClassPair.getClassName())) continue;
            objStoreAdminCObj = new ObjStoreConFactoryCObj((ObjStoreCObj)consoleObj, string, object);
            this.app.getExplorer().addToParent(objStoreConFactoryListCObj, objStoreAdminCObj);
        }
        return true;
    }

    private void clearStore(ConsoleObj consoleObj) {
        ConsoleObj consoleObj2;
        ObjStoreDestListCObj objStoreDestListCObj = (ObjStoreDestListCObj)consoleObj.getChildAt(0);
        ObjStoreConFactoryListCObj objStoreConFactoryListCObj = (ObjStoreConFactoryListCObj)consoleObj.getChildAt(1);
        Enumeration<TreeNode> enumeration = objStoreDestListCObj.children();
        while (enumeration.hasMoreElements()) {
            consoleObj2 = (ConsoleObj)enumeration.nextElement();
            this.app.getExplorer().removeFromParent(consoleObj2);
            enumeration = objStoreDestListCObj.children();
        }
        enumeration = objStoreConFactoryListCObj.children();
        while (enumeration.hasMoreElements()) {
            consoleObj2 = (ConsoleObj)enumeration.nextElement();
            this.app.getExplorer().removeFromParent(consoleObj2);
            enumeration = objStoreConFactoryListCObj.children();
        }
    }

    private ObjStore createStore(ObjStoreManager objStoreManager, ObjStoreAttrs objStoreAttrs, boolean bl) {
        ObjStore objStore = null;
        if (objStoreManager == null || objStoreAttrs == null) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3023"), acr.getString("A1088") + ": " + acr.getString("A1218", "A3023"), 0, 0, null, close, close[0]);
            return null;
        }
        try {
            objStore = objStoreManager.createStore(objStoreAttrs);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1088"), 0, 0, null, close, close[0]);
            return null;
        }
        if (bl) {
            try {
                if (objStore != null) {
                    objStore.open();
                }
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3008", exception.toString()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3008"), 0, 0, null, close, close[0]);
                objStore = null;
                try {
                    objStoreManager.destroyStore(objStoreAttrs.getID());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return objStore;
    }

    private ObjStore updateStore(ObjStore objStore, String string, ObjStoreManager objStoreManager, ObjStoreAttrs objStoreAttrs, boolean bl) {
        ObjStore objStore2 = null;
        boolean bl2 = false;
        if (objStoreManager == null || objStoreAttrs == null) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3023"), acr.getString("A1088") + ": " + acr.getString("A1218", "A3023"), 0, 0, null, close, close[0]);
            return null;
        }
        ObjStoreAttrs objStoreAttrs2 = objStore.getObjStoreAttrs();
        objStore2 = objStoreManager.getStore(objStore.getID());
        if (objStore2 == null) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3023"), acr.getString("A1088") + ": " + acr.getString("A1218", "A3023"), 0, 0, null, close, close[0]);
        }
        try {
            if (string != null && objStore2 != null && !string.equals(objStore2.getID())) {
                objStore2 = objStoreManager.createStore(objStoreAttrs);
                bl2 = true;
            } else if (objStore2 != null) {
                objStore2.setObjStoreAttrs(objStoreAttrs);
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1309"), 0, 0, null, close, close[0]);
            return null;
        }
        if (bl) {
            try {
                if (objStore2 != null) {
                    objStore2.open();
                }
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3008", exception.toString()), acr.getString("A1309") + ": " + acr.getString("A1218", "A3008"), 0, 0, null, close, close[0]);
                try {
                    if (bl2) {
                        objStoreManager.destroyStore(objStoreAttrs.getID());
                    } else {
                        objStore2.setObjStoreAttrs(objStoreAttrs2);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return null;
            }
        }
        if (objStore2 != null && bl2) {
            try {
                if (objStore.isOpen()) {
                    objStore.close();
                }
                objStoreManager.destroyStore(objStore.getID());
                if (!bl && objStore2.isOpen()) {
                    objStore2.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objStore2 != null && !bl && objStore2.isOpen()) {
            try {
                objStore2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objStore2;
    }

    private void doConnectObjStore(ConsoleObj consoleObj) {
        ObjStore objStore = ((ObjStoreCObj)consoleObj).getObjStore();
        if (objStore.isOpen()) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3009", consoleObj.toString()), acr.getString("A1140") + ": " + acr.getString("A1218", "A3009"), 0, 0, null, close, close[0]);
            return;
        }
        ObjStoreAttrs objStoreAttrs = objStore.getObjStoreAttrs();
        Vector vector = objStore.checkAuthentication(objStoreAttrs);
        int n = vector.size();
        boolean bl = false;
        if (vector != null && n > 0) {
            if (this.objStorePasswdDialog == null && n > 0) {
                this.objStorePasswdDialog = new ObjStorePasswdDialog(this.app.getFrame());
                this.objStorePasswdDialog.addAdminEventListener(this);
                this.objStorePasswdDialog.setLocationRelativeTo(this.app.getFrame());
            }
            if (n > 0) {
                this.objStorePasswdDialog.show(objStore, vector);
            }
        } else {
            boolean bl2 = this.finishDoConnectObjStore(consoleObj, objStore);
            if (bl2) {
                this.app.getStatusArea().appendText(acr.getString("A6002", consoleObj.toString()));
            }
        }
    }

    private boolean finishDoConnectObjStore(ConsoleObj consoleObj, ObjStore objStore) {
        try {
            objStore.open();
        }
        catch (AuthenticationException authenticationException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3024"), acr.getString("A1140") + ": " + acr.getString("A1218", "A3024"), 0, 0, null, close, close[0]);
            this.closeObjStore(objStore, consoleObj);
            return false;
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3011", consoleObj.toString(), exception.toString()), acr.getString("A1140") + ": " + acr.getString("A1218", "A3011"), 0, 0, null, close, close[0]);
            this.closeObjStore(objStore, consoleObj);
            return false;
        }
        ObjStoreManager objStoreManager = this.app.getObjStoreListCObj().getObjStoreManager();
        boolean bl = this.readObjStore(consoleObj, objStoreManager, objStore);
        if (bl) {
            this.app.getExplorer().nodeChanged(consoleObj);
            this.app.getInspector().selectedObjectUpdated();
            this.app.getInspector().refresh();
        }
        this.controller.setActions(consoleObj);
        return true;
    }

    private void doDisconnectObjStore(ConsoleObj consoleObj) {
        ObjStore objStore = ((ObjStoreCObj)consoleObj).getObjStore();
        if (!objStore.isOpen()) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3010", consoleObj.toString()), acr.getString("A1143") + ": " + acr.getString("A1218", "A3010"), 0, 0, null, close, close[0]);
            return;
        }
        try {
            if (objStore != null) {
                objStore.close();
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3012", consoleObj.toString()), acr.getString("A1143") + ": " + acr.getString("A1218", "A3012"), 0, 0, null, close, close[0]);
            return;
        }
        this.clearStore(consoleObj);
        this.app.getExplorer().nodeChanged(consoleObj);
        this.app.getStatusArea().appendText(acr.getString("A6003", consoleObj.toString()));
        this.app.getInspector().refresh();
        this.app.getInspector().selectedObjectUpdated();
        this.controller.setActions(consoleObj);
    }

    private void doDeleteObjStore(ConsoleObj consoleObj) {
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5000", consoleObj.toString()), acr.getString("A1134"), 0);
        if (n == 1) {
            return;
        }
        ObjStore objStore = ((ObjStoreCObj)consoleObj).getObjStore();
        try {
            objStore.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjStoreManager objStoreManager = this.app.getObjStoreListCObj().getObjStoreManager();
        try {
            objStoreManager.destroyStore(objStore.getID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.app.getExplorer().removeFromParent(consoleObj);
        this.app.getStatusArea().appendText(acr.getString("A6004", objStore.getID()));
        this.controller.clearSelection();
        this.saveObjStoreList();
    }

    private void doDeleteDestination(ConsoleObj consoleObj) {
        ObjStore objStore = ((ObjStoreDestCObj)consoleObj).getObjStore();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5001", consoleObj.toString(), objStore.getID()), acr.getString("A1135"), 0);
        if (n == 1) {
            return;
        }
        String string = consoleObj.toString();
        try {
            objStore.delete(string);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3013", consoleObj.toString(), exception.toString()), acr.getString("A1135") + ": " + acr.getString("A1218", "A3013"), 0, 0, null, close, close[0]);
            return;
        }
        this.app.getStatusArea().appendText(acr.getString("A6005", consoleObj.toString(), objStore.getID()));
        ObjStoreDestListCObj objStoreDestListCObj = (ObjStoreDestListCObj)consoleObj.getParent();
        this.app.getExplorer().removeFromParent(consoleObj);
        this.app.getExplorer().select(objStoreDestListCObj);
        this.app.getInspector().refresh();
    }

    private void doDeleteConnFactory(ConsoleObj consoleObj) {
        ObjStore objStore = ((ObjStoreConFactoryCObj)consoleObj).getObjStore();
        int n = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5003", consoleObj.toString(), objStore.getID()), acr.getString("A1136"), 0);
        if (n == 1) {
            return;
        }
        String string = consoleObj.toString();
        try {
            objStore.delete(string);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3017", consoleObj.toString(), exception.toString()), acr.getString("A1136") + ": " + acr.getString("A1218", "A3017"), 0, 0, null, close, close[0]);
            return;
        }
        this.app.getStatusArea().appendText(acr.getString("A6010", consoleObj.toString(), objStore.getID()));
        ObjStoreConFactoryListCObj objStoreConFactoryListCObj = (ObjStoreConFactoryListCObj)consoleObj.getParent();
        this.app.getExplorer().removeFromParent(consoleObj);
        this.app.getExplorer().select(objStoreConFactoryListCObj);
        this.app.getInspector().refresh();
    }

    private void doUpdateDestination(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        ObjStore objStore = objAdminEvent.getObjStore();
        String string = objAdminEvent.getLookupName();
        boolean bl = objAdminEvent.isReadOnly();
        Object object = ((ObjStoreDestCObj)consoleObj).getObject();
        Object object2 = this.updateObject(object, objAdminEvent.getDestinationType(), objAdminEvent.getObjProperties(), bl);
        if (object2 == null) {
            return;
        }
        try {
            objStore.add(string, object2, true);
        }
        catch (NameAlreadyExistsException nameAlreadyExistsException) {
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1300"), 0, 0, null, close, close[0]);
            return;
        }
        ((ObjStoreDestCObj)consoleObj).setObject(object2);
        this.app.getStatusArea().appendText(acr.getString("A6006", consoleObj.toString(), objStore.getID()));
        this.app.getInspector().selectedObjectUpdated();
        if (objAdminEvent.isOKAction()) {
            this.objStoreDestPropsDialog.hide();
        }
    }

    private Object updateObject(Object object, int n, Properties properties, boolean bl) {
        Object object2 = null;
        String string = "A1088";
        String string2 = null;
        string2 = bl ? "true" : "false";
        try {
            if (n == 1) {
                string = "A1300";
                object2 = JMSObjFactory.updateQueue(object, properties, string2);
            } else if (n == 2) {
                string = "A1300";
                object2 = JMSObjFactory.updateTopic(object, properties, string2);
            } else if (n == 3) {
                string = "A1301";
                object2 = JMSObjFactory.updateQueueConnectionFactory(object, properties, string2);
            } else if (n == 4) {
                string = "A1301";
                object2 = JMSObjFactory.updateTopicConnectionFactory(object, properties, string2);
            } else if (n == 7) {
                string = "A1301";
                object2 = JMSObjFactory.updateConnectionFactory(object, properties, string2);
            } else if (n == 5) {
                string = "A1301";
                object2 = JMSObjFactory.updateXAQueueConnectionFactory(object, properties, string2);
            } else if (n == 6) {
                string = "A1301";
                object2 = JMSObjFactory.updateXATopicConnectionFactory(object, properties, string2);
            } else if (n == 8) {
                string = "A1301";
                object2 = JMSObjFactory.updateXAConnectionFactory(object, properties, string2);
            }
        }
        catch (Exception exception) {
            this.handleExceptions(exception, string);
            return null;
        }
        return object2;
    }

    private void doUpdateCredentials(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        ObjStore objStore = objAdminEvent.getObjStore();
        boolean bl = this.finishDoConnectObjStore(consoleObj, objStore);
        if (bl) {
            this.app.getStatusArea().appendText(acr.getString("A6002", consoleObj.toString()));
        }
        ObjStoreAttrs objStoreAttrs = objAdminEvent.getObjStoreAttrs();
        Vector vector = objAdminEvent.getMissingAuthInfo();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            objStoreAttrs.remove(string);
        }
        try {
            objStore.setObjStoreAttrs(objStoreAttrs);
        }
        catch (ObjStoreException objStoreException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), objStoreException.toString(), acr.getString("A1088"), 0, 0, null, close, close[0]);
        }
        if (bl && objAdminEvent.isOKAction()) {
            this.objStorePasswdDialog.hide();
        }
    }

    private void doUpdateConnFactory(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        ObjStore objStore = objAdminEvent.getObjStore();
        String string = objAdminEvent.getLookupName();
        boolean bl = objAdminEvent.isReadOnly();
        Object object = ((ObjStoreConFactoryCObj)consoleObj).getObject();
        Object object2 = this.updateObject(object, objAdminEvent.getFactoryType(), objAdminEvent.getObjProperties(), bl);
        if (object2 == null) {
            return;
        }
        try {
            objStore.add(string, object2, true);
        }
        catch (NameAlreadyExistsException nameAlreadyExistsException) {
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1301"), 0, 0, null, close, close[0]);
            return;
        }
        ((ObjStoreConFactoryCObj)consoleObj).setObject(object2);
        this.app.getStatusArea().appendText(acr.getString("A6009", consoleObj.toString(), objStore.getID()));
        this.app.getInspector().selectedObjectUpdated();
        if (objAdminEvent.isOKAction()) {
            this.objStoreConFactoryPropsDialog.hide();
        }
    }

    private void doAddDestination(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        Object object = null;
        ObjStore objStore = objAdminEvent.getObjStore();
        int n = objAdminEvent.getDestinationType();
        String string = objAdminEvent.getLookupName();
        Properties properties = objAdminEvent.getObjProperties();
        boolean bl = objAdminEvent.isReadOnly();
        boolean bl2 = false;
        if (objStore.isOpen()) {
            Object object2 = null;
            try {
                if (n == 2) {
                    object2 = JMSObjFactory.createTopic(properties);
                } else if (n == 1) {
                    object2 = JMSObjFactory.createQueue(properties);
                }
            }
            catch (Exception exception) {
                this.handleExceptions(exception, "A1129");
                return;
            }
            if (bl) {
                JMSObjFactory.doReadOnlyForAdd(object2, "true");
            } else {
                JMSObjFactory.doReadOnlyForAdd(object2, "false");
            }
            try {
                object = objStore.retrieve(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1129"), 0, 0, null, close, close[0]);
                return;
            }
            if (object != null) {
                int n2 = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5002", string), acr.getString("A1129"), 0);
                if (n2 == 1) {
                    return;
                }
                bl2 = true;
            }
            try {
                objStore.add(string, object2, true);
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1129"), 0, 0, null, close, close[0]);
                return;
            }
            if (objStore != null) {
                if (bl2) {
                    this.removeChild(consoleObj, string);
                    this.removeChild((ConsoleObj)consoleObj.getParent().getChildAt(1), string);
                }
                ObjStoreDestCObj objStoreDestCObj = new ObjStoreDestCObj((ObjStoreCObj)consoleObj.getParent(), string, object2);
                this.app.getExplorer().addToParent(consoleObj, objStoreDestCObj);
                this.app.getInspector().refresh();
                this.app.getStatusArea().appendText(acr.getString("A6007", string, objStore.getID()));
                if (objAdminEvent.isOKAction()) {
                    this.objStoreDestAddDialog.hide();
                }
            }
        }
    }

    private void doAddConnFactory(ObjAdminEvent objAdminEvent, ConsoleObj consoleObj) {
        Object object = null;
        ObjStore objStore = objAdminEvent.getObjStore();
        int n = objAdminEvent.getFactoryType();
        String string = objAdminEvent.getLookupName();
        Properties properties = objAdminEvent.getObjProperties();
        boolean bl = objAdminEvent.isReadOnly();
        boolean bl2 = false;
        if (objStore.isOpen()) {
            Object object2 = null;
            try {
                if (n == 3) {
                    object2 = JMSObjFactory.createQueueConnectionFactory(properties);
                } else if (n == 4) {
                    object2 = JMSObjFactory.createTopicConnectionFactory(properties);
                } else if (n == 7) {
                    object2 = JMSObjFactory.createConnectionFactory(properties);
                } else if (n == 5) {
                    object2 = JMSObjFactory.createXAQueueConnectionFactory(properties);
                } else if (n == 6) {
                    object2 = JMSObjFactory.createXATopicConnectionFactory(properties);
                } else if (n == 8) {
                    object2 = JMSObjFactory.createXAConnectionFactory(properties);
                }
            }
            catch (Exception exception) {
                this.handleExceptions(exception, "A1130");
                return;
            }
            if (bl) {
                JMSObjFactory.doReadOnlyForAdd(object2, "true");
            } else {
                JMSObjFactory.doReadOnlyForAdd(object2, "false");
            }
            try {
                object = objStore.retrieve(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1130"), 0, 0, null, close, close[0]);
                return;
            }
            if (object != null) {
                int n2 = JOptionPane.showConfirmDialog(this.app.getFrame(), acr.getString("A5002", string), acr.getString("A1130"), 0);
                if (n2 == 1) {
                    return;
                }
                bl2 = true;
            }
            try {
                objStore.add(string, object2, true);
            }
            catch (Exception exception) {
                JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1130"), 0, 0, null, close, close[0]);
                return;
            }
            if (objStore != null) {
                if (bl2) {
                    this.removeChild(consoleObj, string);
                    this.removeChild((ConsoleObj)consoleObj.getParent().getChildAt(0), string);
                }
                ObjStoreConFactoryCObj objStoreConFactoryCObj = new ObjStoreConFactoryCObj((ObjStoreCObj)consoleObj.getParent(), string, object2);
                this.app.getExplorer().addToParent(consoleObj, objStoreConFactoryCObj);
                this.app.getInspector().refresh();
                this.app.getStatusArea().appendText(acr.getString("A6008", string, objStore.getID()));
                if (objAdminEvent.isOKAction()) {
                    this.objStoreConFactoryAddDialog.hide();
                }
            }
        }
    }

    private void removeChild(ConsoleObj consoleObj, String string) {
        Enumeration<TreeNode> enumeration = consoleObj.children();
        while (enumeration.hasMoreElements()) {
            ConsoleObj consoleObj2 = (ConsoleObj)enumeration.nextElement();
            if (!consoleObj2.toString().equals(string)) continue;
            this.app.getExplorer().removeFromParent(consoleObj2);
            enumeration = consoleObj.children();
        }
    }

    private void loadObjStoreList() {
        ConsoleObjStoreManager consoleObjStoreManager = (ConsoleObjStoreManager)this.app.getObjStoreListCObj().getObjStoreManager();
        try {
            consoleObjStoreManager.setFileName(OBJSTORELIST_FILENAME);
            consoleObjStoreManager.readObjStoresFromFile();
        }
        catch (Exception exception) {
            String string = acr.getString("A3014", exception.getMessage());
            JOptionPane.showOptionDialog(this.app.getFrame(), string, acr.getString("A1521") + ": " + acr.getString("A1218", "A3014"), 0, 0, null, close, close[0]);
        }
        Vector vector = consoleObjStoreManager.getAllStores();
        for (int i = 0; i < vector.size(); ++i) {
            ObjStore objStore = (ObjStore)vector.get(i);
            ObjStoreCObj objStoreCObj = new ObjStoreCObj(objStore);
            if (objStore.isOpen()) {
                this.readObjStore(objStoreCObj, consoleObjStoreManager, objStore);
            }
            this.app.getExplorer().addObjStore(objStoreCObj);
        }
        this.app.getInspector().refresh();
    }

    private void saveObjStoreList() {
        ConsoleObjStoreManager consoleObjStoreManager = (ConsoleObjStoreManager)this.app.getObjStoreListCObj().getObjStoreManager();
        try {
            consoleObjStoreManager.setFileName(OBJSTORELIST_FILENAME);
            consoleObjStoreManager.writeObjStoresToFile();
        }
        catch (Exception exception) {
            String string = acr.getString("A3015", exception.getMessage());
            String[] stringArray = new String[2];
            stringArray[0] = acr.getString("A1081");
            stringArray[1] = acr.getString("A1086");
            String[] stringArray2 = stringArray;
            JOptionPane.showOptionDialog(this.app.getFrame(), string, acr.getString("A1088") + ": " + acr.getString("A1218", "A3015"), 0, 0, null, close, close[0]);
        }
    }

    public void handleConsoleActionEvents(ConsoleActionEvent consoleActionEvent) {
        int n = consoleActionEvent.getType();
        switch (n) {
            case 5: {
                this.doRefresh();
            }
        }
    }

    private void doRefresh() {
        ConsoleObj consoleObj = this.app.getSelectedObj();
        if (consoleObj instanceof ObjStoreCObj) {
            this.doRefreshObjStore(consoleObj);
        } else if (consoleObj instanceof ObjStoreDestListCObj) {
            this.doRefreshObjStore(consoleObj);
        } else if (consoleObj instanceof ObjStoreDestCObj) {
            ObjStoreDestCObj objStoreDestCObj = (ObjStoreDestCObj)consoleObj;
            ObjStoreCObj objStoreCObj = objStoreDestCObj.getObjStoreCObj();
            this.doRefreshObjStore(objStoreCObj.getObjStoreDestListCObj());
        } else if (consoleObj instanceof ObjStoreConFactoryListCObj) {
            this.doRefreshObjStore(consoleObj);
        } else if (consoleObj instanceof ObjStoreConFactoryCObj) {
            ObjStoreConFactoryCObj objStoreConFactoryCObj = (ObjStoreConFactoryCObj)consoleObj;
            ObjStoreCObj objStoreCObj = objStoreConFactoryCObj.getObjStoreCObj();
            this.doRefreshObjStore(objStoreCObj.getObjStoreConFactoryListCObj());
        }
    }

    private void doRefreshConnFactory(ConsoleObj consoleObj) {
        ObjStore objStore = ((ObjStoreConFactoryCObj)consoleObj).getObjStore();
        String string = ((ObjStoreConFactoryCObj)consoleObj).getLookupName();
        Object object = null;
        try {
            object = objStore.retrieve(string);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1104"), 0, 0, null, close, close[0]);
            return;
        }
        ((ObjStoreConFactoryCObj)consoleObj).setObject(object);
        this.app.getStatusArea().appendText(acr.getString("A6032", consoleObj.toString(), objStore.getID()));
        this.app.getInspector().selectedObjectUpdated();
    }

    private void doRefreshDestination(ConsoleObj consoleObj) {
        ObjStore objStore = ((ObjStoreDestCObj)consoleObj).getObjStore();
        String string = ((ObjStoreDestCObj)consoleObj).getLookupName();
        Object object = null;
        try {
            object = objStore.retrieve(string);
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString("A1103"), 0, 0, null, close, close[0]);
            return;
        }
        ((ObjStoreDestCObj)consoleObj).setObject(object);
        this.app.getStatusArea().appendText(acr.getString("A6031", consoleObj.toString(), objStore.getID()));
        this.app.getInspector().selectedObjectUpdated();
    }

    private void doRefreshObjStore(ConsoleObj consoleObj) {
        ObjStore objStore = null;
        ConsoleObj consoleObj2 = consoleObj;
        if (consoleObj instanceof ObjStoreCObj) {
            objStore = ((ObjStoreCObj)consoleObj).getObjStore();
            consoleObj2 = consoleObj;
        } else if (consoleObj instanceof ObjStoreDestListCObj) {
            objStore = ((ObjStoreDestListCObj)consoleObj).getObjStore();
            consoleObj2 = (ConsoleObj)consoleObj.getParent();
        } else if (consoleObj instanceof ObjStoreConFactoryListCObj) {
            objStore = ((ObjStoreConFactoryListCObj)consoleObj).getObjStore();
            consoleObj2 = (ConsoleObj)consoleObj.getParent();
        }
        if (!objStore.isOpen()) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3006", consoleObj.toString()), acr.getString("A1102") + ": " + acr.getString("A1218", "A3006"), 0, 0, null, close, close[0]);
            return;
        }
        boolean bl = this.finishDoConnectObjStore(consoleObj2, objStore);
        if (bl) {
            this.controller.setActions(consoleObj);
            this.app.getInspector().refresh();
            if (consoleObj instanceof ObjStoreCObj) {
                this.app.getStatusArea().appendText(acr.getString("A6028", objStore.getID()));
            } else if (consoleObj instanceof ObjStoreDestListCObj) {
                this.app.getStatusArea().appendText(acr.getString("A6029", objStore.getID()));
            } else if (consoleObj instanceof ObjStoreConFactoryListCObj) {
                this.app.getStatusArea().appendText(acr.getString("A6030", objStore.getID()));
            }
        }
    }

    private void handleExceptions(Exception exception, String string) {
        if (exception instanceof InvalidPropertyException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3042", exception.getMessage()), acr.getString(string) + ": " + acr.getString("A1218", "A3042"), 0, 0, null, close, close[0]);
        } else if (exception instanceof InvalidPropertyValueException) {
            JOptionPane.showOptionDialog(this.app.getFrame(), acr.getString("A3043", exception.getMessage()), acr.getString(string) + ": " + acr.getString("A1218", "A3043"), 0, 0, null, close, close[0]);
        } else {
            JOptionPane.showOptionDialog(this.app.getFrame(), exception.toString(), acr.getString(string), 0, 0, null, close, close[0]);
        }
    }

    private void closeObjStore(ObjStore objStore, ConsoleObj consoleObj) {
        if (objStore == null) {
            return;
        }
        try {
            if (objStore.isOpen()) {
                objStore.close();
                if (consoleObj instanceof ObjStoreCObj) {
                    this.clearStore(consoleObj);
                    this.app.getExplorer().nodeChanged(consoleObj);
                    this.app.getInspector().refresh();
                    this.controller.setActions(consoleObj);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

