/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.util.Arrays;
import java.util.Random;

public class UniqueID {
    static final int PREFIX_BITS = 16;
    static final int TIMESTAMP_BITS = 40;
    static final int COUNTER_BITS = 8;
    static final long MAX_SLEEP_SHIFT = 7000L;
    static long max_sleep_shift = 7000L;
    static final long WRAP_TIME = 0xFFFFFFFFFFL;
    static final long TIMESTAMP_MASK = 0xFFFFFFFFFFL;
    static final int MAX_COUNTER = 255;
    static long last_timestamp = 0L;
    static short counter = 0;
    static long counter_wraps = 0L;
    static long timestamp_advances = 0L;
    static long timestamp_delays = 0L;

    public static long generateID() {
        return UniqueID.generateID((short)0);
    }

    public static synchronized long generateID(short s) {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        if (l2 > last_timestamp) {
            last_timestamp = l2;
            counter = 0;
        } else if (l2 < last_timestamp) {
            long l3 = last_timestamp - l2;
            if (l3 <= max_sleep_shift) {
                while (l2 <= last_timestamp) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(last_timestamp - l2);
                        ++timestamp_delays;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    l2 = System.currentTimeMillis();
                }
            } else {
                l2 = last_timestamp + 1L;
                if (++timestamp_advances % 200L == 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            last_timestamp = l2;
            counter = 0;
        } else if (counter < 255) {
            counter = (short)(counter + 1);
        } else {
            counter = 0;
            ++counter_wraps;
            while (l2 <= last_timestamp) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l2 = System.currentTimeMillis();
            }
            last_timestamp = l2;
        }
        l = s;
        l <<= 48;
        l2 = (l2 & 0xFFFFFFFFFFL) << 8;
        l |= l2;
        if ((l |= (long)counter) == 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            l = UniqueID.generateID(s);
        }
        return l;
    }

    public static long age(long l) {
        return UniqueID.age(l, System.currentTimeMillis());
    }

    public static long age(long l, long l2) {
        long l3 = l2;
        long l4 = UniqueID.getTimestamp(l);
        if ((l3 &= 0xFFFFFFFFFFL) > l4) {
            return l3 - l4;
        }
        return l3 + (0xFFFFFFFFFFL - l4);
    }

    public static String toString(long l) {
        return UniqueID.getPrefix(l) + "_" + UniqueID.getTimestamp(l) + "_" + UniqueID.getCounter(l);
    }

    public static String toShortString(long l) {
        return String.valueOf(UniqueID.getPrefix(l)) + String.valueOf(UniqueID.getTimestamp(l)) + String.valueOf(UniqueID.getCounter(l));
    }

    public static void setMaxSleepShift(long l) {
        max_sleep_shift = l;
    }

    public static synchronized String toLongString(long l) {
        return "ID:" + UniqueID.toString(l) + "\n" + "       PREFIX_BITS = " + 16 + "\n" + "    TIMESTAMP_BITS = " + 40 + "\n" + "      COUNTER_BITS = " + 8 + "\n" + "    TIMESTAMP_MASK = " + Long.toHexString(0xFFFFFFFFFFL) + "\n" + "       MAX_COUNTER = " + 255 + "\n" + "   max_sleep_shift = " + max_sleep_shift + "\n" + "    last_timestamp = " + last_timestamp + "\n" + "           counter = " + counter + "\n" + "     counter_wraps = " + counter_wraps + "\n" + "timestamp_advances = " + timestamp_advances + "\n" + "  timestamp_delays = " + timestamp_delays;
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static synchronized boolean diagnostic(int n, short s) {
        System.out.println("----- UniqueID diagnostics -----");
        System.out.println("Generating one ID. prefix = " + s);
        counter_wraps = 0L;
        timestamp_advances = 0L;
        timestamp_delays = 0L;
        boolean bl = true;
        long l = System.currentTimeMillis();
        long l2 = UniqueID.generateID(s);
        System.out.println(" ID:" + l2 + " (" + UniqueID.toString(l2) + ")");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis();
        System.out.println("Age:" + UniqueID.age(l2) + " ms (should be  ~" + (l3 - l) + " ms)");
        if (s == UniqueID.getPrefix(l2)) {
            System.out.println("Prefix=" + s + "=" + UniqueID.getPrefix(l2));
        } else {
            System.out.println("ERROR! Prefix=" + s + "!=" + UniqueID.getPrefix(l2));
            bl = false;
        }
        if ((last_timestamp & 0xFFFFFFFFFFL) == UniqueID.getTimestamp(l2)) {
            System.out.println("Timestamp=" + (last_timestamp & 0xFFFFFFFFFFL) + "=" + UniqueID.getTimestamp(l2));
        } else {
            System.out.println("ERROR! Timestamp=" + (last_timestamp & 0xFFFFFFFFFFL) + "!=" + UniqueID.getTimestamp(l2));
            bl = false;
        }
        if (counter == UniqueID.getCounter(l2)) {
            System.out.println("Counter=" + counter + "=" + UniqueID.getCounter(l2));
        } else {
            System.out.println("ERROR! Counter=" + counter + "!=" + UniqueID.getCounter(l2));
            bl = false;
        }
        long[] lArray = new long[n];
        System.out.println("Generating " + n + " IDs...");
        long l4 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            lArray[i] = UniqueID.generateID(s);
        }
        long l5 = System.currentTimeMillis();
        System.out.println("Called getID() " + n + " times in " + (l5 - l4) + " ms (" + (float)n / (float)(l5 - l4) * 1000.0f + " ids per second)");
        System.out.println(UniqueID.toLongString(0L));
        System.out.println("Sorting ids...");
        Arrays.sort(lArray);
        long l6 = 0L;
        System.out.println("Checking ids for dups...");
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == l6) {
                System.out.println("ERROR! Duplicate ID: " + l6);
                ++n2;
                bl = false;
            }
            if (lArray[i] == 0L) {
                System.out.println("ERROR! Zero ID: " + lArray[i]);
                bl = false;
            }
            l6 = lArray[i];
        }
        if (n2 == 0) {
            System.out.println("Passed -- no duplicates detected");
        }
        System.out.println("Done");
        return bl;
    }

    public static long getTimestamp(long l) {
        return l >>> 8 & 0xFFFFFFFFFFL;
    }

    public static short getPrefix(long l) {
        return (short)(l >>> 48);
    }

    private static short getCounter(long l) {
        return (short)(l & 0xFFL);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 10000;
        Random random = new Random();
        int n3 = random.nextInt();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-n")) {
                n2 = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (stringArray[n].equals("-p")) {
                n3 = Integer.parseInt(stringArray[++n]);
                continue;
            }
            System.out.println("-n <itertions>  -p <prefix>");
            System.exit(1);
        }
        System.out.println("Starting UID test...");
        n = UniqueID.diagnostic(n2, (short)n3) ? 1 : 0;
        if (n != 0) {
            System.out.println("PASSED");
            System.exit(0);
        } else {
            System.out.println("FALIED");
            System.exit(1);
        }
    }
}

